/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.fields.code.parsers;

import org.eclipse.scout.sdk.ui.extensions.ICodeIdParser;

public abstract class AbstractNumberCodeIdParser
implements ICodeIdParser {
    private final String m_numTypeSuffixLo;
    private final String m_numTypeSuffixUp;

    protected AbstractNumberCodeIdParser() {
        this(null);
    }

    protected AbstractNumberCodeIdParser(Character numTypeSuffix) {
        if (numTypeSuffix != null) {
            this.m_numTypeSuffixLo = ("" + numTypeSuffix).toLowerCase();
            this.m_numTypeSuffixUp = ("" + numTypeSuffix).toUpperCase();
        } else {
            this.m_numTypeSuffixLo = null;
            this.m_numTypeSuffixUp = null;
        }
    }

    protected abstract void parseNum(String var1) throws NumberFormatException;

    @Override
    public boolean isValid(String val) {
        try {
            if (this.m_numTypeSuffixLo != null && this.m_numTypeSuffixUp != null) {
                val = val.replaceAll("[" + this.m_numTypeSuffixUp + this.m_numTypeSuffixLo + "]{0,1}$", "");
            }
            this.parseNum(val);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public String getSource(String val) {
        if (val == null) {
            return null;
        }
        if (this.m_numTypeSuffixLo != null && val.toLowerCase().endsWith(this.m_numTypeSuffixLo)) {
            return val;
        }
        if (this.m_numTypeSuffixLo == null) {
            return val;
        }
        return String.valueOf(val) + this.m_numTypeSuffixUp;
    }
}

