/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkingSet;

public final class ScoutExplorerSettingsSupport {
    private static final ScoutExplorerSettingsSupport INSTANCE = new ScoutExplorerSettingsSupport();
    public static final String SCOUT_WOKRING_SET_ID = "org.eclipse.scout.sdk.ui.workingSet";
    public static final String PREF_BUNDLE_DISPLAY_STYLE_KEY = "org.eclipse.scout.sdk.ui.view.scoutExplorer.bundleDisplayStyle";
    public static final String PREF_SHOW_FRAGMENTS_KEY = "org.eclipse.scout.sdk.view.ui.scoutExplorer.showFragments";
    public static final String PREF_SHOW_BINARY_BUNDLES_KEY = "org.eclipse.scout.sdk.ui.view.scoutExplorer.showBinaryBundles";
    public static final String PREF_HIDDEN_BUNDLES_TYPES = "org.eclipse.scout.sdk.ui.view.scoutExplorer.hiddenBundleTypes";
    public static final String PREF_HIDDEN_WORKING_SETS = "org.eclipse.scout.sdk.ui.view.scoutExplorer.hiddenWorkingSets";
    public static final String PREF_WORKING_SETS_ORDER = "org.eclipse.scout.sdk.ui.view.scoutExplorer.workingSetsOrder";
    private static final String DISPLAY_STYLE_GROUPED = "grouped";
    private static final String DISPLAY_STYLE_HIERARCHICAL = "hierarchical";
    private static final String DISPLAY_STYLE_FLAT = "flat";
    private static final String DISPLAY_STYLE_WORKING_SET = "workingSet";
    private static final String SHOW_FRAGMENTS_ENABLED = "true";
    private static final String SHOW_FRAGMENTS_DISABLED = "false";
    private static final String SHOW_BINARY_BUNDLES_ENABLED = "true";
    private static final String SHOW_BINARY_BUNDLES_DISABLED = "false";
    public static final char DELIMITER = ',';
    public static final String OTHER_PROJECTS_WORKING_SET_NAME = "Other Projects";
    private BundlePresentation m_bundlePresentation;
    private boolean m_showFragments;
    private boolean m_showBinaryBundles;
    private Set<String> m_hiddenBundleTypes;
    private Set<String> m_hiddenWorkingSets;
    private String[] m_workingSetsOrder;

    public static ScoutExplorerSettingsSupport get() {
        return INSTANCE;
    }

    private ScoutExplorerSettingsSupport() {
        IPreferenceStore preferenceStore = ScoutExplorerSettingsSupport.getStore();
        preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (ScoutExplorerSettingsSupport.PREF_BUNDLE_DISPLAY_STYLE_KEY.equals(event.getProperty()) || ScoutExplorerSettingsSupport.PREF_SHOW_FRAGMENTS_KEY.equals(event.getProperty()) || ScoutExplorerSettingsSupport.PREF_SHOW_BINARY_BUNDLES_KEY.equals(event.getProperty()) || ScoutExplorerSettingsSupport.PREF_HIDDEN_BUNDLES_TYPES.equals(event.getProperty()) || ScoutExplorerSettingsSupport.PREF_HIDDEN_WORKING_SETS.equals(event.getProperty()) || ScoutExplorerSettingsSupport.PREF_WORKING_SETS_ORDER.equals(event.getProperty())) {
                    ScoutExplorerSettingsSupport.this.readFromStore();
                }
            }
        });
        this.readFromStore();
    }

    private synchronized void readFromStore() {
        IPreferenceStore preferenceStore = ScoutExplorerSettingsSupport.getStore();
        String displayStyle = preferenceStore.getString(PREF_BUNDLE_DISPLAY_STYLE_KEY);
        this.setBundlePresentation(ScoutExplorerSettingsSupport.parseBundlePresentation(displayStyle));
        String showFragments = preferenceStore.getString(PREF_SHOW_FRAGMENTS_KEY);
        this.setShowFragments("true".equals(showFragments));
        String showBinaryBundles = preferenceStore.getString(PREF_SHOW_BINARY_BUNDLES_KEY);
        this.setShowBinaryBundles(!"false".equals(showBinaryBundles));
        this.m_hiddenBundleTypes = ScoutExplorerSettingsSupport.parseListProperty(PREF_HIDDEN_BUNDLES_TYPES);
        this.m_hiddenWorkingSets = ScoutExplorerSettingsSupport.parseListProperty(PREF_HIDDEN_WORKING_SETS);
        Set<String> list = ScoutExplorerSettingsSupport.parseListProperty(PREF_WORKING_SETS_ORDER);
        this.m_workingSetsOrder = list.toArray(new String[list.size()]);
    }

    private static Set<String> parseListProperty(String propertyName) {
        String prop = ScoutExplorerSettingsSupport.getStore().getString(propertyName);
        String[] tokens = null;
        if (StringUtility.hasText((String)prop)) {
            tokens = prop.split(",");
        }
        return ScoutExplorerSettingsSupport.toSet(tokens);
    }

    private static Set<String> toSet(String[] elements) {
        LinkedHashSet<String> items = new LinkedHashSet<String>();
        if (elements != null && elements.length > 0) {
            String[] stringArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (StringUtility.hasText((String)s)) {
                    items.add(s.trim());
                }
                ++n2;
            }
        }
        return items;
    }

    private static void storeListProperty(Iterable<String> oldItems, Iterable<String> newItems, String propertyName) {
        int lastPos;
        if (CompareUtility.equals(oldItems, newItems)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : newItems) {
            if (!StringUtility.hasText((String)s)) continue;
            sb.append(s.trim());
            sb.append(',');
        }
        if (sb.length() > 1 && ',' == sb.charAt(lastPos = sb.length() - 1)) {
            sb.deleteCharAt(lastPos);
        }
        ScoutExplorerSettingsSupport.persist(propertyName, sb.toString(), oldItems, newItems);
    }

    private static BundlePresentation parseBundlePresentation(String input) {
        if (DISPLAY_STYLE_FLAT.equals(input)) {
            return BundlePresentation.Flat;
        }
        if (DISPLAY_STYLE_HIERARCHICAL.equals(input)) {
            return BundlePresentation.Hierarchical;
        }
        if (DISPLAY_STYLE_WORKING_SET.equals(input)) {
            return BundlePresentation.WorkingSet;
        }
        return BundlePresentation.Grouped;
    }

    private static String getBundlePresentationString(BundlePresentation input) {
        if (BundlePresentation.Flat.equals((Object)input)) {
            return DISPLAY_STYLE_FLAT;
        }
        if (BundlePresentation.Hierarchical.equals((Object)input)) {
            return DISPLAY_STYLE_HIERARCHICAL;
        }
        if (BundlePresentation.WorkingSet.equals((Object)input)) {
            return DISPLAY_STYLE_WORKING_SET;
        }
        return DISPLAY_STYLE_GROUPED;
    }

    private static IPreferenceStore getStore() {
        return ScoutSdkUi.getDefault().getPreferenceStore();
    }

    private static void persist(String key, String value, Object oldVal, Object newVal) {
        IPreferenceStore preferenceStore = ScoutExplorerSettingsSupport.getStore();
        preferenceStore.putValue(key, value);
        preferenceStore.firePropertyChangeEvent(key, oldVal, newVal);
    }

    public synchronized BundlePresentation getBundlePresentation() {
        return this.m_bundlePresentation;
    }

    public synchronized void setBundlePresentation(BundlePresentation bundlePresentation) {
        BundlePresentation old = this.m_bundlePresentation;
        this.m_bundlePresentation = bundlePresentation;
        if (old != this.m_bundlePresentation) {
            ScoutExplorerSettingsSupport.persist(PREF_BUNDLE_DISPLAY_STYLE_KEY, ScoutExplorerSettingsSupport.getBundlePresentationString(this.m_bundlePresentation), (Object)old, (Object)this.m_bundlePresentation);
        }
    }

    public synchronized boolean isShowFragments() {
        return this.m_showFragments;
    }

    public synchronized void setShowFragments(boolean showFragments) {
        boolean old = this.m_showFragments;
        this.m_showFragments = showFragments;
        if (old != this.m_showFragments) {
            ScoutExplorerSettingsSupport.persist(PREF_SHOW_FRAGMENTS_KEY, showFragments ? "true" : "false", old, this.m_showFragments);
        }
    }

    public synchronized boolean isShowBinaryBundles() {
        return this.m_showBinaryBundles;
    }

    public synchronized void setShowBinaryBundles(boolean showBinaryBundles) {
        boolean old = this.m_showBinaryBundles;
        this.m_showBinaryBundles = showBinaryBundles;
        if (old != this.m_showBinaryBundles) {
            ScoutExplorerSettingsSupport.persist(PREF_SHOW_BINARY_BUNDLES_KEY, this.m_showBinaryBundles ? "true" : "false", old, this.m_showBinaryBundles);
        }
    }

    public synchronized boolean isBundleTypeHidden(String type) {
        return this.m_hiddenBundleTypes.contains(type);
    }

    public synchronized void addHiddenBundleType(String type) {
        HashSet<String> old = new HashSet<String>(this.m_hiddenBundleTypes);
        boolean added = this.m_hiddenBundleTypes.add(type);
        if (added) {
            ScoutExplorerSettingsSupport.storeListProperty(old, this.m_hiddenBundleTypes, PREF_HIDDEN_BUNDLES_TYPES);
        }
    }

    public synchronized void removeHiddenBundleType(String type) {
        HashSet<String> old = new HashSet<String>(this.m_hiddenBundleTypes);
        boolean removed = this.m_hiddenBundleTypes.remove(type);
        if (removed) {
            ScoutExplorerSettingsSupport.storeListProperty(old, this.m_hiddenBundleTypes, PREF_HIDDEN_BUNDLES_TYPES);
        }
    }

    public synchronized void setWorkingSetsOrder(IWorkingSet[] order) {
        String[] oldOrder = this.m_workingSetsOrder;
        String[] newOrder = new String[order.length];
        int i = 0;
        while (i < newOrder.length) {
            newOrder[i] = order[i].getName();
            ++i;
        }
        if (CompareUtility.notEquals((Object)oldOrder, (Object)newOrder)) {
            this.m_workingSetsOrder = newOrder;
            ScoutExplorerSettingsSupport.storeListProperty(ScoutExplorerSettingsSupport.toList(oldOrder), ScoutExplorerSettingsSupport.toList(this.m_workingSetsOrder), PREF_WORKING_SETS_ORDER);
        }
    }

    private static <T> List<T> toList(T[] elements) {
        ArrayList<T> result = new ArrayList<T>();
        if (elements != null && elements.length > 0) {
            T[] TArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                T e = TArray[n2];
                result.add(e);
                ++n2;
            }
        }
        return result;
    }

    private int getOrder(String workingSetName) {
        int i = 0;
        while (i < this.m_workingSetsOrder.length) {
            if (CompareUtility.equals((Object)this.m_workingSetsOrder[i], (Object)workingSetName)) {
                return i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    public synchronized void setHiddenScoutWorkingSets(IWorkingSet[] hiddenSets) {
        HashSet<String> old = new HashSet<String>(this.m_hiddenWorkingSets);
        HashSet<String> newHidden = new HashSet<String>(hiddenSets.length);
        IWorkingSet[] iWorkingSetArray = hiddenSets;
        int n = hiddenSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet s = iWorkingSetArray[n2];
            newHidden.add(s.getName());
            ++n2;
        }
        if (CompareUtility.notEquals(old, newHidden)) {
            this.m_hiddenWorkingSets = newHidden;
            ScoutExplorerSettingsSupport.storeListProperty(old, this.m_hiddenWorkingSets, PREF_HIDDEN_WORKING_SETS);
        }
    }

    public synchronized IWorkingSet[] getScoutWorkingSets(boolean includeHidden) {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] allWorkingSets = workingSetManager.getAllWorkingSets();
        HashSet<Object> result = new HashSet<Object>(allWorkingSets.length + 1);
        HashSet<IScoutBundle> bundlesThatBelongToASet = new HashSet<IScoutBundle>();
        IWorkingSet[] iWorkingSetArray = allWorkingSets;
        int n = allWorkingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet ws = iWorkingSetArray[n2];
            IWorkingSet fws = this.filterWorkingSet(ws, includeHidden);
            if (fws != null) {
                result.add(fws);
            }
            IAdaptable[] iAdaptableArray = ws.getElements();
            int n3 = iAdaptableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable a = iAdaptableArray[n4];
                IScoutBundle b = (IScoutBundle)a.getAdapter(IScoutBundle.class);
                if (b != null) {
                    bundlesThatBelongToASet.add(b);
                }
                ++n4;
            }
            ++n2;
        }
        IScoutBundle[] unAssignedBundles = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getNotInListFilter(bundlesThatBelongToASet));
        WorkingSet others = new WorkingSet(OTHER_PROJECTS_WORKING_SET_NAME, OTHER_PROJECTS_WORKING_SET_NAME, (IAdaptable[])unAssignedBundles);
        others.setId(SCOUT_WOKRING_SET_ID);
        others = this.filterWorkingSet((IWorkingSet)others, includeHidden);
        if (others != null) {
            result.add(others);
        }
        IWorkingSet[] array = result.toArray(new IWorkingSet[result.size()]);
        Arrays.sort(array, new Comparator<IWorkingSet>(){

            @Override
            public int compare(IWorkingSet o1, IWorkingSet o2) {
                int order1 = ScoutExplorerSettingsSupport.this.getOrder(o1.getName());
                int order2 = ScoutExplorerSettingsSupport.this.getOrder(o2.getName());
                return order1 - order2;
            }
        });
        return array;
    }

    private IWorkingSet filterWorkingSet(IWorkingSet ws, boolean includeHidden) {
        if (ws.isVisible() && SCOUT_WOKRING_SET_ID.equals(ws.getId()) && (includeHidden || !this.m_hiddenWorkingSets.contains(ws.getName()))) {
            return ws;
        }
        return null;
    }

    public static enum BundlePresentation {
        Grouped,
        Hierarchical,
        Flat,
        WorkingSet;

    }
}

