/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformSearchFormsOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.MultipleUpdateFormDataAction;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.SearchFormNewAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class SearchFormTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_searchFormHierarchy;

    public SearchFormTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"SearchFormTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("searchForms.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_searchFormHierarchy != null) {
            this.m_searchFormHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_searchFormHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_searchFormHierarchy != null) {
            this.m_searchFormHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.SearchTablePage";
    }

    @Override
    public void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveSearchForms();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType searchForm = iTypeArray[n2];
            FormNodePage form = new FormNodePage(this, searchForm);
            form.setImageDescriptor(ScoutSdkUi.getImageDescriptor("searchForm.png"));
            ++n2;
        }
    }

    protected IType[] resolveSearchForms() {
        IType iSearchForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
        if (this.m_searchFormHierarchy == null) {
            this.m_searchFormHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iSearchForm);
            this.m_searchFormHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] searchForms = this.m_searchFormHierarchy.getAllSubtypes(iSearchForm, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{this.getScoutBundle()}), TypeComparators.getTypeNameComparator());
        return searchForms;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{WellformAction.class, SearchFormNewAction.class, MultipleUpdateFormDataAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof WellformAction) {
            WellformAction action = (WellformAction)menu;
            action.setOperation((IOperation)new WellformSearchFormsOperation(this.getScoutBundle()));
            action.setScoutBundle(this.getScoutBundle());
            action.setLabel(Texts.get((String)"WellformAllSearchForms"));
        } else if (menu instanceof SearchFormNewAction) {
            ((SearchFormNewAction)menu).init(this.getScoutBundle());
        } else if (menu instanceof MultipleUpdateFormDataAction) {
            ((MultipleUpdateFormDataAction)menu).init(new ITypeResolver(){

                @Override
                public IType[] getTypes() {
                    return SearchFormTablePage.this.resolveSearchForms();
                }
            }, this.getScoutBundle());
        }
    }
}

