/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedContextPropertyTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class ServerSessionNodePage
extends AbstractScoutTypePage {
    public ServerSessionNodePage(IPage parent, IType type) {
        this.setParent(parent);
        this.setType(type);
        this.setName(Texts.get((String)"ServerSession"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("serverSession.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ServerSessionNodePage";
    }

    @Override
    protected void loadChildrenImpl() {
        IScoutBundle sharedBundle = this.getScoutBundle().getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false);
        if (sharedBundle != null) {
            IScoutBundle clientBundle = sharedBundle.getChildBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}), false);
            if (clientBundle != null) {
                IType iClientSession = TypeUtility.getType((String)"org.eclipse.scout.rt.client.IClientSession");
                IPrimaryTypeTypeHierarchy clientSessionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iClientSession);
                ITypeFilter filter = ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{clientBundle});
                IType[] allClientSessions = clientSessionHierarchy.getAllSubtypes(iClientSession, filter, TypeComparators.getTypeNameComparator());
                if (allClientSessions.length > 1) {
                    ScoutSdkUi.logError("a client bundle '" + clientBundle + "' can have in maximum 1 client session");
                } else if (allClientSessions.length == 1) {
                    IType clientSession = allClientSessions[0];
                    new SharedContextPropertyTablePage(this, clientSession, this.getType());
                } else {
                    ScoutSdkUi.logInfo("could not find a client session in bundle '" + clientBundle.getSymbolicName() + "'.");
                }
            } else {
                ScoutSdkUi.logInfo("could not find a client bundle name-correspondig to '" + this.getScoutBundle().getSymbolicName() + "'.");
            }
        }
    }
}

