/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.SearchRangeStyledLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class FormViewIdPresenter
extends AbstractProposalPresenter<ViewId> {
    public FormViewIdPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        SearchRangeStyledLabelProvider labelProvider = new SearchRangeStyledLabelProvider(){

            public String getText(Object element) {
                ViewId value = (ViewId)((Object)element);
                switch (value) {
                    case OutlineSelector: {
                        return "Outline Selector";
                    }
                    case PageTable: {
                        return "Page Table";
                    }
                    case PageDetail: {
                        return "Page Detail";
                    }
                    case PageSearch: {
                        return "Page Search";
                    }
                    case NorthEast: {
                        return "Noth-East";
                    }
                    case SouthEast: {
                        return "South-East";
                    }
                    case SouthWest: {
                        return "South-West";
                    }
                    case NothWest: {
                        return "Noth-West";
                    }
                }
                return value.toString();
            }

            public Image getImage(Object element) {
                return ScoutSdkUi.getImage("default.gif");
            }
        };
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        StaticContentProvider provider = new StaticContentProvider((Object[])ViewId.values(), labelProvider);
        this.getProposalField().setContentProvider(provider);
    }

    @Override
    protected ViewId parseInput(String input) throws CoreException {
        String parsedId = PropertyMethodSourceUtility.parseReturnParameterString((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        if (parsedId == null) {
            return null;
        }
        if (parsedId.equals("OUTLINE")) {
            return ViewId.Outline;
        }
        if (parsedId.equals("OUTLINE_SELECTOR")) {
            return ViewId.OutlineSelector;
        }
        if (parsedId.equals("PAGE_TABLE")) {
            return ViewId.PageTable;
        }
        if (parsedId.equals("PAGE_DETAIL")) {
            return ViewId.PageDetail;
        }
        if (parsedId.equals("PAGE_SEARCH")) {
            return ViewId.PageSearch;
        }
        if (parsedId.equals("EDITOR")) {
            return ViewId.Editor;
        }
        if (parsedId.equals("N")) {
            return ViewId.North;
        }
        if (parsedId.equals("NE")) {
            return ViewId.NorthEast;
        }
        if (parsedId.equals("E")) {
            return ViewId.East;
        }
        if (parsedId.equals("SE")) {
            return ViewId.SouthEast;
        }
        if (parsedId.equals("S")) {
            return ViewId.South;
        }
        if (parsedId.equals("SW")) {
            return ViewId.SouthWest;
        }
        if (parsedId.equals("W")) {
            return ViewId.West;
        }
        if (parsedId.equals("NW")) {
            return ViewId.NothWest;
        }
        if (parsedId.equals("C")) {
            return ViewId.Center;
        }
        return null;
    }

    @Override
    protected synchronized void storeValue(ViewId value) throws CoreException {
        if (value == null) {
            value = (ViewId)((Object)this.getDefaultValue());
            this.getProposalField().acceptProposal((Object)value);
        }
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((ViewId)((Object)this.getDefaultValue()), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            StringBuilder source = new StringBuilder("  return ");
            switch (value) {
                case Outline: {
                    source.append("VIEW_ID_OUTLINE");
                    break;
                }
                case OutlineSelector: {
                    source.append("VIEW_ID_OUTLINE_SELECTOR");
                    break;
                }
                case PageTable: {
                    source.append("VIEW_ID_PAGE_TABLE");
                    break;
                }
                case PageDetail: {
                    source.append("VIEW_ID_PAGE_DETAIL");
                    break;
                }
                case PageSearch: {
                    source.append("VIEW_ID_PAGE_SEARCH");
                    break;
                }
                case Editor: {
                    source.append("EDITOR_ID");
                    break;
                }
                case North: {
                    source.append("VIEW_ID_N");
                    break;
                }
                case NorthEast: {
                    source.append("VIEW_ID_NE");
                    break;
                }
                case East: {
                    source.append("VIEW_ID_E");
                    break;
                }
                case SouthEast: {
                    source.append("VIEW_ID_SE");
                    break;
                }
                case South: {
                    source.append("VIEW_ID_S");
                    break;
                }
                case SouthWest: {
                    source.append("VIEW_ID_SW");
                    break;
                }
                case West: {
                    source.append("VIEW_ID_W");
                    break;
                }
                case NothWest: {
                    source.append("VIEW_ID_NW");
                    break;
                }
                case Center: {
                    source.append("VIEW_ID_CENTER");
                }
            }
            source.append(";");
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), source.toString(), true);
        }
        if (op != null) {
            new OperationJob(new IOperation[]{op}).schedule();
        }
    }

    public static enum ViewId {
        Outline,
        OutlineSelector,
        PageTable,
        PageDetail,
        PageSearch,
        Editor,
        North,
        NorthEast,
        East,
        SouthEast,
        South,
        SouthWest,
        West,
        NothWest,
        Center;

    }
}

