/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.icon.IIconProvider;
import org.eclipse.scout.sdk.icon.ScoutIconDesc;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.icon.IconContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.icon.IconLabelProvider;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class IconPresenter
extends AbstractMethodPresenter {
    private static final Pattern REGEX = Pattern.compile("^.*\\.([^\\.]+)$");
    private Label m_currentIconPresenter;
    private ProposalTextField m_proposalField;
    private IIconProvider m_iconProvider;
    private ScoutIconDesc m_defaultIcon;
    private OptimisticLock storeValueLock = new OptimisticLock();
    private ScoutIconDesc m_currentSourceIcon;

    public IconPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected Control createContent(Composite container) {
        Composite rootPane = this.getToolkit().createComposite(container);
        this.m_currentIconPresenter = this.getToolkit().createLabel(rootPane, "", 0x800000);
        this.m_proposalField = this.getToolkit().createProposalField(rootPane, ProposalTextField.STYLE_NO_LABEL);
        this.toolkitAdapt((Control)this.m_proposalField);
        this.m_proposalField.setLabelProvider((IBaseLabelProvider)new IconLabelProvider(this.m_proposalField.getDisplay()));
        this.m_proposalField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                IconPresenter.this.handleProposalAccepted(event);
            }
        });
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.verticalSpacing = 0;
        rootPane.setLayout((Layout)gLayout);
        this.m_proposalField.setLayoutData(new GridData(768));
        GridData gData = new GridData(22, 22);
        gData.exclude = true;
        this.m_currentIconPresenter.setLayoutData((Object)gData);
        return rootPane;
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        if (method == null) {
            return;
        }
        super.init(method);
        IIconProvider newIconProvider = ScoutTypeUtility.findIconProvider((IJavaElement)method.getType());
        if (!CompareUtility.equals((Object)newIconProvider, (Object)this.m_iconProvider)) {
            this.m_iconProvider = newIconProvider;
            this.m_proposalField.setContentProvider(new IconContentProvider(this.m_iconProvider, (ILabelProvider)this.m_proposalField.getLabelProvider()));
            this.m_proposalField.setEnabled(this.m_iconProvider != null);
        }
        this.m_defaultIcon = this.parseInput(this.getMethod().computeDefaultValue());
        try {
            this.storeValueLock.acquire();
            this.m_currentSourceIcon = this.parseInput(this.getMethod().computeValue());
            if (this.m_currentSourceIcon != null) {
                this.m_proposalField.acceptProposal(this.m_currentSourceIcon);
            } else {
                this.m_proposalField.acceptProposal(null);
            }
            this.m_proposalField.setEnabled(true);
        }
        finally {
            this.storeValueLock.release();
        }
    }

    protected void handleProposalAccepted(ContentProposalEvent event) {
        Object proposal = event.proposal;
        if (proposal == null) {
            this.m_proposalField.setText("");
            this.storeValue(null);
        } else {
            this.storeValue((ScoutIconDesc)proposal);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_proposalField.setEnabled(enabled && this.getIconProvider() != null);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_proposalField.getEnabled() && super.isEnabled();
        }
        return false;
    }

    public IIconProvider getIconProvider() {
        return this.m_iconProvider;
    }

    protected ScoutIconDesc parseInput(String input) throws CoreException {
        String parsedString = PropertyMethodSourceUtility.parseReturnParameterIcon((String)input, (IMethod)this.getMethod().peekMethod());
        if (this.getIconProvider() != null && !StringUtility.isNullOrEmpty((String)parsedString)) {
            String simpleIconName = REGEX.matcher(parsedString).replaceAll("$1");
            return this.getIconProvider().getIcon(simpleIconName);
        }
        return null;
    }

    public ScoutIconDesc getDefaultValue() {
        return this.m_defaultIcon;
    }

    protected synchronized void storeValue(final ScoutIconDesc value) {
        Object op = null;
        if (UiUtility.equals(this.getDefaultValue(), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), null, true){

                protected String createMethodBody(IMethod methodToOverride, IImportValidator validator) throws JavaModelException {
                    StringBuilder source = new StringBuilder();
                    source.append("return ");
                    if (value != null) {
                        String iconTypeSig = SignatureCache.createTypeSignature((String)value.getConstantField().getDeclaringType().getFullyQualifiedName());
                        source.append("  " + SignatureUtility.getTypeReference((String)iconTypeSig, (IImportValidator)validator) + "." + value.getConstantField().getElementName());
                        source.append(";");
                    } else {
                        source.append("null;");
                    }
                    return source.toString();
                }
            };
        }
        if (op != null) {
            final OperationJob job = new OperationJob(new IOperation[]{op});
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    job.removeJobChangeListener((IJobChangeListener)this);
                    IconPresenter.this.getContainer().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Image icon = null;
                            if (value != null) {
                                icon = ((ILabelProvider)IconPresenter.this.m_proposalField.getLabelProvider()).getImage((Object)value);
                            }
                            if (icon != null) {
                                ((GridData)((IconPresenter)(this).IconPresenter.this).m_currentIconPresenter.getLayoutData()).exclude = false;
                                IconPresenter.this.m_currentIconPresenter.setVisible(true);
                            } else {
                                ((GridData)((IconPresenter)(this).IconPresenter.this).m_currentIconPresenter.getLayoutData()).exclude = true;
                                IconPresenter.this.m_currentIconPresenter.setVisible(false);
                            }
                            IconPresenter.this.m_currentIconPresenter.setImage(icon);
                            IconPresenter.this.getContainer().layout(true, true);
                        }
                    });
                }
            });
            job.schedule();
        }
    }
}

