/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class LabelPositionPresenter
extends AbstractProposalPresenter<LabelPosition> {
    public LabelPositionPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                LabelPosition value = (LabelPosition)((Object)element);
                switch (value) {
                    case OnField: {
                        return "On Field";
                    }
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                LabelPosition value = (LabelPosition)((Object)element);
                switch (value) {
                    case Left: {
                        return ScoutSdkUi.getImage("horizontal_left.gif");
                    }
                    case OnField: {
                        return ScoutSdkUi.getImage("default.gif");
                    }
                    case Right: {
                        return ScoutSdkUi.getImage("horizontal_right.gif");
                    }
                    case Top: {
                        return ScoutSdkUi.getImage("vertical_top.gif");
                    }
                }
                return ScoutSdkUi.getImage("default.gif");
            }
        };
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        StaticContentProvider provider = new StaticContentProvider((Object[])LabelPosition.values(), (ILabelProvider)labelProvider);
        this.getProposalField().setContentProvider(provider);
    }

    @Override
    protected LabelPosition parseInput(String input) throws CoreException {
        int parsedInt = PropertyMethodSourceUtility.parseReturnParameterInteger((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        switch (parsedInt) {
            case 1: {
                return LabelPosition.Left;
            }
            case 2: {
                return LabelPosition.OnField;
            }
            case 3: {
                return LabelPosition.Right;
            }
            case 4: {
                return LabelPosition.Top;
            }
            case 0: {
                return LabelPosition.Default;
            }
        }
        return null;
    }

    @Override
    protected void storeValue(LabelPosition value) throws CoreException {
        if (value == null) {
            this.getProposalField().acceptProposal(this.getDefaultValue());
            value = (LabelPosition)((Object)this.getDefaultValue());
        }
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((LabelPosition)((Object)this.getDefaultValue()), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            StringBuilder source = new StringBuilder("return ");
            switch (value) {
                case Left: {
                    source.append("LABEL_POSITION_LEFT");
                    break;
                }
                case OnField: {
                    source.append("LABEL_POSITION_ON_FIELD");
                    break;
                }
                case Right: {
                    source.append("LABEL_POSITION_RIGHT");
                    break;
                }
                case Top: {
                    source.append("LABEL_POSITION_TOP");
                    break;
                }
                case Default: {
                    source.append("LABEL_POSITION_DEFAULT");
                    break;
                }
                default: {
                    ScoutSdkUi.logWarning("could not store value '" + (Object)((Object)value) + "'.");
                    return;
                }
            }
            source.append(";");
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), source.toString(), true);
        }
        if (op != null) {
            new OperationJob(new IOperation[]{op}).schedule();
        }
    }

    protected static enum LabelPosition {
        Left,
        OnField,
        Right,
        Top,
        Default;

    }
}

