/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.NlsTextMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.ILazyProposalContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalSelectionHandler;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsProposalDescriptionProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextSelectionHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class NlsTextPresenter
extends AbstractMethodPresenter {
    private ProposalTextField m_proposalField;
    private INlsEntry m_currentSourceTuple;
    private INlsProject m_nlsProject;
    private OptimisticLock storeValueLock = new OptimisticLock();

    public NlsTextPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected Control createContent(Composite container) {
        this.m_proposalField = new ProposalTextField(container, ProposalTextField.STYLE_NO_LABEL);
        this.toolkitAdapt((Control)this.m_proposalField);
        this.m_proposalField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                NlsTextPresenter.this.handleProposalAccepted(event);
            }
        });
        this.m_proposalField.setEnabled(false);
        this.m_proposalField.setProposalDescriptionProvider(new NlsProposalDescriptionProvider());
        return this.m_proposalField;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_proposalField.setEnabled(enabled && this.getNlsProject() != null);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_proposalField.getEnabled() && super.isEnabled();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        if (method == null) {
            return;
        }
        super.init(method);
        INlsProject newNlsProject = this.resolveNlsProject(method);
        if (!CompareUtility.equals((Object)newNlsProject, (Object)this.m_nlsProject)) {
            this.m_nlsProject = newNlsProject;
            this.m_proposalField.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(this.getNlsProject()));
            this.m_proposalField.setContentProvider(this.createContentProvider(this.getNlsProject()));
            this.m_proposalField.setSelectionHandler(this.createSelectionHandler(this.getNlsProject()));
            this.m_proposalField.setEnabled(this.getNlsProject() != null);
        }
        BooleanHolder isNlsText = new BooleanHolder();
        String currentSourceValueKey = PropertyMethodSourceUtility.parseReturnParameterNlsKey((String)this.getMethod().computeValue(), (BooleanHolder)isNlsText);
        try {
            this.storeValueLock.acquire();
            if (currentSourceValueKey != null) {
                if (!((Boolean)isNlsText.getValue()).booleanValue()) throw new CoreException((IStatus)new ScoutStatus(1, "Text '" + currentSourceValueKey + "'.", null));
                this.m_currentSourceTuple = this.getNlsProject().getEntry(currentSourceValueKey);
                if (this.m_currentSourceTuple == null) {
                    throw new CoreException((IStatus)new ScoutStatus(2, "Key '" + currentSourceValueKey + "' not found!", null));
                }
                this.m_proposalField.acceptProposal(this.m_currentSourceTuple);
            } else {
                this.m_proposalField.acceptProposal(null);
            }
            this.m_proposalField.setEnabled(true);
            return;
        }
        finally {
            this.storeValueLock.release();
        }
    }

    protected INlsProject resolveNlsProject(ConfigurationMethod method) {
        return ScoutTypeUtility.findNlsProject((IJavaElement)method.getType());
    }

    protected ILazyProposalContentProvider createContentProvider(INlsProject nlsProject) {
        if (nlsProject != null) {
            return new NlsTextContentProvider((NlsTextLabelProvider)this.getProposalField().getLabelProvider());
        }
        return null;
    }

    protected ILabelProvider createLabelProvider(INlsProject project) {
        if (project != null) {
            return new NlsTextLabelProvider(project);
        }
        return null;
    }

    protected IProposalSelectionHandler createSelectionHandler(INlsProject project) {
        if (project != null) {
            return new NlsTextSelectionHandler(this.getNlsProject());
        }
        return null;
    }

    protected ProposalTextField getProposalField() {
        return this.m_proposalField;
    }

    protected void handleProposalAccepted(ContentProposalEvent event) {
        try {
            Object proposal = event.proposal;
            if (proposal == null) {
                this.m_proposalField.setText("");
                this.storeNlsText(null);
            } else {
                this.storeNlsText((INlsEntry)proposal);
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError(e);
        }
    }

    protected synchronized void storeNlsText(INlsEntry proposal) throws CoreException {
        try {
            if (this.storeValueLock.acquire()) {
                ScoutMethodDeleteOperation op = null;
                INlsEntry defaultTuple = null;
                String defaultKey = PropertyMethodSourceUtility.parseReturnParameterNlsKey((String)this.getMethod().computeDefaultValue());
                if (defaultKey != null) {
                    defaultTuple = this.getNlsProject().getEntry(defaultKey);
                }
                if (UiUtility.equals(defaultTuple, proposal)) {
                    if (this.getMethod().isImplemented()) {
                        op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
                    }
                } else if (proposal != null) {
                    op = new NlsTextMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), false);
                    ((NlsTextMethodUpdateOperation)op).setNlsEntry(proposal);
                }
                if (op != null) {
                    new OperationJob(new IOperation[]{op}).schedule();
                }
            }
        }
        finally {
            this.storeValueLock.release();
        }
    }

    public INlsProject getNlsProject() {
        return this.m_nlsProject;
    }
}

