/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newproject;

import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.project.IScoutProjectNewOperation;
import org.eclipse.scout.sdk.operation.project.ScoutProjectNewOperation;
import org.eclipse.scout.sdk.ui.IScoutConstants;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizardPage;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectTemplateWizardPage;
import org.eclipse.scout.sdk.ui.view.outline.IScoutExplorerPart;
import org.eclipse.scout.sdk.ui.wizard.AbstractScoutWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.ui.wizard.project.AbstractProjectNewWizardPage;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizard;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizardPage;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class ScoutProjectNewWizard
extends AbstractWizard
implements INewWizard,
IScoutProjectWizard {
    private ScoutProjectNewWizardPage m_page1;
    private ScoutProjectTemplateWizardPage m_page2;

    public ScoutProjectNewWizard() {
        super(new AbstractScoutWizardPage[0]);
        this.setWindowTitle(Texts.get((String)"NewScoutProjectNoPopup"));
        this.setHelpAvailable(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.m_page1 = new ScoutProjectNewWizardPage();
        this.addPage((IWizardPage)this.m_page1);
        this.m_page2 = new ScoutProjectTemplateWizardPage();
        this.addPage((IWizardPage)this.m_page2);
    }

    @Override
    public boolean performFinish() {
        new P_PerformFinishJob(this.getContainer().getShell().getDisplay()).schedule();
        return true;
    }

    @Override
    public IScoutBundle getScoutProject() {
        return null;
    }

    @Override
    public IScoutProjectWizardPage getProjectWizardPage() {
        return this.m_page1;
    }

    protected class P_PerformFinishJob
    extends Job {
        private final Display m_display;

        public P_PerformFinishJob(Display display) {
            super("Creating new Scout project...");
            this.m_display = display;
        }

        protected IScoutProjectNewOperation getFinishOperation() {
            return new ScoutProjectNewOperation();
        }

        protected IStatus run(IProgressMonitor monitor) {
            PropertyMap properties = new PropertyMap();
            properties.setProperty("CREATED_BUNDLES", new ArrayList());
            IWizardPage[] iWizardPageArray = ScoutProjectNewWizard.this.getPages();
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage p = iWizardPageArray[n2];
                if (p instanceof AbstractProjectNewWizardPage) {
                    ((AbstractProjectNewWizardPage)p).putProperties(properties);
                }
                ++n2;
            }
            IScoutProjectNewOperation mainOperation = this.getFinishOperation();
            mainOperation.setProperties(properties);
            OperationJob job = new OperationJob(new IOperation[]{mainOperation});
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, monitor);
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
            }
            catch (Exception e) {
                ScoutSdkUi.logError("error during waiting for auto build and refresh");
            }
            this.switchPerspective();
            return Status.OK_STATUS;
        }

        protected void switchPerspective() {
            if (this.m_display != null && !this.m_display.isDisposed()) {
                this.m_display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)new P_ScoutPerspectiveConfigElement());
                        IScoutExplorerPart ex = ScoutSdkUi.getExplorer(true);
                        if (ex != null) {
                            ex.expandAndSelectProjectLevel();
                        }
                    }
                });
            }
        }

        public boolean scheduleAndWait(OperationJob job, long delay) {
            job.schedule(delay);
            try {
                job.join();
                return job.getResult().isOK();
            }
            catch (InterruptedException e) {
                ScoutSdkUi.logWarning(e);
                return false;
            }
        }
    }

    private class P_ScoutPerspectiveConfigElement
    implements IConfigurationElement {
        private P_ScoutPerspectiveConfigElement() {
        }

        public String getAttribute(String name) throws InvalidRegistryObjectException {
            if (name.equals("finalPerspective")) {
                return IScoutConstants.SCOUT_PERSPECTIVE_ID;
            }
            if (name.equals("preferredPerspectives")) {
                return IScoutConstants.SCOUT_PERSPECTIVE_ID;
            }
            return null;
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            return null;
        }

        public String getAttribute(String attrName, String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue(String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getAttributeAsIs(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public String[] getAttributeNames() throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren() throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public IContributor getContributor() throws InvalidRegistryObjectException {
            return null;
        }

        public IExtension getDeclaringExtension() throws InvalidRegistryObjectException {
            return null;
        }

        public String getName() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespace() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public Object getParent() throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue() throws InvalidRegistryObjectException {
            return null;
        }

        public String getValueAsIs() throws InvalidRegistryObjectException {
            return null;
        }

        public boolean isValid() {
            return false;
        }
    }
}

