/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newproject;

import java.beans.PropertyChangeListener;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.compatibility.internal.PlatformVersionUtility;
import org.eclipse.scout.sdk.operation.project.AbstractScoutProjectNewOperation;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizard;
import org.eclipse.scout.sdk.ui.wizard.project.AbstractProjectNewWizardPage;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizardPage;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.validation.JavaElementValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ScoutProjectNewWizardPage
extends AbstractProjectNewWizardPage
implements IScoutProjectWizardPage {
    private static final String TYPE_BUNDLE = "bundle";
    protected StyledTextField m_projectNameField;
    protected StyledTextField m_postFixField;
    protected CheckableTree m_bundleTree;
    protected ITreeNode m_invisibleRootNode;
    protected StyledTextField m_projectAliasNameField;
    protected Button m_useDefaultScoutPreferences;

    public ScoutProjectNewWizardPage() {
        super(ScoutProjectNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"CreateAScoutProject"));
        this.setDescription(Texts.get((String)"CreateScoutProjectHelpMsg"));
        this.setUseDefaultJdtPrefsInternal(true);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_projectNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"ProjectName"));
        this.m_projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.setProjectNameInternal(ScoutProjectNewWizardPage.this.m_projectNameField.getText());
                    ScoutProjectNewWizardPage.this.updateBundleNames();
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_postFixField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"ProjectPostfix"));
        this.m_postFixField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.setProjectNamePostfixInternal(ScoutProjectNewWizardPage.this.m_postFixField.getText());
                    ScoutProjectNewWizardPage.this.updateBundleNames();
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_invisibleRootNode = this.buildBundleTree();
        ScoutBundleUiExtension[] scoutBundleUiExtensionArray = ScoutBundleExtensionPoint.getExtensions();
        int n = scoutBundleUiExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleUiExtension e = scoutBundleUiExtensionArray[n2];
            e.getNewScoutBundleHandler().init(this.getWizard(), e);
            ++n2;
        }
        this.m_bundleTree = new CheckableTree(parent, this.m_invisibleRootNode);
        this.m_bundleTree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                ScoutBundleUiExtension ext;
                ScoutProjectNewWizardPage.this.setProperty("selectedBundles", ScoutProjectNewWizardPage.this.m_bundleTree.getCheckedNodes());
                if (!node.isEnabled()) {
                    checkState = false;
                }
                if ((ext = (ScoutBundleUiExtension)node.getData()) != null) {
                    ext.getNewScoutBundleHandler().bundleSelectionChanged(ScoutProjectNewWizardPage.this.getWizard(), checkState);
                }
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_bundleTree.setChecked(TreeUtility.findNodes(this.m_invisibleRootNode, new P_InitialCheckNodesFilter()));
        Control aliasGroup = this.createPropertiesGroup(parent);
        this.m_projectNameField.setFocus();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_projectNameField.setLayoutData(new GridData(768));
        this.m_postFixField.setLayoutData(new GridData(768));
        this.m_bundleTree.setLayoutData(new GridData(1808));
        aliasGroup.setLayoutData((Object)new GridData(768));
    }

    private ITreeNode buildBundleTree() {
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setVisible(false);
        ScoutBundleUiExtension[] scoutBundleUiExtensionArray = ScoutBundleExtensionPoint.getExtensions();
        int n = scoutBundleUiExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleUiExtension e = scoutBundleUiExtensionArray[n2];
            TreeUtility.createNode(rootNode, TYPE_BUNDLE, e.getBundleName(), e.getIcon(), e.getOrderNumber(), e, false);
            ++n2;
        }
        return rootNode;
    }

    private void updateBundleNames() {
        String pf;
        int dotIndex;
        ITreeNode[] iTreeNodeArray = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node = iTreeNodeArray[n2];
            ScoutBundleUiExtension ext = (ScoutBundleUiExtension)node.getData();
            if (ext != null && node.isEnabled()) {
                node.setText(AbstractScoutProjectNewOperation.getPluginName((String)this.getProjectName(), (String)this.getProjectNamePostfix(), (String)ext.getBundleName()));
            }
            ++n2;
        }
        this.m_bundleTree.getTreeViewer().refresh();
        String alias = "";
        if (this.getProjectName() != null && (dotIndex = this.getProjectName().lastIndexOf(46)) > 0 && dotIndex < this.getProjectName().length() - 1) {
            alias = this.getProjectName().substring(dotIndex + 1);
        }
        if ((pf = this.getProjectNamePostfix()) != null && (pf = pf.trim()).length() > 1) {
            alias = String.valueOf(alias) + Character.toUpperCase(pf.charAt(0)) + pf.substring(1);
        }
        this.m_projectAliasNameField.setText(alias);
    }

    protected Control createPropertiesGroup(Composite parent) {
        Group group = new Group(parent, 4);
        group.setText(Texts.get((String)"ProjectProperties"));
        Label label = new Label((Composite)group, 0);
        label.setText(Texts.get((String)"ProjectAliasHelp"));
        this.m_projectAliasNameField = this.getFieldToolkit().createStyledTextField((Composite)group, Texts.get((String)"ProjectAlias"));
        this.m_projectAliasNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScoutProjectNewWizardPage.this.setProjectAliasInternal(ScoutProjectNewWizardPage.this.m_projectAliasNameField.getText());
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_useDefaultScoutPreferences = new Button((Composite)group, 32);
        this.m_useDefaultScoutPreferences.setText(Texts.get((String)"UseDefaultScoutJDTPreferences"));
        this.m_useDefaultScoutPreferences.setSelection(this.isUseDefaultJdtPrefs());
        this.m_useDefaultScoutPreferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScoutProjectNewWizardPage.this.setUseDefaultJdtPrefsInternal(ScoutProjectNewWizardPage.this.m_useDefaultScoutPreferences.getSelection());
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        label.setLayoutData((Object)new GridData(768));
        this.m_projectAliasNameField.setLayoutData(new GridData(768));
        this.m_useDefaultScoutPreferences.setLayoutData((Object)new GridData(768));
        return group;
    }

    @Override
    public void putProperties(PropertyMap properties) {
        String postfix = this.getProjectNamePostfix();
        if (postfix != null && (postfix = postfix.trim()).length() == 0) {
            postfix = null;
        }
        properties.setProperty("GROUP", (Object)this.getProjectName().trim());
        properties.setProperty("POSTFIX", (Object)postfix);
        properties.setProperty("ALIAS", (Object)this.getProjectAlias().trim());
        properties.setProperty("TARGET_PLATFORM_VERSION", (Object)PlatformVersionUtility.getPlatformVersion());
        properties.setProperty("PROP_USE_DEFAULT_JDT_PREFS", (Object)this.isUseDefaultJdtPrefs());
        ITreeNode[] nodes = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getAcceptAll());
        HashSet<String> checkedNodeExtensionIds = new HashSet<String>(nodes.length);
        ITreeNode[] iTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node = iTreeNodeArray[n2];
            ScoutBundleUiExtension ext = (ScoutBundleUiExtension)node.getData();
            if (ext != null) {
                if (this.m_bundleTree.isChecked(node) && node.isEnabled() && node.isVisible()) {
                    checkedNodeExtensionIds.add(ext.getBundleId());
                }
                ext.getNewScoutBundleHandler().putProperties(this.getWizard(), properties);
            }
            ++n2;
        }
        properties.setProperty("CHECKED_NODES", checkedNodeExtensionIds);
    }

    public void performHelp() {
        ResourceUtility.showUrlInBrowser((String)"http://wiki.eclipse.org/Scout/HowTo/3.9/Create_a_new_project#Step_1");
    }

    public ScoutProjectNewWizard getWizard() {
        return (ScoutProjectNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusProjectName());
        multiStatus.add(this.getStatusProjectPostfix());
        multiStatus.add(this.getStatusProjectAlias());
        ITreeNode[] iTreeNodeArray = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleUiExtension ext;
            ITreeNode node = iTreeNodeArray[n2];
            if (this.m_bundleTree.isChecked(node) && (ext = (ScoutBundleUiExtension)node.getData()) != null) {
                multiStatus.add(ext.getNewScoutBundleHandler().getStatus(this.getWizard()));
            }
            ++n2;
        }
    }

    protected IStatus getStatusProjectPostfix() {
        if (StringUtility.isNullOrEmpty((String)this.getProjectNamePostfix())) {
            return Status.OK_STATUS;
        }
        if (this.getProjectNamePostfix().matches("[a-zA-Z]{1}[a-zA-Z0-9]*[a-zA-Z]{1}")) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", "Project postfix is not valid.");
    }

    protected IStatus getStatusProjectName() {
        ITreeNode[] iTreeNodeArray = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus s;
            ITreeNode node = iTreeNodeArray[n2];
            if (node.isEnabled() && this.m_bundleTree.isChecked(node) && !(s = JavaElementValidator.validateNewBundleName((String)node.getText())).isOK()) {
                return s;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusProjectAlias() {
        if (StringUtility.isNullOrEmpty((String)this.getProjectAlias())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ProjectAliasMissing"));
        }
        if (this.getProjectAlias().matches("[a-zA-Z]{1}[a-zA-Z0-9]*[a-zA-Z]{1}")) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", "Project alias is not valid.");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isBundleNodesSelected(String ... extensionIds) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByExtensionIdFilter(extensionIds));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            if (!this.m_bundleTree.isChecked(n3)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void setBundleNodeAvailable(boolean enabled, boolean visible, String ... extensionIds) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByExtensionIdFilter(extensionIds));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            n3.setEnabled(enabled);
            n3.setVisible(visible);
            ++n2;
        }
    }

    @Override
    public boolean hasSelectedBundle(String ... types) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByBundleTypeFilter(types));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            if (this.m_bundleTree.isChecked(n3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getProjectName() {
        return this.getPropertyString("projectName");
    }

    public void setProjectName(String projectName) {
        try {
            this.setStateChanging(true);
            this.setProjectNameInternal(projectName);
            if (this.isControlCreated()) {
                this.m_projectNameField.setText(projectName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProjectNameInternal(String projectName) {
        this.setPropertyString("projectName", projectName);
    }

    @Override
    public String getProjectNamePostfix() {
        return this.getPropertyString("projectNamePostfix");
    }

    public void setProjectNamePostfix(String projectPostfix) {
        try {
            this.setStateChanging(true);
            this.setProjectNamePostfixInternal(projectPostfix);
            if (this.isControlCreated()) {
                this.m_postFixField.setText(projectPostfix);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProjectNamePostfixInternal(String projectPostfix) {
        this.setPropertyString("projectNamePostfix", projectPostfix);
    }

    @Override
    public String getProjectAlias() {
        return this.getPropertyString("projectAlias");
    }

    public void setProjectAlias(String projectAlias) {
        try {
            this.setStateChanging(true);
            this.setProjectAliasInternal(projectAlias);
            if (this.isControlCreated()) {
                this.m_projectAliasNameField.setText(projectAlias);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProjectAliasInternal(String alias) {
        this.setPropertyString("projectAlias", alias);
    }

    public boolean isUseDefaultJdtPrefs() {
        return this.getPropertyBool("useDefaultJdtPrefs");
    }

    public void setUseDefaultJdtPrefs(boolean useDefaultJdtPrefs) {
        try {
            this.setStateChanging(true);
            this.setUseDefaultJdtPrefsInternal(useDefaultJdtPrefs);
            if (this.isControlCreated()) {
                this.m_useDefaultScoutPreferences.setSelection(useDefaultJdtPrefs);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setUseDefaultJdtPrefsInternal(boolean useDefaultJdtPrefs) {
        this.setPropertyBool("useDefaultJdtPrefs", useDefaultJdtPrefs);
    }

    private class P_InitialCheckNodesFilter
    implements ITreeNodeFilter {
        private P_InitialCheckNodesFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            return ScoutProjectNewWizardPage.TYPE_BUNDLE.equals(node.getType());
        }
    }

    private class P_NodeByBundleTypeFilter
    implements ITreeNodeFilter {
        private final HashSet<String> m_types = new HashSet();

        public P_NodeByBundleTypeFilter(String ... types) {
            if (types != null) {
                String[] stringArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.m_types.add(s);
                    ++n2;
                }
            }
        }

        @Override
        public boolean accept(ITreeNode node) {
            ScoutBundleUiExtension extension = (ScoutBundleUiExtension)node.getData();
            if (extension != null) {
                return this.m_types.contains(extension.getBundleType());
            }
            return false;
        }
    }

    private class P_NodeByExtensionIdFilter
    implements ITreeNodeFilter {
        private final HashSet<String> m_ids = new HashSet();

        public P_NodeByExtensionIdFilter(String ... extensionIds) {
            if (extensionIds != null) {
                String[] stringArray = extensionIds;
                int n = extensionIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.m_ids.add(s);
                    ++n2;
                }
            }
        }

        @Override
        public boolean accept(ITreeNode node) {
            ScoutBundleUiExtension extension = (ScoutBundleUiExtension)node.getData();
            if (extension != null) {
                return this.m_ids.contains(extension.getBundleId());
            }
            return false;
        }
    }
}

