/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.extensions.IPageFactory;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.ExplorerPageExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerPart;
import org.eclipse.scout.sdk.ui.menu.IContextMenuProvider;
import org.eclipse.scout.sdk.ui.view.outline.pages.INodeVisitor;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPageFilter;
import org.eclipse.scout.sdk.ui.view.outline.pages.PageDirtyListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractPage
implements IPage,
IContextMenuProvider {
    private static final Point ICON_SIZE = new Point(16, 16);
    private String m_name;
    private Map<CompositeObject, IPage> m_children;
    private IPage m_parent;
    private boolean m_recursive;
    private boolean m_childrenLoaded;
    private PageDirtyListener m_pageDirtyListener = new PageDirtyListener(this);
    private ImageDescriptor m_imageDesc;

    public AbstractPage() {
        this.m_children = new TreeMap<CompositeObject, IPage>();
    }

    @Override
    public int getOrder() {
        return -1;
    }

    @Override
    public void setParent(IPage parent) {
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.m_parent.addChild(this);
        }
    }

    @Override
    public IPage getParent() {
        return this.m_parent;
    }

    @Override
    public IScoutBundle getScoutBundle() {
        if (this.getParent() != null) {
            return this.getParent().getScoutBundle();
        }
        return null;
    }

    @Override
    public ScoutExplorerPart getOutlineView() {
        IPage parent = this.getParent();
        if (parent != null) {
            return parent.getOutlineView();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String s) {
        this.m_name = s;
    }

    @Override
    public boolean isChildrenLoaded() {
        return this.m_childrenLoaded;
    }

    @Override
    public boolean isInitiallyLoaded() {
        return false;
    }

    @Override
    public void markStructureDirty() {
        ScoutExplorerPart o = this.getOutlineView();
        if (o != null) {
            o.markStructureDirty(this);
        }
    }

    public String getDecoratedName() {
        return String.valueOf(this.getName()) + (this.m_recursive ? " (R)" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(IPage child) {
        if (child == null) {
            throw new IllegalArgumentException("adding null child to " + this.getName());
        }
        Map<CompositeObject, IPage> map = this.m_children;
        synchronized (map) {
            this.m_children.put(new CompositeObject(new Object[]{child.getOrder(), this.m_children.size(), child}), child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeChild(IPage childPage) {
        if (childPage == null) {
            throw new IllegalArgumentException("remove null child to " + this.getName());
        }
        childPage.setParent(null);
        Map<CompositeObject, IPage> map = this.m_children;
        synchronized (map) {
            Map.Entry<CompositeObject, IPage> entry;
            Iterator<Map.Entry<CompositeObject, IPage>> it = this.m_children.entrySet().iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!childPage.equals((entry = it.next()).getValue()));
            it.remove();
            return true;
        }
    }

    @Override
    public IPage[] getChildArray() {
        return this.getChildArray(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPage[] getChildArray(IPageFilter filter) {
        ArrayList<IPage> children = new ArrayList<IPage>();
        Map<CompositeObject, IPage> map = this.m_children;
        synchronized (map) {
            for (IPage p : this.m_children.values()) {
                if (filter != null && !filter.accept(p)) continue;
                children.add(p);
            }
        }
        return children.toArray(new IPage[children.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IPage> getChildren() {
        Map<CompositeObject, IPage> map = this.m_children;
        synchronized (map) {
            return Collections.unmodifiableList(new ArrayList<IPage>(this.m_children.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildren() {
        Map<CompositeObject, IPage> map = this.m_children;
        synchronized (map) {
            return this.m_children.size() > 0;
        }
    }

    @Override
    public void unloadPage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unloadChildren() {
        Map<CompositeObject, IPage> map = this.m_children;
        synchronized (map) {
            for (IPage page : this.m_children.values()) {
                page.setParent(null);
                page.unloadChildren();
                page.unloadPage();
            }
            this.m_children.clear();
            this.m_childrenLoaded = false;
        }
    }

    @Override
    public void refresh(boolean clearCache) {
        ScoutExplorerPart outlineView = this.getOutlineView();
        if (outlineView != null) {
            outlineView.markStructureDirty(this);
        }
    }

    public String toString() {
        return this.getDecoratedName();
    }

    @Override
    public final synchronized void loadChildren() {
        if (!this.isChildrenLoaded()) {
            try {
                this.loadChildrenImpl();
                ExplorerPageExtensionPoint.ExplorerPageExtension[] extensions = ExplorerPageExtensionPoint.getExtensions(this);
                if (extensions != null) {
                    ExplorerPageExtensionPoint.ExplorerPageExtension[] explorerPageExtensionArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ExplorerPageExtensionPoint.ExplorerPageExtension ext = explorerPageExtensionArray[n2];
                        if (ext.getFactoryClass() != null) {
                            IPageFactory factory = ext.createFactoryClass();
                            factory.createChildren(this);
                        } else if (ext.getPageClass() != null) {
                            IPage childPage = ext.createPageInstance();
                            childPage.setParent(this);
                        }
                        ++n2;
                    }
                }
            }
            finally {
                this.m_childrenLoaded = true;
            }
        }
    }

    protected void loadChildrenImpl() {
    }

    public void refreshFilteredChildren() {
        ScoutExplorerPart o = this.getOutlineView();
        if (o != null) {
            o.markFilterChanged(this);
        }
    }

    public final PageDirtyListener getPageDirtyListener() {
        return this.m_pageDirtyListener;
    }

    @Override
    public void setImageDescriptor(ImageDescriptor desc) {
        this.m_imageDesc = desc;
    }

    public ImageDescriptor getBaseImageDescriptor() {
        if (this.m_imageDesc == null) {
            this.m_imageDesc = this.isFolder() ? ScoutSdkUi.getImageDescriptor("folder_open.png") : ScoutSdkUi.getImageDescriptor("default.gif");
        }
        return this.m_imageDesc;
    }

    public final Image getImage() {
        ImageDescriptor baseDesc = this.getBaseImageDescriptor();
        int flags = 0;
        int quality = this.getQuality();
        switch (quality) {
            case 2: {
                flags |= 0x40;
                break;
            }
            case 1: {
                flags |= 0x20;
            }
        }
        JavaElementImageDescriptor desc = new JavaElementImageDescriptor(baseDesc, flags, ICON_SIZE);
        return ScoutSdkUi.getImage((ImageDescriptor)desc);
    }

    @Override
    public int getQuality() {
        if (this.hasChildren()) {
            IPage[] a = this.getChildArray();
            int q = 0;
            int i = 0;
            while (i < a.length) {
                if ((q = Math.max(q, a[i].getQuality())) == 2) break;
                ++i;
            }
            return q;
        }
        return 0;
    }

    public void handleSelectionDelegate() {
    }

    public boolean handleDoubleClickedDelegate() {
        return false;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public int accept(INodeVisitor visitor) {
        switch (visitor.visit(this)) {
            case 0: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                this.visitChildren(visitor);
                return 0;
            }
        }
        return this.visitChildren(visitor);
    }

    protected int visitChildren(INodeVisitor visitor) {
        if (!this.isChildrenLoaded()) {
            this.loadChildren();
        }
        for (IPage childPage : this.getChildren()) {
            switch (childPage.accept(visitor)) {
                case 0: {
                    return 0;
                }
            }
        }
        return 1;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return null;
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
    }

    public void addDebugMenus(List<Action> debugActions) {
    }
}

