/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.rename.TypeRenameAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.util.ScoutSeverityManager;
import org.eclipse.scout.sdk.util.ScoutSourceUtility;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractScoutTypePage
extends AbstractPage
implements ITypePage {
    private IType m_type;
    private final String m_readOnlySuffix;

    public AbstractScoutTypePage() {
        this(null);
    }

    public AbstractScoutTypePage(String readOnlySuffix) {
        this.m_readOnlySuffix = readOnlySuffix;
    }

    @Override
    public void setType(IType type) {
        this.m_type = type;
        String methodNameForTranslatedText = this.getMethodNameForTranslatedText();
        this.setName(ScoutSourceUtility.getTranslatedMethodStringValue((IType)this.getType(), (String)methodNameForTranslatedText));
    }

    @Override
    public IType getType() {
        return this.m_type;
    }

    protected String getMethodNameForTranslatedText() {
        return null;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public int getQuality() {
        int quality = 0;
        if (this.getType().exists()) {
            quality = ScoutSeverityManager.getInstance().getSeverityOf((Object)this.getType());
        }
        return quality;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{TypeRenameAction.class, ShowJavaReferencesAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof TypeRenameAction) {
            TypeRenameAction action = (TypeRenameAction)menu;
            action.setOldName(this.getType().getElementName());
            action.setReadOnlySuffix(this.m_readOnlySuffix);
            action.setType(this.getType());
        } else if (menu instanceof ShowJavaReferencesAction) {
            ((ShowJavaReferencesAction)menu).setElement((IJavaElement)this.getType());
        }
    }

    @Override
    public boolean handleDoubleClickedDelegate() {
        try {
            ITextEditor textEditor;
            IRegion reg;
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)this.getType());
            if (editor instanceof ITextEditor && (reg = (textEditor = (ITextEditor)editor).getHighlightRange()) != null) {
                textEditor.setHighlightRange(reg.getOffset(), reg.getLength(), true);
            }
            return true;
        }
        catch (Exception ex) {
            ScoutSdkUi.logWarning(ex);
            return false;
        }
    }

    public int hashCode() {
        int hash = 0;
        IPage parent = this.getParent();
        IType type = this.getType();
        if (parent != null) {
            hash += parent.hashCode();
        }
        if (type != null) {
            hash += 31 * hash + type.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractScoutTypePage)) {
            return false;
        }
        AbstractScoutTypePage page = (AbstractScoutTypePage)obj;
        return this.getType().equals(page.getType()) && CompareUtility.equals((Object)page.getParent(), (Object)this.getParent());
    }
}

