/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.single;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.ui.launcher.EclipseLaunchShortcut;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.FileOpenLink;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.LinksPresenter;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ProductLaunchPresenter
extends AbstractPresenter {
    private String m_productName;
    private final IFile m_productFile;
    private final IScoutBundle m_bundle;
    private ImageHyperlink m_runLink;
    private ImageHyperlink m_debugLink;
    private ImageHyperlink m_stopLink;
    private Group m_mainGroup;
    private P_LaunchListener m_launchListener;
    private P_RecomputeLaunchStateJob m_stateUpdateJob;
    private static final Pattern PATTERN = Pattern.compile("name\\s*\\=\\s*(\\\")?([^\\\"]*)\\\"", 8);
    private static final String MAC_OS_X_SWING_WARNING_MESSAGE_KEY = "scoutSwingMacOsXWarningKey";

    public ProductLaunchPresenter(PropertyViewFormToolkit toolkit, Composite parent, IFile productFile, IScoutBundle bundle) {
        super(toolkit, parent);
        this.m_productFile = productFile;
        this.m_bundle = bundle;
        String prodName = null;
        String productFileContent = "";
        Matcher m = PATTERN.matcher(productFileContent);
        if (m.find()) {
            prodName = m.group(2);
        }
        if (prodName == null) {
            prodName = String.valueOf(productFile.getParent().getName()) + " " + productFile.getName();
        }
        this.m_productName = prodName;
        this.create(this.getContainer(), productFile);
        this.m_launchListener = new P_LaunchListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this.m_launchListener);
        this.getContainer().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProductLaunchPresenter.this.dispose();
            }
        });
        this.m_stateUpdateJob = new P_RecomputeLaunchStateJob();
        this.m_stateUpdateJob.schedule();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_launchListener != null) {
            try {
                DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this.m_launchListener);
                this.m_launchListener = null;
            }
            catch (Exception e) {
                ScoutSdkUi.logError("could not remove launch listener on debug plugin.", e);
            }
        }
        if (this.m_stateUpdateJob != null) {
            this.m_stateUpdateJob.m_canceled = true;
            this.m_stateUpdateJob = null;
        }
    }

    protected void create(Composite parent, IFile productFile) {
        this.m_mainGroup = new Group(parent, 64);
        this.m_mainGroup.setText(productFile.getParent().getName());
        Label l = this.getToolkit().createLabel((Composite)this.m_mainGroup, "");
        ScoutBundleUiExtension uiExt = ScoutBundleExtensionPoint.getExtension(this.getBundle().getType());
        if (uiExt != null && uiExt.getLauncherIconPath() != null) {
            l.setImage(ScoutSdkUi.getDefault().getImageRegistry().get(uiExt.getLauncherIconPath()));
        }
        Control linkPart = this.createLinkPart((Composite)this.m_mainGroup);
        Control actionPart = this.createActionPart((Composite)this.m_mainGroup);
        parent.setLayout((Layout)new FillLayout());
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.m_mainGroup.setLayout((Layout)layout);
        l.setLayoutData((Object)new GridData(1040));
        linkPart.setLayoutData((Object)new GridData(1808));
        GridData actionPartData = new GridData(1808);
        actionPartData.minimumWidth = actionPart.computeSize((int)-1, (int)-1).x;
        actionPartData.horizontalAlignment = 131072;
        actionPart.setLayoutData((Object)actionPartData);
    }

    protected Control createLinkPart(Composite parent) {
        LinksPresenterModel model = new LinksPresenterModel();
        model.addGlobalLink(new FileOpenLink(this.getProductFile(), 10, "org.eclipse.pde.ui.productEditor"));
        try {
            ProductFileModelHelper pfmh = new ProductFileModelHelper(this.getProductFile());
            IFile configIni = pfmh.ConfigurationFile.getFile();
            if (configIni != null) {
                model.addGlobalLink(new FileOpenLink(configIni, 20, "org.eclipse.ui.DefaultTextEditor"));
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logWarning("Unable to find config.ini file for product '" + this.getProductFile().getLocation().toOSString() + "'.", e);
        }
        LinksPresenter presenter = new LinksPresenter(this.getToolkit(), parent, model);
        return presenter.getContainer();
    }

    protected Control createActionPart(Composite parent) {
        Composite container = this.getToolkit().createComposite(parent);
        this.m_runLink = this.getToolkit().createImageHyperlink(container, 0);
        this.m_runLink.setImage(ScoutSdkUi.getImage("run_exc.gif"));
        this.m_runLink.setToolTipText(Texts.get((String)"StartProduct"));
        this.m_runLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ProductLaunchPresenter.this.restartProduct(false);
            }
        });
        this.m_debugLink = this.getToolkit().createImageHyperlink(container, 0);
        this.m_debugLink.setToolTipText(Texts.get((String)"StartProductInDebugMode"));
        this.m_debugLink.setImage(ScoutSdkUi.getImage("debug_exc.gif"));
        this.m_debugLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ProductLaunchPresenter.this.restartProduct(true);
            }
        });
        this.m_stopLink = this.getToolkit().createImageHyperlink(container, 0);
        this.m_stopLink.setImage(ScoutSdkUi.getImage("stop.gif"));
        this.m_stopLink.setToolTipText(Texts.get((String)"StopProduct"));
        this.m_stopLink.setEnabled(false);
        this.m_stopLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ProductLaunchPresenter.this.stopProduct();
            }
        });
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        this.m_runLink.setLayoutData((Object)layoutData);
        layoutData = new GridData(1808);
        this.m_debugLink.setLayoutData((Object)layoutData);
        layoutData = new GridData(1808);
        layoutData.heightHint = 16;
        this.m_stopLink.setLayoutData((Object)layoutData);
        return container;
    }

    public IFile getProductFile() {
        return this.m_productFile;
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public String getProductName() {
        return this.m_productName;
    }

    private Job startProduct(final boolean debug) {
        this.showMacOsXWarnings();
        Job job = new Job("starting '" + this.getProductName() + "' product..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    EclipseLaunchShortcut shortCut = new EclipseLaunchShortcut();
                    shortCut.launch((ISelection)new StructuredSelection((Object)ProductLaunchPresenter.this.m_productFile), debug ? "debug" : "run");
                }
                catch (Exception e) {
                    ScoutSdkUi.logError("could not start product '" + ProductLaunchPresenter.this.getProductFile().getName() + "'", e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setRule((ISchedulingRule)this.getProductFile());
        job.schedule();
        return job;
    }

    private void showMacOsXWarnings() {
        if ("macosx".equals(Platform.getOS())) {
            try {
                String doNotShowAgainString;
                boolean doNotShowAgain;
                IPreferenceStore store = ScoutSdkUi.getDefault().getPreferenceStore();
                ProductFileModelHelper pfmh = new ProductFileModelHelper(this.m_productFile);
                if (pfmh.ProductFile.existsDependency(RuntimeClasses.ScoutUiSwingBundleId) && !(doNotShowAgain = "always".equals(doNotShowAgainString = store.getString(MAC_OS_X_SWING_WARNING_MESSAGE_KEY)))) {
                    MessageDialogWithToggle.openWarning((Shell)ScoutSdkUi.getShell(), (String)Texts.get((String)"MacOsXSwingWarningTitle"), (String)Texts.get((String)"MacOsXSwingWarningMessage"), (String)Texts.get((String)"DoNotShowAgain"), (boolean)false, (IPreferenceStore)store, (String)MAC_OS_X_SWING_WARNING_MESSAGE_KEY);
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError(e);
            }
        }
    }

    private Job stopProduct() {
        Job job = new Job("stopping  '" + this.getProductName() + "' product..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
                    ILaunch[] iLaunchArray = lm.getLaunches();
                    int n = iLaunchArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch l = iLaunchArray[n2];
                        ILaunchConfiguration lc = l.getLaunchConfiguration();
                        if (lc != null && ProductLaunchPresenter.this.getProductFile().getName().equals(lc.getName())) {
                            l.terminate();
                            int i = 0;
                            while (i < 50) {
                                if (l.isTerminated()) break;
                                Thread.sleep(100L);
                                ++i;
                            }
                            ProductLaunchPresenter.this.recomputeLaunchState();
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    ScoutSdkUi.logError("could not stop product '" + ProductLaunchPresenter.this.getProductFile().getName() + "'", e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setRule((ISchedulingRule)this.getProductFile());
        job.schedule();
        return job;
    }

    private void restartProduct(boolean debug) {
        Job stopJob = this.stopProduct();
        try {
            stopJob.join();
            this.startProduct(debug);
        }
        catch (InterruptedException e) {
            ScoutSdkUi.logError("error during stopping product '" + this.getProductName() + "'", e);
        }
    }

    private void recomputeLaunchState() {
        if (this.getContainer() != null && !this.getContainer().isDisposed()) {
            this.getContainer().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ILaunch[] launches;
                    ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch l = iLaunchArray[n2];
                        if (l.getLaunchConfiguration() != null && l.getLaunchConfiguration().getName().equals(ProductLaunchPresenter.this.getProductFile().getName()) && !ProductLaunchPresenter.this.m_stopLink.isDisposed() && !ProductLaunchPresenter.this.m_mainGroup.isDisposed()) {
                            if (l.isTerminated()) {
                                ProductLaunchPresenter.this.m_stopLink.setEnabled(false);
                                ProductLaunchPresenter.this.m_mainGroup.setText(ProductLaunchPresenter.this.getProductFile().getParent().getName());
                            } else {
                                ProductLaunchPresenter.this.m_stopLink.setEnabled(true);
                                if (l.getLaunchMode().equals("debug")) {
                                    ProductLaunchPresenter.this.m_mainGroup.setText(String.valueOf(ProductLaunchPresenter.this.getProductFile().getParent().getName()) + " - " + Texts.get((String)"debugging") + "...");
                                } else if (l.getLaunchMode().equals("run")) {
                                    ProductLaunchPresenter.this.m_mainGroup.setText(String.valueOf(ProductLaunchPresenter.this.getProductFile().getParent().getName()) + " - " + Texts.get((String)"Running") + "...");
                                } else {
                                    ProductLaunchPresenter.this.m_mainGroup.setText(String.valueOf(ProductLaunchPresenter.this.getProductFile().getParent().getName()) + " - " + Texts.get((String)"UndefinedState") + "...");
                                }
                            }
                        }
                        ++n2;
                    }
                }
            });
        }
    }

    private class P_LaunchListener
    implements ILaunchListener {
        private P_LaunchListener() {
        }

        public void launchAdded(ILaunch launch) {
            ProductLaunchPresenter.this.recomputeLaunchState();
        }

        public void launchChanged(ILaunch launch) {
            ProductLaunchPresenter.this.recomputeLaunchState();
        }

        public void launchRemoved(ILaunch launch) {
            ProductLaunchPresenter.this.recomputeLaunchState();
        }
    }

    private class P_RecomputeLaunchStateJob
    extends Job {
        private boolean m_canceled;

        public P_RecomputeLaunchStateJob() {
            super("");
            this.m_canceled = false;
            this.setSystem(true);
            this.setPriority(50);
            this.setRule((ISchedulingRule)ProductLaunchPresenter.this.getProductFile());
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!this.m_canceled) {
                ProductLaunchPresenter.this.recomputeLaunchState();
                this.schedule(2500L);
            }
            return Status.OK_STATUS;
        }
    }
}

