/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BundleTreeWizardPage
extends AbstractWorkspaceWizardPage {
    private CheckableTree m_tree;
    private boolean m_treeListenersAttached = false;
    private final ITreeNode m_rootNode;
    private List<ITreeDndListener> m_tempListeners = new ArrayList<ITreeDndListener>();
    private Object m_tempListenersLock = new Object();
    private final ITreeNodeFilter m_initialCheckedFilter;

    public BundleTreeWizardPage(String pageTitle, String message, ITreeNode rootNode) {
        this(pageTitle, message, rootNode, null);
    }

    public BundleTreeWizardPage(String pageTitle, String message, ITreeNode rootNode, ITreeNodeFilter initialCheckedFilter) {
        super(BundleTreeWizardPage.class.getName());
        this.m_rootNode = rootNode;
        this.setDescription(message);
        this.setTitle(pageTitle);
        if (initialCheckedFilter == null) {
            initialCheckedFilter = NodeFilters.getAcceptNone();
        }
        this.m_initialCheckedFilter = initialCheckedFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDndListener(ITreeDndListener listener) {
        if (this.m_treeListenersAttached) {
            this.m_tree.addDndListener(listener);
        } else {
            Object object = this.m_tempListenersLock;
            synchronized (object) {
                this.m_tempListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDndListener(ITreeDndListener listener) {
        if (this.m_treeListenersAttached) {
            this.m_tree.removeDndListener(listener);
        } else {
            Object object = this.m_tempListenersLock;
            synchronized (object) {
                this.m_tempListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createContent(Composite parent) {
        this.m_tree = new CheckableTree(parent, this.getRootNode());
        Object object = this.m_tempListenersLock;
        synchronized (object) {
            for (ITreeDndListener l : this.m_tempListeners) {
                this.m_tree.addDndListener(l);
            }
            this.m_tempListeners.clear();
        }
        this.m_treeListenersAttached = true;
        this.m_tree.addDndListener(new P_TreeDndListener());
        this.m_tree.setChecked(TreeUtility.findNodes(this.getRootNode(), this.m_initialCheckedFilter));
        this.m_tree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                BundleTreeWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        GridData interfaceLocationData = new GridData(1808);
        interfaceLocationData.heightHint = 200;
        this.m_tree.setLayoutData(interfaceLocationData);
    }

    public ITreeNode getRootNode() {
        return this.m_rootNode;
    }

    private CheckableTree getTree() {
        return this.m_tree;
    }

    public void refreshTree() {
        if (this.isControlCreated()) {
            this.m_tree.getTreeViewer().refresh();
        }
    }

    public IScoutBundle[] getLocationBundles(String type, boolean visibleOnly, boolean checkedOnly) {
        ITreeNode[] nodes = this.getTreeNodes(type, visibleOnly, checkedOnly);
        ArrayList<IScoutBundle> result = new ArrayList<IScoutBundle>();
        ITreeNode[] iTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node = iTreeNodeArray[n2];
            if (node != null && node.getParent() != null && node.getParent().getData() instanceof IScoutBundle) {
                result.add((IScoutBundle)node.getParent().getData());
            }
            ++n2;
        }
        return result.toArray(new IScoutBundle[result.size()]);
    }

    public ITreeNode[] getTreeNodes(String type, boolean visibleOnly, boolean checkedOnly) {
        ArrayList<ITreeNode> result = new ArrayList<ITreeNode>();
        if (this.isControlCreated()) {
            ITreeNode[] nodes;
            ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_rootNode, NodeFilters.getByType(type));
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode node = iTreeNodeArray[n2];
                if (!(node != null && checkedOnly && node.isCheckable() && !this.getTree().isChecked(node) || node != null && visibleOnly && !node.isVisible())) {
                    result.add(node);
                }
                ++n2;
            }
        }
        return result.toArray(new ITreeNode[result.size()]);
    }

    public IScoutBundle getLocationBundle(String type, boolean visibleOnly, boolean checkedOnly) {
        ITreeNode node = this.getTreeNode(type, visibleOnly, checkedOnly);
        if (node != null) {
            try {
                return (IScoutBundle)node.getParent().getData();
            }
            catch (ClassCastException e) {
                ScoutSdkUi.logError("Tree node data not instance of " + IScoutBundle.class.getName());
                return null;
            }
        }
        return null;
    }

    public ITreeNode getTreeNode(String type, boolean visibleOnly, boolean checkedOnly) {
        ITreeNode node = null;
        if (this.isControlCreated() && (node = TreeUtility.findNode(this.m_rootNode, NodeFilters.getByType(type))) != null) {
            if (node.isCheckable() && checkedOnly && !this.getTree().isChecked(node)) {
                return null;
            }
            if (visibleOnly && !node.isVisible()) {
                return null;
            }
        }
        return node;
    }

    public String getTextOfNode(String nodeType) {
        return this.getTextOfNode(nodeType, true, true);
    }

    public String getTextOfNode(String type, boolean visibleOnly, boolean checkedOnly) {
        ITreeNode treeNode = this.getTreeNode(type, visibleOnly, checkedOnly);
        String text = null;
        if (treeNode != null) {
            text = treeNode.getText();
        }
        return text;
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            return true;
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            BundleTreeWizardPage.this.pingStateChanging();
        }
    }
}

