/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.form.FormStackNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.form.FormNewWizardPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class FormNewWizard
extends AbstractWorkspaceWizard {
    public static final String TYPE_FORM = "form";
    public static final String TYPE_FORM_BUTTON_OK = "okbutton";
    public static final String TYPE_FORM_BUTTON_CANCEL = "cancelbutton";
    public static final String TYPE_HANDLER_MODIFY = "modifyHandler";
    public static final String TYPE_HANDLER_NEW = "newHandler";
    public static final String TYPE_FORM_DATA = "formData";
    public static final String TYPE_PERMISSION_CREATE = "createPerm";
    public static final String TYPE_PERMISSION_READ = "readPerm";
    public static final String TYPE_PERMISSION_UPDATE = "updatePerm";
    public static final String TYPE_SERVICE_INTERFACE = "svcIfc";
    public static final String TYPE_SERVICE_IMPLEMENTATION = "svcImpl";
    public static final String TYPE_SERVICE_REG_CLIENT = "svcRegClient";
    public static final String TYPE_SERVICE_REG_SERVER = "svcRegServer";
    private final IScoutBundle m_clientBundle;
    private FormNewWizardPage m_formPage;
    private BundleTreeWizardPage m_locationPage;
    private FormStackNewOperation m_operation = new FormStackNewOperation(true);
    private ITreeNode m_locationPageRoot;

    public FormNewWizard(IScoutBundle clientBundle) {
        this.setWindowTitle(Texts.get((String)"NewForm"));
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_clientBundle = clientBundle;
        this.m_formPage = new FormNewWizardPage(this.getClientBundle());
        this.addPage((IWizardPage)this.m_formPage);
        this.m_locationPageRoot = this.createTree(clientBundle);
        this.m_locationPage = new BundleTreeWizardPage(Texts.get((String)"FormClassLocations"), Texts.get((String)"OrganiseLocations"), this.m_locationPageRoot, new P_InitialCheckedFilter());
        this.m_locationPage.addStatusProvider(statusProvider);
        this.m_locationPage.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_locationPage);
        this.m_formPage.addPropertyChangeListener(new P_LocationPropertyListener());
    }

    private ITreeNode createTree(IScoutBundle clientBundle) {
        IScoutBundle serverBundle = null;
        IScoutBundle sharedBundle = null;
        if (clientBundle != null && (sharedBundle = clientBundle.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false)) != null) {
            serverBundle = sharedBundle.getChildBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}), clientBundle, false);
        }
        ITreeNode rootNode = TreeUtility.createBundleTree(clientBundle, NodeFilters.getByType("CLIENT", "SERVER", "SHARED"));
        ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(this.getClientBundle()));
        ITreeNode formNode = TreeUtility.createNode(clientNode, TYPE_FORM, Texts.get((String)"Form"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
        formNode.setEnabled(false);
        TreeUtility.createNode(formNode, TYPE_FORM_BUTTON_OK, Texts.get((String)"OkButton"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
        TreeUtility.createNode(formNode, TYPE_FORM_BUTTON_CANCEL, Texts.get((String)"CancelButton"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 2);
        TreeUtility.createNode(formNode, TYPE_HANDLER_NEW, Texts.get((String)"NewHandler"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 3);
        TreeUtility.createNode(formNode, TYPE_HANDLER_MODIFY, Texts.get((String)"ModifyHandler"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 4);
        if (sharedBundle != null && serverBundle != null) {
            TreeUtility.createNode(clientNode, TYPE_SERVICE_REG_CLIENT, Texts.get((String)"ServiceProxyRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 2);
        }
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, TYPE_FORM_DATA, Texts.get((String)"FormData"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
            if (serverBundle != null) {
                TreeUtility.createNode(sharedNode, TYPE_SERVICE_INTERFACE, Texts.get((String)"IService"), ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"), 2);
            }
            TreeUtility.createNode(sharedNode, TYPE_PERMISSION_CREATE, Texts.get((String)"CreatePermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 3);
            TreeUtility.createNode(sharedNode, TYPE_PERMISSION_READ, Texts.get((String)"ReadPermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 4);
            TreeUtility.createNode(sharedNode, TYPE_PERMISSION_UPDATE, Texts.get((String)"UpdatePermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 5);
        }
        if (serverBundle != null) {
            ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
            TreeUtility.createNode(serverNode, TYPE_SERVICE_IMPLEMENTATION, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
            TreeUtility.createNode(serverNode, TYPE_SERVICE_REG_SERVER, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 2);
        }
        return rootNode;
    }

    public FormNewWizardPage getFormNewPage() {
        return this.m_formPage;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle serviceInterfaceBundle;
        IScoutBundle permUpdateBundle;
        IScoutBundle permReadBundle;
        IScoutBundle formDataBundle;
        this.m_formPage.fillOperation(this.m_operation);
        this.m_operation.setCreateButtonOk(this.m_locationPage.getTreeNode(TYPE_FORM_BUTTON_OK, true, true) != null);
        this.m_operation.setCreateButtonCancel(this.m_locationPage.getTreeNode(TYPE_FORM_BUTTON_CANCEL, true, true) != null);
        this.m_operation.setCreateModifyHandler(this.m_locationPage.getTreeNode(TYPE_HANDLER_MODIFY, true, true) != null);
        this.m_operation.setCreateNewHandler(this.m_locationPage.getTreeNode(TYPE_HANDLER_NEW, true, true) != null);
        IScoutBundle formBundle = this.m_locationPage.getLocationBundle(TYPE_FORM, true, true);
        if (formBundle != null) {
            this.m_operation.setFormBundle(formBundle);
            this.m_operation.setFormPackage(formBundle.getPackageName(this.m_formPage.getTargetPackage("client.form")));
        }
        if ((formDataBundle = this.m_locationPage.getLocationBundle(TYPE_FORM_DATA, true, true)) != null) {
            this.m_operation.setFormDataBundle(formDataBundle);
            this.m_operation.setFormDataPackage(formDataBundle.getPackageName(this.m_formPage.getTargetPackage("shared.services")));
        }
        this.m_operation.setClientServiceRegistryBundles(this.m_locationPage.getLocationBundles(TYPE_SERVICE_REG_CLIENT, true, true));
        IScoutBundle permCreateBundle = this.m_locationPage.getLocationBundle(TYPE_PERMISSION_CREATE, true, true);
        if (permCreateBundle != null) {
            this.m_operation.setPermissionCreateBundle(permCreateBundle);
            this.m_operation.setPermissionCreateName(this.m_locationPage.getTextOfNode(TYPE_PERMISSION_CREATE, true, true));
            this.m_operation.setPermissionCreatePackage(permCreateBundle.getPackageName(this.m_formPage.getTargetPackage("shared.security")));
        }
        if ((permReadBundle = this.m_locationPage.getLocationBundle(TYPE_PERMISSION_READ, true, true)) != null) {
            this.m_operation.setPermissionReadBundle(permReadBundle);
            this.m_operation.setPermissionReadName(this.m_locationPage.getTextOfNode(TYPE_PERMISSION_READ, true, true));
            this.m_operation.setPermissionReadPackage(permReadBundle.getPackageName(this.m_formPage.getTargetPackage("shared.security")));
        }
        if ((permUpdateBundle = this.m_locationPage.getLocationBundle(TYPE_PERMISSION_UPDATE, true, true)) != null) {
            this.m_operation.setPermissionUpdateBundle(permUpdateBundle);
            this.m_operation.setPermissionUpdateName(this.m_locationPage.getTextOfNode(TYPE_PERMISSION_UPDATE, true, true));
            this.m_operation.setPermissionUpdatePackage(permUpdateBundle.getPackageName(this.m_formPage.getTargetPackage("shared.security")));
        }
        this.m_operation.setServerServiceRegistryBundles(this.m_locationPage.getLocationBundles(TYPE_SERVICE_REG_SERVER, true, true));
        IScoutBundle serviceImplBundle = this.m_locationPage.getLocationBundle(TYPE_SERVICE_IMPLEMENTATION, true, true);
        if (serviceImplBundle != null) {
            this.m_operation.setServiceImplementationBundle(serviceImplBundle);
            this.m_operation.setServiceImplementationName(this.m_locationPage.getTextOfNode(TYPE_SERVICE_IMPLEMENTATION, true, true));
            this.m_operation.setServiceImplementationPackage(serviceImplBundle.getPackageName(this.m_formPage.getTargetPackage("server.services")));
        }
        if ((serviceInterfaceBundle = this.m_locationPage.getLocationBundle(TYPE_SERVICE_INTERFACE, true, true)) != null) {
            this.m_operation.setServiceInterfaceBundle(serviceInterfaceBundle);
            this.m_operation.setServiceInterfaceName(this.m_locationPage.getTextOfNode(TYPE_SERVICE_INTERFACE, true, true));
            this.m_operation.setServiceInterfacePackage(serviceInterfaceBundle.getPackageName(this.m_formPage.getTargetPackage("shared.services")));
        }
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (Exception e) {
            ScoutSdkUi.logError("exception during perfoming finish of wizard.", e);
            return false;
        }
    }

    public FormNewWizardPage getFormPage() {
        return this.m_formPage;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    private class P_InitialCheckedFilter
    implements ITreeNodeFilter {
        private P_InitialCheckedFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            return true;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = FormNewWizard.this.m_formPage.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    ITreeNode serviceInterfaceNode;
                    ITreeNode permissionUpdateNode;
                    ITreeNode permissionReadNode;
                    ITreeNode permissionCreateNode;
                    String prefix = typeName.replaceAll("Form$", "");
                    TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(FormNewWizard.TYPE_FORM)).setText(String.valueOf(prefix) + "Form");
                    ITreeNode formDataNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(FormNewWizard.TYPE_FORM_DATA));
                    if (formDataNode != null) {
                        formDataNode.setText(String.valueOf(prefix) + "FormData");
                    }
                    if ((permissionCreateNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(FormNewWizard.TYPE_PERMISSION_CREATE))) != null) {
                        permissionCreateNode.setText("Create" + prefix + "Permission");
                    }
                    if ((permissionReadNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(FormNewWizard.TYPE_PERMISSION_READ))) != null) {
                        permissionReadNode.setText("Read" + prefix + "Permission");
                    }
                    if ((permissionUpdateNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(FormNewWizard.TYPE_PERMISSION_UPDATE))) != null) {
                        permissionUpdateNode.setText("Update" + prefix + "Permission");
                    }
                    String legacyServiceAddName = null;
                    legacyServiceAddName = DefaultTargetPackage.isPackageConfigurationEnabled() ? "" : "Process";
                    ITreeNode serviceImplNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(FormNewWizard.TYPE_SERVICE_IMPLEMENTATION));
                    if (serviceImplNode != null) {
                        serviceImplNode.setText(String.valueOf(prefix) + legacyServiceAddName + "Service");
                    }
                    if ((serviceInterfaceNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(FormNewWizard.TYPE_SERVICE_INTERFACE))) != null) {
                        serviceInterfaceNode.setText("I" + prefix + legacyServiceAddName + "Service");
                    }
                    FormNewWizard.this.m_locationPage.refreshTree();
                }
                FormNewWizard.this.m_locationPage.pingStateChanging();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusForm());
            multiStatus.add(this.getStatusService());
            multiStatus.add(this.getStatusServiceRegistrationClient());
            multiStatus.add(this.getStatusServiceRegistrationServer());
            multiStatus.add(this.getStatusTypeNames());
        }

        protected IStatus getStatusTypeNames() {
            IStatus createStatus;
            ITreeNode serviceInterfaceNode;
            IScoutBundle serviceInterfaceBundle;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = FormNewWizard.this.m_locationPage.getTreeNode(FormNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceImplementationBundle.getPackageName(FormNewWizard.this.m_formPage.getTargetPackage("server.services"))) + "." + serviceImplNode.getText();
                    IType findType = serviceImplementationBundle.getJavaProject().findType(fqn);
                    if (TypeUtility.exists((IJavaElement)findType)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((serviceInterfaceBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && (serviceInterfaceNode = FormNewWizard.this.m_locationPage.getTreeNode(FormNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceInterfaceBundle.getPackageName(FormNewWizard.this.m_formPage.getTargetPackage("shared.services"))) + "." + serviceInterfaceNode.getText();
                    IType interfaceType = serviceInterfaceBundle.getJavaProject().findType(fqn);
                    if (TypeUtility.exists((IJavaElement)interfaceType)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((createStatus = this.getStatusPermission(FormNewWizard.TYPE_PERMISSION_CREATE)) != Status.OK_STATUS) {
                return createStatus;
            }
            IStatus readStatus = this.getStatusPermission(FormNewWizard.TYPE_PERMISSION_READ);
            if (readStatus != Status.OK_STATUS) {
                return readStatus;
            }
            IStatus updateStatus = this.getStatusPermission(FormNewWizard.TYPE_PERMISSION_UPDATE);
            if (updateStatus != Status.OK_STATUS) {
                return updateStatus;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusPermission(String permissionType) {
            ITreeNode permissionNode;
            IScoutBundle permissionBundle = FormNewWizard.this.m_locationPage.getLocationBundle(permissionType, true, true);
            if (permissionBundle != null && (permissionNode = FormNewWizard.this.m_locationPage.getTreeNode(permissionType, true, true)) != null) {
                try {
                    String fqn = String.valueOf(permissionBundle.getPackageName(FormNewWizard.this.m_formPage.getTargetPackage("shared.security"))) + "." + permissionNode.getText();
                    IType permission = permissionBundle.getJavaProject().findType(fqn);
                    if (permission != null && permission.exists()) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + permissionNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusForm() {
            IScoutBundle formBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_FORM, true, true);
            if (formBundle != null) {
                IScoutBundle formDataBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_FORM_DATA, true, true);
                if (formDataBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)formDataBundle, (IScoutBundle)formBundle)) {
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_FORM_DATA), FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_FORM)}));
                }
                IScoutBundle formServiceBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_SERVICE_INTERFACE, true, true);
                if (formServiceBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)formServiceBundle, (IScoutBundle)formBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_SERVICE_INTERFACE), FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_FORM)}));
                }
                IScoutBundle permissionCreateBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_PERMISSION_CREATE, true, true);
                if (permissionCreateBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionCreateBundle, (IScoutBundle)formBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_PERMISSION_CREATE), FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_FORM)}));
                }
                IScoutBundle permissionReadBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_PERMISSION_READ, true, true);
                if (permissionReadBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionReadBundle, (IScoutBundle)formBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_PERMISSION_READ), FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_FORM)}));
                }
                IScoutBundle permissionUpdateBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_PERMISSION_UPDATE, true, true);
                if (permissionUpdateBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionUpdateBundle, (IScoutBundle)formBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_PERMISSION_UPDATE), FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_FORM)}));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceImplementationBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null) {
                IScoutBundle serviceInterfaceBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_SERVICE_INTERFACE, true, true);
                if (serviceInterfaceBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_SERVICE_INTERFACE), FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
                IScoutBundle permissionCreateBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_PERMISSION_CREATE, true, true);
                if (permissionCreateBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionCreateBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_PERMISSION_CREATE), FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
                IScoutBundle permissionReadBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_PERMISSION_READ, true, true);
                if (permissionReadBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionReadBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_PERMISSION_READ), FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
                IScoutBundle permissionUpdateBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_PERMISSION_UPDATE, true, true);
                if (permissionUpdateBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionUpdateBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_PERMISSION_UPDATE), FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationClient() {
            ITreeNode[] serviceRegistrationClientNodes;
            IScoutBundle serviceInterfaceBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_SERVICE_INTERFACE, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationClientNodes = FormNewWizard.this.m_locationPage.getTreeNodes(FormNewWizard.TYPE_SERVICE_REG_CLIENT, true, true);
            int n = serviceRegistrationClientNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle == null && serviceRegistrationBundle != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "The client service registration can not be done without a service interface.");
                    }
                    if (serviceInterfaceBundle != null && serviceRegistrationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_SERVICE_INTERFACE), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = FormNewWizard.this.m_locationPage.getLocationBundle(FormNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = FormNewWizard.this.m_locationPage.getTreeNodes(FormNewWizard.TYPE_SERVICE_REG_SERVER, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && serviceRegistrationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceImplementationBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{FormNewWizard.this.m_locationPage.getTextOfNode(FormNewWizard.TYPE_SERVICE_IMPLEMENTATION), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), FormNewWizard.TYPE_FORM, FormNewWizard.TYPE_PERMISSION_CREATE, FormNewWizard.TYPE_PERMISSION_READ, FormNewWizard.TYPE_PERMISSION_UPDATE, FormNewWizard.TYPE_SERVICE_IMPLEMENTATION, FormNewWizard.TYPE_SERVICE_INTERFACE, FormNewWizard.TYPE_SERVICE_REG_CLIENT, FormNewWizard.TYPE_SERVICE_REG_SERVER);
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.targetParent.getData() instanceof IScoutBundle && ((IScoutBundle)dndEvent.targetParent.getData()).isBinary()) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            ITreeNode formDataNode;
            if (dndEvent.node.getType() == FormNewWizard.TYPE_FORM && (formDataNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(FormNewWizard.TYPE_FORM_DATA))) != null) {
                IScoutBundle[] sharedBundles;
                ITreeNode oldFomDataParent = formDataNode.getParent();
                IScoutBundle formBundle = (IScoutBundle)dndEvent.node.getParent().getData();
                IScoutBundle[] iScoutBundleArray = sharedBundles = formBundle.getParentBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false);
                int n = sharedBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    IScoutBundle formDataBundle = iScoutBundleArray[n2];
                    ITreeNode sharedNode = TreeUtility.findNode(FormNewWizard.this.m_locationPageRoot, NodeFilters.getByData(formDataBundle));
                    if (sharedNode != null) {
                        if (oldFomDataParent.equals(sharedNode)) break;
                        oldFomDataParent.removeChild(formDataNode);
                        formDataNode.setParent(sharedNode);
                        sharedNode.addChild(formDataNode);
                        break;
                    }
                    ++n2;
                }
            }
            FormNewWizard.this.m_formPage.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            dndEvent.doit = FormNewWizard.TYPE_SERVICE_REG_CLIENT.equals(dndEvent.node.getType()) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (FormNewWizard.TYPE_SERVICE_REG_SERVER.equals(dndEvent.node.getType()) ? "SERVER".equals(dndEvent.targetParent.getType()) : false);
        }

        private void validateDropMove(DndEvent dndEvent) {
            String type = dndEvent.node.getType();
            dndEvent.doit = TreeUtility.isOneOf(type, FormNewWizard.TYPE_FORM, FormNewWizard.TYPE_SERVICE_REG_CLIENT) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (TreeUtility.isOneOf(type, FormNewWizard.TYPE_PERMISSION_CREATE, FormNewWizard.TYPE_PERMISSION_READ, FormNewWizard.TYPE_PERMISSION_UPDATE, FormNewWizard.TYPE_SERVICE_INTERFACE) ? "SHARED".equals(dndEvent.targetParent.getType()) : (TreeUtility.isOneOf(type, FormNewWizard.TYPE_SERVICE_IMPLEMENTATION, FormNewWizard.TYPE_SERVICE_REG_SERVER) ? "SERVER".equals(dndEvent.targetParent.getType()) : false));
        }
    }
}

