/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.library;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.dialog.ScoutBundleSelectionDialog;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.viewer.ScoutBundleLableProvider;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.validation.JavaElementValidator;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class LibraryTypeWizardPage
extends AbstractWorkspaceWizardPage {
    protected static final String PROP_BUNDLE_NAME = "bundleName";
    protected static final String PROP_UNPACK = "unpack";
    protected static final String PROP_LIBRARY_TYPE = "libarayType";
    protected static final String PROP_FRAGMENT_HOST = "fragmentHost";
    protected static final String PROP_USER_BUNDLES = "userBundles";
    private StyledTextField m_bundleNameField;
    private Button m_unpackButton;
    private Button m_pluginRadioButton;
    private Button m_systemFragmentRadioButton;
    private Button m_fragmentRadioButton;
    private StyledTextField m_hostBundleIdField;
    private Button m_fragmentHostBundleSelectionButton;
    private Button m_addUserBundleButton;
    private Button m_removeUserBundleButton;
    private TableViewer m_userBundleViewer;

    public LibraryTypeWizardPage(IScoutBundle ownerBundle) {
        super(LibraryTypeWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewLibraryBundle"));
        this.setDescription(Texts.get((String)"NewLibraryBundleDesc"));
        this.setLibraryType(LibraryType.Plugin);
        TreeSet<IScoutBundle> libraryUserBundles = new TreeSet<IScoutBundle>(new P_JavaProjectComparator());
        if (ownerBundle != null) {
            libraryUserBundles.add(ownerBundle);
        }
        this.setLibraryUserBundles(libraryUserBundles);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_bundleNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"BundleName"));
        this.m_bundleNameField.setText(this.getBundleName());
        this.m_bundleNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LibraryTypeWizardPage.this.setBundleNameInternal(LibraryTypeWizardPage.this.m_bundleNameField.getText());
                LibraryTypeWizardPage.this.pingStateChanging();
            }
        });
        this.m_unpackButton = new Button(parent, 32);
        this.m_unpackButton.setVisible(false);
        this.m_unpackButton.setText(Texts.get((String)"UnpackJarFiles"));
        this.m_unpackButton.setSelection(this.isUnpackJarFiles());
        this.m_unpackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryTypeWizardPage.this.setUnpackJarFilesInternal(LibraryTypeWizardPage.this.m_unpackButton.getSelection());
                LibraryTypeWizardPage.this.pingStateChanging();
            }
        });
        Control strategyBox = this.createStrategyBox(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_bundleNameField.setLayoutData(new GridData(768));
        this.m_unpackButton.setLayoutData((Object)new GridData(768));
        strategyBox.setLayoutData((Object)new GridData(1808));
    }

    private Control createStrategyBox(Composite parent) {
        Group group = new Group(parent, 0);
        P_RadioButtonSelectionListener radioButtonListener = new P_RadioButtonSelectionListener();
        this.m_pluginRadioButton = new Button((Composite)group, 16);
        this.m_pluginRadioButton.setSelection(this.getLibraryType() == LibraryType.Plugin);
        this.m_pluginRadioButton.addSelectionListener((SelectionListener)radioButtonListener);
        this.m_pluginRadioButton.setData(PROP_LIBRARY_TYPE, (Object)LibraryType.Plugin);
        this.m_pluginRadioButton.setText(Texts.get((String)"CreatePluginForLib"));
        Control userPluginBox = this.createUserPluginBox((Composite)group);
        Label separator2 = new Label((Composite)group, 258);
        this.m_fragmentRadioButton = new Button((Composite)group, 16);
        this.m_fragmentRadioButton.setSelection(this.getLibraryType() == LibraryType.Fragment);
        this.m_fragmentRadioButton.addSelectionListener((SelectionListener)radioButtonListener);
        this.m_fragmentRadioButton.setData(PROP_LIBRARY_TYPE, (Object)LibraryType.Fragment);
        this.m_fragmentRadioButton.setText(Texts.get((String)"CreateFragmentForLib"));
        Control fragmentBox = this.createFragmentBox((Composite)group);
        Label separator3 = new Label((Composite)group, 258);
        separator2.setText("test");
        this.m_systemFragmentRadioButton = new Button((Composite)group, 16);
        this.m_systemFragmentRadioButton.setSelection(this.getLibraryType() == LibraryType.SystemBundleFragment);
        this.m_systemFragmentRadioButton.addSelectionListener((SelectionListener)radioButtonListener);
        this.m_systemFragmentRadioButton.setData(PROP_LIBRARY_TYPE, (Object)LibraryType.SystemBundleFragment);
        this.m_systemFragmentRadioButton.setText(Texts.get((String)"CreateSystemFragmentForLib"));
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_pluginRadioButton.setLayoutData((Object)new GridData(768));
        userPluginBox.setLayoutData((Object)new GridData(1808));
        separator2.setLayoutData((Object)new GridData(768));
        this.m_fragmentRadioButton.setLayoutData((Object)new GridData(768));
        fragmentBox.setLayoutData((Object)new GridData(768));
        separator3.setLayoutData((Object)new GridData(768));
        this.m_systemFragmentRadioButton.setLayoutData((Object)new GridData(768));
        return group;
    }

    protected Control createUserPluginBox(Composite parent) {
        Composite box = new Composite(parent, 0);
        Table pluginTable = new Table(box, 67584);
        this.m_userBundleViewer = new TableViewer(pluginTable);
        this.m_userBundleViewer.getTable().setEnabled(this.getLibraryType() == LibraryType.Plugin);
        this.m_userBundleViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LibraryTypeWizardPage.this.m_removeUserBundleButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.m_userBundleViewer.setLabelProvider((IBaseLabelProvider)new P_UserBundleLabelProvider());
        this.m_userBundleViewer.setContentProvider((IContentProvider)new P_UserBundleContentProvider());
        Set<IScoutBundle> libraryUserBundles = this.getLibraryUserBundles();
        this.m_userBundleViewer.setInput((Object)libraryUserBundles.toArray(new Object[libraryUserBundles.size()]));
        Composite buttonGroup = new Composite(box, 0);
        this.m_addUserBundleButton = new Button(buttonGroup, 0x800008);
        this.m_addUserBundleButton.setText(Texts.get((String)"Add"));
        this.m_addUserBundleButton.setEnabled(this.getLibraryType() == LibraryType.Plugin);
        this.m_addUserBundleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryTypeWizardPage.this.showUserSelectionDialog();
            }
        });
        this.m_removeUserBundleButton = new Button(buttonGroup, 0x800008);
        this.m_removeUserBundleButton.setText(Texts.get((String)"Remove"));
        this.m_removeUserBundleButton.setEnabled(false);
        this.m_removeUserBundleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set<IScoutBundle> userBundles;
                ISelection currentSelection = LibraryTypeWizardPage.this.m_userBundleViewer.getSelection();
                if (!currentSelection.isEmpty() && (userBundles = LibraryTypeWizardPage.this.getLibraryUserBundles()).remove((IScoutBundle)((IStructuredSelection)currentSelection).getFirstElement())) {
                    LibraryTypeWizardPage.this.setLibraryUserBundles(userBundles);
                }
            }
        });
        box.setLayout((Layout)new GridLayout(2, false));
        pluginTable.setLayoutData((Object)new GridData(1808));
        buttonGroup.setLayoutData((Object)new GridData(130));
        buttonGroup.setLayout((Layout)new GridLayout(1, true));
        this.m_addUserBundleButton.setLayoutData((Object)new GridData(1808));
        this.m_removeUserBundleButton.setLayoutData((Object)new GridData(1808));
        return box;
    }

    protected Control createFragmentBox(Composite parent) {
        Composite box = new Composite(parent, 0);
        this.m_hostBundleIdField = this.getFieldToolkit().createStyledTextField(box, "Host Bundle ID");
        this.m_hostBundleIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LibraryTypeWizardPage.this.setFragmentHostInternal(LibraryTypeWizardPage.this.m_hostBundleIdField.getText());
                LibraryTypeWizardPage.this.pingStateChanging();
            }
        });
        this.m_hostBundleIdField.setEnabled(this.getLibraryType() == LibraryType.Fragment);
        this.m_fragmentHostBundleSelectionButton = new Button((Composite)this.m_hostBundleIdField, 0x800008);
        this.m_fragmentHostBundleSelectionButton.setText(Texts.get((String)"Bundle"));
        this.m_fragmentHostBundleSelectionButton.setEnabled(this.getLibraryType() == LibraryType.Fragment);
        this.m_fragmentHostBundleSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryTypeWizardPage.this.showBundleSelectionDialog();
            }
        });
        GridLayout layout = new GridLayout(1, true);
        layout.marginLeft = 10;
        box.setLayout((Layout)layout);
        this.m_hostBundleIdField.setLayoutData(new GridData(768));
        StyledText textComp = this.m_hostBundleIdField.getTextComponent();
        FormData textData = (FormData)textComp.getLayoutData();
        textData.right = new FormAttachment((Control)this.m_fragmentHostBundleSelectionButton, -5);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.m_fragmentHostBundleSelectionButton.setLayoutData((Object)buttonData);
        return box;
    }

    private void showBundleSelectionDialog() {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                PluginSelectionDialog dialog = new PluginSelectionDialog(LibraryTypeWizardPage.this.getShell().getShell(), false, false);
                dialog.setInitialPattern("**");
                dialog.create();
                if (dialog.open() == 0) {
                    IPluginModel model = (IPluginModel)dialog.getFirstResult();
                    IPlugin plugin = model.getPlugin();
                    LibraryTypeWizardPage.this.setFragmentHost(plugin.getId());
                }
            }
        });
    }

    private void showUserSelectionDialog() {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Set<IScoutBundle> alreadyAddedBundles = LibraryTypeWizardPage.this.getLibraryUserBundles();
                IScoutBundle[] workspaceBundles = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getWorkspaceBundlesFilter());
                ArrayList<IScoutBundle> plugins = new ArrayList<IScoutBundle>(workspaceBundles.length);
                IScoutBundle[] iScoutBundleArray = workspaceBundles;
                int n = workspaceBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    IScoutBundle bundle = iScoutBundleArray[n2];
                    if (!alreadyAddedBundles.contains(bundle)) {
                        plugins.add(bundle);
                    }
                    ++n2;
                }
                ScoutBundleSelectionDialog dialog = new ScoutBundleSelectionDialog(LibraryTypeWizardPage.this.getControl().getShell(), plugins.toArray(new IScoutBundle[plugins.size()]), true);
                dialog.create();
                if (dialog.open() == 0) {
                    Object[] result;
                    Set<IScoutBundle> userBundles = alreadyAddedBundles;
                    Object[] objectArray = result = dialog.getResult();
                    int n3 = result.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object o = objectArray[n4];
                        if (o instanceof IScoutBundle) {
                            userBundles.add((IScoutBundle)o);
                        }
                        ++n4;
                    }
                    LibraryTypeWizardPage.this.setLibraryUserBundles(userBundles);
                }
            }
        });
    }

    public String getBundleName() {
        return this.getPropertyString(PROP_BUNDLE_NAME);
    }

    public void setBundleName(String bundleName) {
        try {
            this.setStateChanging(true);
            this.setBundleNameInternal(bundleName);
            if (this.isControlCreated()) {
                this.m_bundleNameField.setText(bundleName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setBundleNameInternal(String bundleName) {
        this.setProperty(PROP_BUNDLE_NAME, bundleName);
    }

    public boolean isUnpackJarFiles() {
        return this.getPropertyBool(PROP_UNPACK);
    }

    public void setUnpackJarFiles(boolean unpack) {
        try {
            this.setStateChanging(true);
            this.setUnpackJarFilesInternal(unpack);
            if (this.isControlCreated()) {
                this.m_unpackButton.setSelection(unpack);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setUnpackJarFilesInternal(boolean unpack) {
        this.setProperty(PROP_UNPACK, unpack);
    }

    public LibraryType getLibraryType() {
        return (LibraryType)((Object)this.getProperty(PROP_LIBRARY_TYPE));
    }

    public void setLibraryType(LibraryType libraryType) {
        try {
            this.setStateChanging(true);
            this.setLibraryTypeInternal(libraryType);
            if (this.isControlCreated()) {
                switch (libraryType) {
                    case Plugin: {
                        this.m_pluginRadioButton.setSelection(true);
                        break;
                    }
                    case Fragment: {
                        this.m_fragmentRadioButton.setSelection(true);
                        break;
                    }
                    case SystemBundleFragment: {
                        this.m_systemFragmentRadioButton.setSelection(true);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLibraryTypeInternal(LibraryType libraryType) {
        this.setProperty(PROP_LIBRARY_TYPE, (Object)libraryType);
    }

    public Set<IScoutBundle> getLibraryUserBundles() {
        TreeSet libraryUserBundles = (TreeSet)this.getProperty(PROP_USER_BUNDLES);
        if (libraryUserBundles == null) {
            libraryUserBundles = new TreeSet();
        }
        return libraryUserBundles;
    }

    public void setLibraryUserBundles(Set<IScoutBundle> libraryUsers) {
        try {
            this.setStateChanging(true);
            this.setLibraryUserBundlesInternal(libraryUsers);
            if (this.isControlCreated()) {
                this.m_userBundleViewer.setInput((Object)libraryUsers.toArray(new Object[libraryUsers.size()]));
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLibraryUserBundlesInternal(Set<IScoutBundle> libraryUsers) {
        this.setPropertyAlwaysFire(PROP_USER_BUNDLES, libraryUsers);
    }

    public String getFragmentHost() {
        return this.getPropertyString(PROP_FRAGMENT_HOST);
    }

    public void setFragmentHost(String bundleId) {
        try {
            this.setStateChanging(true);
            this.setFragmentHostInternal(bundleId);
            if (this.isControlCreated()) {
                this.m_hostBundleIdField.setText(bundleId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setFragmentHostInternal(String bundleId) {
        this.setPropertyString(PROP_FRAGMENT_HOST, bundleId);
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusBundleName());
        this.validateStatusFragmentGroup(multiStatus);
    }

    protected IStatus getStatusBundleName() {
        return JavaElementValidator.validateNewBundleName((String)this.getBundleName());
    }

    protected void validateStatusFragmentGroup(MultiStatus multiStatus) {
        if (this.getLibraryType() == LibraryType.Fragment) {
            multiStatus.add(this.getStatusHostBundle());
        }
    }

    protected IStatus getStatusHostBundle() {
        String fragmentHost = this.getFragmentHost();
        if (StringUtility.isNullOrEmpty((String)fragmentHost)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"FragmentHostBundleNotFound"));
        }
        if (Platform.getBundle((String)fragmentHost) == null && !ResourcesPlugin.getWorkspace().getRoot().getProject(fragmentHost).exists()) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"FragmentHostBundleNotExists"));
        }
        return Status.OK_STATUS;
    }

    public static enum LibraryType {
        Plugin,
        Fragment,
        SystemBundleFragment;

    }

    private class P_JavaProjectComparator
    implements Comparator<IScoutBundle> {
        private P_JavaProjectComparator() {
        }

        @Override
        public int compare(IScoutBundle o1, IScoutBundle o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return CompareUtility.compareTo((Comparable)((Object)o1.getSymbolicName()), (Comparable)((Object)o2.getSymbolicName()));
        }
    }

    private class P_RadioButtonSelectionListener
    extends SelectionAdapter {
        private P_RadioButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button.getSelection()) {
                LibraryType libraryType = (LibraryType)((Object)button.getData(LibraryTypeWizardPage.PROP_LIBRARY_TYPE));
                try {
                    LibraryTypeWizardPage.this.setStateChanging(true);
                    switch (libraryType) {
                        case Plugin: {
                            LibraryTypeWizardPage.this.m_hostBundleIdField.setEnabled(false);
                            LibraryTypeWizardPage.this.m_fragmentHostBundleSelectionButton.setEnabled(false);
                            LibraryTypeWizardPage.this.m_userBundleViewer.getTable().setEnabled(true);
                            LibraryTypeWizardPage.this.m_addUserBundleButton.setEnabled(true);
                            LibraryTypeWizardPage.this.m_removeUserBundleButton.setEnabled(!LibraryTypeWizardPage.this.m_userBundleViewer.getSelection().isEmpty());
                            break;
                        }
                        case Fragment: {
                            LibraryTypeWizardPage.this.m_hostBundleIdField.setEnabled(true);
                            LibraryTypeWizardPage.this.m_fragmentHostBundleSelectionButton.setEnabled(true);
                            LibraryTypeWizardPage.this.m_userBundleViewer.getTable().setEnabled(false);
                            LibraryTypeWizardPage.this.m_addUserBundleButton.setEnabled(false);
                            LibraryTypeWizardPage.this.m_removeUserBundleButton.setEnabled(false);
                            break;
                        }
                        case SystemBundleFragment: {
                            LibraryTypeWizardPage.this.m_hostBundleIdField.setEnabled(false);
                            LibraryTypeWizardPage.this.m_fragmentHostBundleSelectionButton.setEnabled(false);
                            LibraryTypeWizardPage.this.m_userBundleViewer.getTable().setEnabled(false);
                            LibraryTypeWizardPage.this.m_addUserBundleButton.setEnabled(false);
                            LibraryTypeWizardPage.this.m_removeUserBundleButton.setEnabled(false);
                        }
                    }
                    LibraryTypeWizardPage.this.setLibraryTypeInternal(libraryType);
                }
                finally {
                    LibraryTypeWizardPage.this.setStateChanging(false);
                }
            }
        }
    }

    private class P_UserBundleContentProvider
    implements IStructuredContentProvider {
        private Object[] m_elements = null;

        private P_UserBundleContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.m_elements = (Object[])newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.m_elements;
        }
    }

    private class P_UserBundleLabelProvider
    extends ScoutBundleLableProvider
    implements ITableLabelProvider {
        private P_UserBundleLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getImage(element);
        }
    }
}

