/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.service.ProcessServiceNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.services.ProcessServiceNewWizardPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class ProcessServiceNewWizard
extends AbstractWorkspaceWizard {
    private static final String TYPE_PERMISSION_CREATE = "permCreate";
    private static final String TYPE_PERMISSION_READ = "permRead";
    private static final String TYPE_PERMISSION_UPDATE = "permUpdate";
    private static final String TYPE_SERVICE_INTERFACE = "svcIfc";
    private static final String TYPE_SERVICE_IMPLEMENTATION = "svcImpl";
    private static final String TYPE_SERVICE_REG_CLIENT = "svcClientReg";
    private static final String TYPE_SERVICE_REG_SERVER = "svcServerReg";
    private final BundleTreeWizardPage m_locationWizardPage;
    private final ProcessServiceNewWizardPage m_serviceNewWizardPage;
    private final ProcessServiceNewOperation m_operation;
    private final ITreeNode m_locationWizardPageRoot;

    public ProcessServiceNewWizard(IScoutBundle serverBundle) {
        this.setWindowTitle(Texts.get((String)"NewProcessService"));
        this.m_operation = new ProcessServiceNewOperation();
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_serviceNewWizardPage = new ProcessServiceNewWizardPage(serverBundle);
        this.m_serviceNewWizardPage.addPropertyChangeListener(new P_LocationPropertyListener());
        this.addPage((IWizardPage)this.m_serviceNewWizardPage);
        this.m_locationWizardPageRoot = this.createTree(serverBundle);
        this.m_locationWizardPage = new BundleTreeWizardPage(Texts.get((String)"ProcessServiceLocation"), Texts.get((String)"OrganiseLocations"), this.m_locationWizardPageRoot, new P_InitialCheckerFilter());
        this.m_locationWizardPage.addStatusProvider(statusProvider);
        this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_locationWizardPage);
        this.m_serviceNewWizardPage.setSuperType(RuntimeClasses.getSuperType((String)"org.eclipse.scout.service.IService", (IJavaProject)serverBundle.getJavaProject()));
    }

    private ITreeNode createTree(IScoutBundle serverBundle) {
        IScoutBundle sharedBundle = null;
        IScoutBundle clientBundle = null;
        if (serverBundle != null && (sharedBundle = serverBundle.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false)) != null) {
            clientBundle = sharedBundle.getChildBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}), serverBundle, false);
        }
        ITreeNode rootNode = TreeUtility.createBundleTree(serverBundle, NodeFilters.getByType("CLIENT", "SERVER", "SHARED"));
        if (clientBundle != null) {
            ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
            TreeUtility.createNode(clientNode, TYPE_SERVICE_REG_CLIENT, Texts.get((String)"ServiceProxyRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"));
        }
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, TYPE_PERMISSION_CREATE, Texts.get((String)"CreatePermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
            TreeUtility.createNode(sharedNode, TYPE_PERMISSION_READ, Texts.get((String)"ReadPermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 2);
            TreeUtility.createNode(sharedNode, TYPE_PERMISSION_UPDATE, Texts.get((String)"UpdatePermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 3);
            TreeUtility.createNode(sharedNode, TYPE_SERVICE_INTERFACE, Texts.get((String)"IService"), ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"), 4);
        }
        if (serverBundle != null) {
            ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
            TreeUtility.createNode(serverNode, TYPE_SERVICE_IMPLEMENTATION, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
            TreeUtility.createNode(serverNode, TYPE_SERVICE_REG_SERVER, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 2);
        }
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle serviceInterfaceBundle;
        this.m_serviceNewWizardPage.fillProcessServiceNewOperation(this.m_operation);
        this.m_operation.setClientServiceRegistryBundles(this.m_locationWizardPage.getLocationBundles(TYPE_SERVICE_REG_CLIENT, true, true));
        IScoutBundle permissionBundle = this.m_locationWizardPage.getLocationBundle(TYPE_PERMISSION_CREATE, true, true);
        if (permissionBundle != null) {
            this.m_operation.setPermissionPackageName(permissionBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage()));
            this.m_operation.setPermissionCreateBundle(permissionBundle);
            this.m_operation.setPermissionCreateName(this.m_locationWizardPage.getTextOfNode(TYPE_PERMISSION_CREATE, true, true));
            this.m_operation.setPermissionReadBundle(this.m_locationWizardPage.getLocationBundle(TYPE_PERMISSION_READ, true, true));
            this.m_operation.setPermissionReadName(this.m_locationWizardPage.getTextOfNode(TYPE_PERMISSION_READ, true, true));
            this.m_operation.setPermissionUpdateBundle(this.m_locationWizardPage.getLocationBundle(TYPE_PERMISSION_UPDATE, true, true));
            this.m_operation.setPermissionUpdateName(this.m_locationWizardPage.getTextOfNode(TYPE_PERMISSION_UPDATE, true, true));
        }
        this.m_operation.setServerServiceRegistryBundles(this.m_locationWizardPage.getLocationBundles(TYPE_SERVICE_REG_SERVER, true, true));
        IScoutBundle serviceImplBundle = this.m_locationWizardPage.getLocationBundle(TYPE_SERVICE_IMPLEMENTATION, true, true);
        if (serviceImplBundle != null) {
            this.m_operation.setServiceImplementationBundle(serviceImplBundle);
            this.m_operation.setServicePackageName(serviceImplBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage()));
            this.m_operation.setServiceImplementationName(this.m_locationWizardPage.getTextOfNode(TYPE_SERVICE_IMPLEMENTATION, true, true));
        }
        if ((serviceInterfaceBundle = this.m_locationWizardPage.getLocationBundle(TYPE_SERVICE_INTERFACE, true, true)) != null) {
            this.m_operation.setServiceInterfaceBundle(serviceInterfaceBundle);
            this.m_operation.setServiceInterfacePackageName(serviceInterfaceBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage()));
            this.m_operation.setServiceInterfaceName(this.m_locationWizardPage.getTextOfNode(TYPE_SERVICE_INTERFACE, true, true));
        }
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.validate();
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (IllegalArgumentException e) {
            ScoutSdkUi.logWarning("validation error of operation '" + this.m_operation.getOperationName() + "'. " + e.getMessage());
            return false;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during executing operation '" + this.m_operation.getOperationName() + "'.", e);
            return false;
        }
    }

    private class P_InitialCheckerFilter
    implements ITreeNodeFilter {
        private P_InitialCheckerFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), ProcessServiceNewWizard.TYPE_PERMISSION_CREATE, ProcessServiceNewWizard.TYPE_PERMISSION_READ, ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE, ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, ProcessServiceNewWizard.TYPE_SERVICE_REG_CLIENT, ProcessServiceNewWizard.TYPE_SERVICE_REG_SERVER);
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = ProcessServiceNewWizard.this.m_serviceNewWizardPage.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    String prefix = typeName.replaceAll("Service$", "");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(ProcessServiceNewWizard.TYPE_PERMISSION_CREATE)).setText("Create" + prefix + "Permission");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(ProcessServiceNewWizard.TYPE_PERMISSION_READ)).setText("Read" + prefix + "Permission");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE)).setText("Update" + prefix + "Permission");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)).setText(String.valueOf(prefix) + "Service");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE)).setText("I" + prefix + "Service");
                    ProcessServiceNewWizard.this.m_locationWizardPage.refreshTree();
                }
                ProcessServiceNewWizard.this.m_locationWizardPage.pingStateChanging();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusTypeNames());
            multiStatus.add(this.getStatusService());
            multiStatus.add(this.getStatusServiceRegistrationClient());
            multiStatus.add(this.getStatusServiceRegistrationServer());
        }

        protected IStatus getStatusTypeNames() {
            IStatus createStatus;
            ITreeNode serviceInterfaceNode;
            IScoutBundle serviceInterfaceBundle;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceImplementationBundle.getPackageName(ProcessServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage())) + "." + serviceImplNode.getText();
                    if (serviceImplementationBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((serviceInterfaceBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && (serviceInterfaceNode = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNode(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceInterfaceBundle.getPackageName(ProcessServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage())) + "." + serviceInterfaceNode.getText();
                    if (serviceInterfaceBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((createStatus = this.getStatusPermission(ProcessServiceNewWizard.TYPE_PERMISSION_CREATE)) != Status.OK_STATUS) {
                return createStatus;
            }
            IStatus readStatus = this.getStatusPermission(ProcessServiceNewWizard.TYPE_PERMISSION_READ);
            if (readStatus != Status.OK_STATUS) {
                return readStatus;
            }
            IStatus updateStatus = this.getStatusPermission(ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE);
            if (updateStatus != Status.OK_STATUS) {
                return updateStatus;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusPermission(String permissionType) {
            ITreeNode permissionNode;
            IScoutBundle permissionBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(permissionType, true, true);
            if (permissionBundle != null && (permissionNode = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNode(permissionType, true, true)) != null) {
                try {
                    String fqn = String.valueOf(permissionBundle.getPackageName(ProcessServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage())) + "." + permissionNode.getText();
                    if (permissionBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + permissionNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceImplementationBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null) {
                IScoutBundle serviceInterfaceBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true);
                if (serviceInterfaceBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
                IScoutBundle permissionCreateBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_PERMISSION_CREATE, true, true);
                if (permissionCreateBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionCreateBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_PERMISSION_CREATE), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
                IScoutBundle permissionReadBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_PERMISSION_READ, true, true);
                if (permissionReadBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionReadBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_PERMISSION_READ), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
                IScoutBundle permissionUpdateBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE, true, true);
                if (permissionUpdateBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionUpdateBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationClient() {
            ITreeNode[] serviceRegistrationClientNodes;
            IScoutBundle serviceInterfaceBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationClientNodes = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNodes(ProcessServiceNewWizard.TYPE_SERVICE_REG_CLIENT, true, true);
            int n = serviceRegistrationClientNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle != null && serviceRegistrationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNodes(ProcessServiceNewWizard.TYPE_SERVICE_REG_SERVER, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && serviceRegistrationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceImplementationBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), ProcessServiceNewWizard.TYPE_PERMISSION_CREATE, ProcessServiceNewWizard.TYPE_PERMISSION_READ, ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE, ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, ProcessServiceNewWizard.TYPE_SERVICE_REG_CLIENT, ProcessServiceNewWizard.TYPE_SERVICE_REG_SERVER);
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.targetParent.getData() instanceof IScoutBundle && ((IScoutBundle)dndEvent.targetParent.getData()).isBinary()) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            ProcessServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = ProcessServiceNewWizard.TYPE_SERVICE_REG_CLIENT.equals(t) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (ProcessServiceNewWizard.TYPE_SERVICE_REG_SERVER.equals(t) ? "SERVER".equals(dndEvent.targetParent.getType()) : false);
        }

        private void validateDropMove(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = ProcessServiceNewWizard.TYPE_SERVICE_REG_CLIENT.equals(t) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (TreeUtility.isOneOf(t, ProcessServiceNewWizard.TYPE_PERMISSION_CREATE, ProcessServiceNewWizard.TYPE_PERMISSION_READ, ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE, ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE) ? "SHARED".equals(dndEvent.targetParent.getType()) : (ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION.equals(t) || ProcessServiceNewWizard.TYPE_SERVICE_REG_SERVER.equals(t) ? "SERVER".equals(dndEvent.targetParent.getType()) : false));
        }
    }
}

