/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.tablecolumn;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.SmartTableColumnNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.buttongroup.ButtonGroup;
import org.eclipse.scout.sdk.ui.fields.buttongroup.IButtonGroupListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.ScoutWizardDialog;
import org.eclipse.scout.sdk.ui.wizard.tablecolumn.TableColumnNewWizard;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SmartTableColumnNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iColumn = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn");
    final IType lookupCall = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.LookupCall");
    final IType iCodeType = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType");
    private INlsEntry m_nlsName;
    private String m_typeName;
    private String m_genericSignature;
    private IType m_lookupCall;
    private IType m_codeType;
    private TableColumnNewWizard.CONTINUE_OPERATION m_continueOperation;
    private SiblingProposal m_sibling;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_genericTypeField;
    private ProposalTextField m_lookupCallField;
    private ProposalTextField m_codeTypeField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private final IScoutBundle m_clientBundle;
    private final IScoutBundle m_sharedBundle;
    private IType m_superType;
    private IType m_createdColumn;

    public SmartTableColumnNewWizardPage(IType declaringType, TableColumnNewWizard.CONTINUE_OPERATION op) {
        super(SmartTableColumnNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewSmartTableColumn"));
        this.setDescription(Texts.get((String)"CreateANewSmartTableColumn"));
        this.m_declaringType = declaringType;
        this.m_clientBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType.getJavaProject());
        this.m_sharedBundle = this.m_clientBundle.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false);
        this.m_genericSignature = SignatureCache.createTypeSignature((String)Long.class.getName());
        this.m_sibling = SiblingProposal.SIBLING_END;
        this.m_continueOperation = op;
    }

    @Override
    protected void createContent(Composite parent) {
        this.createColumnGroup(parent);
        this.createNextStepsGroup(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
    }

    private void createColumnGroup(Composite p) {
        Group g = new Group(p, 0);
        g.setText(Texts.get((String)"Column"));
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField((Composite)g, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"Name"));
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SmartTableColumnNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = SmartTableColumnNewWizardPage.this.getNlsName();
                    SmartTableColumnNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (SmartTableColumnNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(SmartTableColumnNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)SmartTableColumnNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        SmartTableColumnNewWizardPage.this.m_typeNameField.setText(SmartTableColumnNewWizardPage.this.m_nlsName.getKey());
                    }
                }
                finally {
                    SmartTableColumnNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField((Composite)g, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Column");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SmartTableColumnNewWizardPage.this.m_typeName = SmartTableColumnNewWizardPage.this.m_typeNameField.getText();
                SmartTableColumnNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_genericTypeField = this.getFieldToolkit().createSignatureProposalField((Composite)g, Texts.get((String)"GenericType"), ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType), SignatureProposalProvider.DEFAULT_MOST_USED);
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SmartTableColumnNewWizardPage.this.m_genericSignature = (String)event.proposal;
                SmartTableColumnNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_lookupCallField = this.getFieldToolkit().createJavaElementProposalField((Composite)g, Texts.get((String)"LookupCall"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                return new Object[][]{ScoutTypeUtility.getClassesOnClasspath((IType)SmartTableColumnNewWizardPage.this.lookupCall, (IJavaProject)SmartTableColumnNewWizardPage.this.getSharedBundle().getJavaProject())};
            }
        });
        this.m_lookupCallField.acceptProposal(this.getLookupCall());
        this.m_lookupCallField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SmartTableColumnNewWizardPage.this.setStateChanging(true);
                    SmartTableColumnNewWizardPage.this.m_lookupCall = (IType)event.proposal;
                    SmartTableColumnNewWizardPage.this.m_codeTypeField.acceptProposal(null);
                    SmartTableColumnNewWizardPage.this.m_codeTypeField.setEnabled(SmartTableColumnNewWizardPage.this.m_lookupCall == null);
                }
                finally {
                    SmartTableColumnNewWizardPage.this.setStateChanging(false);
                }
                SmartTableColumnNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_codeTypeField = this.getFieldToolkit().createJavaElementProposalField((Composite)g, Texts.get((String)"CodeType"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                return new Object[][]{ScoutTypeUtility.getClassesOnClasspath((IType)SmartTableColumnNewWizardPage.this.iCodeType, (IJavaProject)SmartTableColumnNewWizardPage.this.getSharedBundle().getJavaProject())};
            }
        });
        this.m_codeTypeField.acceptProposal(this.getCodeType());
        this.m_codeTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SmartTableColumnNewWizardPage.this.setStateChanging(true);
                    SmartTableColumnNewWizardPage.this.m_codeType = (IType)event.proposal;
                    SmartTableColumnNewWizardPage.this.m_lookupCallField.acceptProposal(null);
                    SmartTableColumnNewWizardPage.this.m_lookupCallField.setEnabled(SmartTableColumnNewWizardPage.this.m_codeType == null);
                }
                finally {
                    SmartTableColumnNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_siblingField = this.getFieldToolkit().createSiblingProposalField((Composite)g, this.m_declaringType, this.iColumn);
        this.m_siblingField.acceptProposal(this.m_sibling);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SmartTableColumnNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                SmartTableColumnNewWizardPage.this.pingStateChanging();
            }
        });
        g.setLayout((Layout)new GridLayout(1, false));
        g.setLayoutData((Object)new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_lookupCallField.setLayoutData(new GridData(768));
        this.m_codeTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    private void createNextStepsGroup(Composite p) {
        Group g = new Group(p, 0);
        g.setText(Texts.get((String)"NextStep"));
        g.setLayout((Layout)new GridLayout(1, false));
        g.setLayoutData((Object)new GridData(768));
        ButtonGroup nextStepOptions = new ButtonGroup((Composite)g, 16);
        nextStepOptions.createButton(Texts.get((String)"CreateMoreColumn"), TableColumnNewWizard.CONTINUE_OPERATION.ADD_MORE_COLUMNS);
        nextStepOptions.createButton(Texts.get((String)"FinishWizard"), TableColumnNewWizard.CONTINUE_OPERATION.FINISH);
        nextStepOptions.addButtonGroupListener(new IButtonGroupListener<TableColumnNewWizard.CONTINUE_OPERATION>(){

            @Override
            public void handleSelectionChanged(List<TableColumnNewWizard.CONTINUE_OPERATION> newSelection) {
                SmartTableColumnNewWizardPage.this.m_continueOperation = newSelection.get(0);
            }
        });
        nextStepOptions.setValue(this.m_continueOperation);
        nextStepOptions.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        if (TableColumnNewWizard.CONTINUE_OPERATION.ADD_MORE_COLUMNS == this.m_continueOperation) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TableColumnNewWizard wizard = new TableColumnNewWizard(SmartTableColumnNewWizardPage.this.m_continueOperation);
                    wizard.initWizard(SmartTableColumnNewWizardPage.this.m_declaringType);
                    ScoutWizardDialog wizardDialog = new ScoutWizardDialog(wizard);
                    wizardDialog.open();
                }
            });
        }
        SmartTableColumnNewOperation operation = new SmartTableColumnNewOperation(this.m_declaringType, true);
        IType superType = this.getSuperType();
        if (superType != null) {
            String sig = null;
            sig = this.getGenericSignature() != null ? SignatureCache.createTypeSignature((String)(String.valueOf(superType.getFullyQualifiedName()) + "<" + Signature.toString((String)this.getGenericSignature()) + ">")) : SignatureCache.createTypeSignature((String)superType.getFullyQualifiedName());
            operation.setSuperTypeSignature(sig);
        }
        operation.setNlsEntry(this.getNlsName());
        operation.setTypeName(this.getTypeName());
        operation.setCodeType(this.getCodeType());
        if (this.getLookupCall() != null) {
            operation.setLookupCall(this.getLookupCall());
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredTable((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_COLUMN));
        } else {
            operation.setSibling(this.getSibling().getElement());
        }
        operation.validate();
        operation.run(monitor, workingCopyManager);
        this.m_createdColumn = operation.getCreatedColumn();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusGenericType());
            multiStatus.add(this.getStatusLookupCallCodeType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Column")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_className"));
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusGenericType() throws JavaModelException {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusLookupCallCodeType() {
        if (this.getCodeType() != null && this.getLookupCall() != null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"OnlyOneOfCodeTypeOrLookupCallCanBeProcessed"));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public IScoutBundle getSharedBundle() {
        return this.m_sharedBundle;
    }

    public IType getCreatedColumn() {
        return this.m_createdColumn;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setGenericSignature(String genericSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericSignature;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getGenericSignature() {
        return this.m_genericSignature;
    }

    public void setLookupCall(IType lookupCall) {
        try {
            this.setStateChanging(true);
            this.m_lookupCall = lookupCall;
            if (this.isControlCreated()) {
                this.m_codeTypeField.acceptProposal(lookupCall);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getLookupCall() {
        return this.m_lookupCall;
    }

    public IType getCodeType() {
        return this.m_codeType;
    }

    public void setCodeType(IType codeType) {
        try {
            this.setStateChanging(true);
            this.m_codeType = codeType;
            if (this.isControlCreated()) {
                this.m_codeTypeField.acceptProposal(codeType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

