/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util;

import java.text.ParseException;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;

public final class NamingUtility {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("[^abcdefghijklmnopqrstuvwxyz0123456789]");

    private NamingUtility() {
    }

    public static String getSimpleName(String qualifiedName) {
        int i = qualifiedName.lastIndexOf(46);
        if (i >= 0) {
            return qualifiedName.substring(i + 1);
        }
        return qualifiedName;
    }

    public static String getPackage(String qualifiedClassName) {
        int i = qualifiedClassName.lastIndexOf(46);
        if (i >= 0) {
            return qualifiedClassName.substring(0, i);
        }
        return qualifiedClassName;
    }

    public static String parseJavaTypeName(String name, String text, String[] discouragedSuffixes) throws ParseException {
        if (text == null) {
            text = "";
        }
        if (text.length() <= 1) {
            return null;
        }
        if (!Character.isJavaIdentifierStart(text.charAt(0))) {
            throw new ParseException(String.valueOf(name) + " must start with upper case A-Z", 0);
        }
        if (!Character.isUpperCase(text.charAt(0))) {
            text = String.valueOf(Character.toUpperCase(text.charAt(0))) + text.substring(1);
        } else {
            int i;
            String textLow = text.toLowerCase();
            if (discouragedSuffixes != null) {
                i = 0;
                while (i < discouragedSuffixes.length) {
                    if (textLow.endsWith(discouragedSuffixes[i].toLowerCase())) {
                        throw new ParseException(String.valueOf(name) + " must not end with '" + discouragedSuffixes[i] + "'", 0);
                    }
                    ++i;
                }
            }
            i = 1;
            while (i < text.length()) {
                if (!Character.isJavaIdentifierPart(text.charAt(i))) {
                    throw new ParseException("'" + text + "' is not a valid java name", 0);
                }
                ++i;
            }
        }
        return text;
    }

    public static String removeSuffixes(String s, String ... suffixes) {
        return StringUtility.removeSuffixes((String)s, (String[])suffixes);
    }

    public static String toVariableName(String javaName) {
        if (javaName == null || javaName.length() == 0) {
            return null;
        }
        return String.valueOf(Character.toLowerCase(javaName.charAt(0))) + javaName.substring(1);
    }

    public static String toBeanName(String javaName) {
        if (javaName == null || javaName.length() == 0) {
            return null;
        }
        return String.valueOf(Character.toUpperCase(javaName.charAt(0))) + javaName.substring(1);
    }

    public static String toJavaCamelCase(String input) {
        return NamingUtility.toJavaCamelCase(input, true);
    }

    public static int stringDistance(String s1, String s2) {
        if (s1 == null || s2 == null || CompareUtility.equals((Object)s1, (Object)s2)) {
            return 0;
        }
        int l1 = s1.length();
        int l2 = s2.length();
        if (l1 == 0) {
            return l2;
        }
        if (l2 == 0) {
            return l1;
        }
        int[] col0 = new int[l1 + 1];
        int[] col1 = new int[l1 + 1];
        int i = 0;
        while (i <= l1) {
            col0[i] = i;
            ++i;
        }
        int j = 1;
        while (j <= l2) {
            char jth = s2.charAt(j - 1);
            col1[0] = j;
            i = 1;
            while (i <= l1) {
                int cost = s1.charAt(i - 1) == jth ? 0 : 1;
                col1[i] = Math.min(Math.min(col1[i - 1] + 1, col0[i] + 1), col0[i - 1] + cost);
                ++i;
            }
            int[] col = col0;
            col0 = col1;
            col1 = col;
            ++j;
        }
        return col0[l1];
    }

    public static String toJavaCamelCase(String input, boolean lowerCaseFirstToken) {
        if (!StringUtility.hasText((String)input)) {
            return null;
        }
        StringBuilder camel = new StringBuilder(input.length());
        String[] tokens = CAMEL_CASE_PATTERN.split(input.toLowerCase());
        int i = 0;
        while (i < tokens.length) {
            String t = tokens[i];
            if (StringUtility.hasText((String)t)) {
                if (i == 0 && lowerCaseFirstToken) {
                    camel.append(t);
                } else {
                    camel.append(Character.toUpperCase(t.charAt(0)));
                    camel.append(t.substring(1));
                }
            }
            ++i;
        }
        return camel.toString();
    }
}

