/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.jdt.finegraned.FineGrainedAstMatcher;
import org.eclipse.scout.sdk.util.jdt.finegraned.FineGrainedJavaElementDelta;

public class JdtEventCollector {
    private final ICompilationUnit m_icu;
    private long m_lastModification;
    private CompilationUnit m_ast;
    private HashMap<IJavaElement, JdtEvent> m_events;

    JdtEventCollector(ICompilationUnit icu) {
        this.m_icu = icu;
        this.m_lastModification = icu.getResource().getModificationStamp();
        this.m_events = new HashMap();
        this.m_ast = this.createAst();
    }

    private CompilationUnit createAst() {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setCompilerOptions((Map)JavaCore.getOptions());
        parser.setKind(8);
        parser.setSource(this.getCompilationUnit());
        return (CompilationUnit)parser.createAST(null);
    }

    public FineGrainedJavaElementDelta[] updateAst() {
        final CompilationUnit newAst = this.createAst();
        final HashSet set = new HashSet();
        FineGrainedAstMatcher matcher = new FineGrainedAstMatcher(){

            @Override
            protected boolean processDelta(boolean match, ASTNode node, Object other) {
                if (!match) {
                    try {
                        IJavaElement e = ((ICompilationUnit)newAst.getJavaElement()).getElementAt(node.getStartPosition());
                        if (e != null) {
                            set.add(new FineGrainedJavaElementDelta(e));
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                return true;
            }
        };
        newAst.subtreeMatch((ASTMatcher)matcher, (Object)this.m_ast);
        this.m_ast = newAst;
        return set.toArray(new FineGrainedJavaElementDelta[set.size()]);
    }

    public void addEvent(JdtEvent e) {
        this.m_events.put(e.getElement(), e);
    }

    public boolean containsEventFor(IJavaElement element) {
        return this.m_events.containsKey(element);
    }

    public boolean hasEvents() {
        return !this.m_events.isEmpty();
    }

    public JdtEvent[] getEvents() {
        return this.m_events.values().toArray(new JdtEvent[this.m_events.size()]);
    }

    public JdtEvent[] removeAllEvents(long resourceTimestamp) {
        JdtEvent[] events = this.m_events.values().toArray(new JdtEvent[this.m_events.size()]);
        this.m_events.clear();
        this.m_lastModification = resourceTimestamp;
        return events;
    }

    public boolean isEmpty() {
        return this.m_events.size() == 0;
    }

    public long getLastModification() {
        return this.m_lastModification;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.m_icu;
    }

    public CompilationUnit getAst() {
        return this.m_ast;
    }
}

