/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.scout.commons.CompositeLong;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeCache;

public final class TypeCache
implements ITypeCache {
    private static final TypeCache INSTANCE = new TypeCache();
    private final Object m_cacheLock;
    private HashMap<String, ArrayList<IType>> m_cache = new HashMap();
    private P_ResourceListener m_resourceChangeListener;

    public static TypeCache getInstance() {
        return INSTANCE;
    }

    private TypeCache() {
        this.m_cacheLock = new Object();
        this.m_resourceChangeListener = new P_ResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.m_resourceChangeListener);
    }

    @Override
    public void dispose() {
        if (this.m_cache != null) {
            this.clearCache();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.m_resourceChangeListener);
        this.m_resourceChangeListener = null;
        this.m_cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        Object object = this.m_cacheLock;
        synchronized (object) {
            this.m_cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IType[] getAllCachedTypes() {
        ArrayList<IType> types = new ArrayList<IType>();
        Object object = this.m_cacheLock;
        synchronized (object) {
            for (List list : this.m_cache.values()) {
                for (IType t : list) {
                    types.add(t);
                }
            }
        }
        return types.toArray(new IType[types.size()]);
    }

    @Override
    public IType getType(String fullyQualifiedName) {
        ArrayList<IType> types = this.getTypesInternal(fullyQualifiedName);
        if (types != null) {
            if (types.size() == 1) {
                return types.get(0);
            }
            if (types.size() > 1) {
                SdkUtilActivator.logWarning("found more than one type match for '" + fullyQualifiedName + "' (matches: '" + types.size() + "').");
                return types.get(0);
            }
        }
        return null;
    }

    @Override
    public IType[] getTypes(String fullyQualifiedName) {
        ArrayList<IType> types = this.getTypesInternal(fullyQualifiedName);
        if (types == null) {
            return new IType[0];
        }
        return types.toArray(new IType[types.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<IType> getTypesInternal(String fullyQualifiedName) {
        if (StringUtility.isNullOrEmpty((String)fullyQualifiedName)) {
            return null;
        }
        fullyQualifiedName = fullyQualifiedName.replace('$', '.');
        ArrayList<Object> types = null;
        Object object = this.m_cacheLock;
        synchronized (object) {
            types = this.m_cache.get(fullyQualifiedName);
            if (types == null) {
                types = new ArrayList();
            } else if (types.size() > 0) {
                Iterator<Object> it = types.iterator();
                while (it.hasNext()) {
                    IType type = (IType)it.next();
                    if (TypeUtility.exists((IJavaElement)type)) continue;
                    it.remove();
                }
            }
            if (types.size() == 0) {
                this.m_cache.remove(fullyQualifiedName);
            }
        }
        if (types.size() == 0) {
            try {
                types = this.resolveType(fullyQualifiedName);
            }
            catch (CoreException e) {
                SdkUtilActivator.logError("error resolving type '" + fullyQualifiedName + "'.", e);
            }
            object = this.m_cacheLock;
            synchronized (object) {
                if (types.size() > 0) {
                    this.m_cache.put(fullyQualifiedName, types);
                } else {
                    this.m_cache.remove(fullyQualifiedName);
                }
            }
        }
        return types;
    }

    @Override
    public boolean existsType(String fullyQualifiedName) {
        if (StringUtility.isNullOrEmpty((String)fullyQualifiedName)) {
            return false;
        }
        return TypeUtility.exists((IJavaElement)this.getType(fullyQualifiedName));
    }

    private ArrayList<IType> resolveType(final String fqn) throws CoreException {
        final TreeMap matchList = new TreeMap();
        String fastPat = fqn;
        int i = fastPat.lastIndexOf(46);
        if (i >= 0) {
            fastPat = fastPat.substring(i + 1);
        }
        if (!StringUtility.hasText((String)fastPat)) {
            return new ArrayList<IType>();
        }
        new SearchEngine().search(SearchPattern.createPattern((String)fastPat, (int)0, (int)0, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), new SearchRequestor(){

            public final void acceptSearchMatch(SearchMatch match) throws CoreException {
                TypeDeclarationMatch typeMatch;
                IType t;
                if (match instanceof TypeDeclarationMatch && (t = (IType)(typeMatch = (TypeDeclarationMatch)match).getElement()).exists() && t.getJavaProject().exists() && t.getFullyQualifiedName('.').indexOf(fqn) >= 0) {
                    matchList.put(new CompositeLong((long)(t.isBinary() ? 1 : 0), (long)matchList.size()), t);
                }
            }
        }, null);
        return new ArrayList<IType>(matchList.values());
    }

    private class P_ResourceListener
    implements IResourceChangeListener {
        private P_ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta visitDelta) {
                            IResource resource = visitDelta.getResource();
                            if (resource.getType() == 4 && (visitDelta.getFlags() & 0x4002) != 0) {
                                TypeCache.this.clearCache();
                                return false;
                            }
                            return true;
                        }
                    });
                } else if (event.getType() == 4 && event.getResource().getType() == 4) {
                    TypeCache.this.clearCache();
                }
            }
            catch (CoreException e) {
                SdkUtilActivator.logWarning(e);
            }
        }
    }
}

