/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.jdt;

import java.util.EventObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class JdtEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int CHANGED = 4;
    public static final int BUFFER_DIRTY = 10;
    public static final int BUFFER_SYNC = 11;
    private final int m_eventType;
    private final IJavaElement m_element;
    private IType m_declaringType;
    private ITypeHierarchy m_superTypeHierarchy;

    public JdtEvent(Object source, int eventType, IJavaElement element) {
        super(source);
        this.m_eventType = eventType;
        this.m_element = element;
    }

    public int getEventType() {
        return this.m_eventType;
    }

    public IJavaElement getElement() {
        return this.m_element;
    }

    public int getElementType() {
        if (this.getElement() == null) {
            return -1;
        }
        return this.m_element.getElementType();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JdtEvent)) {
            return false;
        }
        JdtEvent event = (JdtEvent)obj;
        if (!CompareUtility.equals((Object)event.getElement(), (Object)this.m_element)) {
            return false;
        }
        if (event.getEventType() != this.m_eventType) {
            return false;
        }
        return CompareUtility.equals((Object)event.getSource(), (Object)this.getSource());
    }

    public int hashCode() {
        int hash = this.m_eventType;
        if (this.getSource() != null) {
            hash ^= this.getSource().hashCode();
        }
        if (this.getElement() != null) {
            hash ^= this.getElement().hashCode();
        }
        return hash;
    }

    public ITypeHierarchy getSuperTypeHierarchy() {
        if (this.m_superTypeHierarchy == null && TypeUtility.exists(this.getElement()) && this.getElement().getElementType() == 7) {
            try {
                this.m_superTypeHierarchy = ((IType)this.getElement()).newSupertypeHierarchy(null);
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logError("could not create super type hierarchy for '" + this.getElement().getElementName() + "'.");
            }
        }
        return this.m_superTypeHierarchy;
    }

    public IType getDeclaringType() {
        if (this.m_declaringType == null && this.getElement() != null) {
            this.m_declaringType = this.getElementType() == 7 ? ((IType)this.getElement()).getDeclaringType() : (IType)this.getElement().getAncestor(7);
        }
        return this.m_declaringType;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("JdtEvent <");
        switch (this.getEventType()) {
            case 1: {
                builder.append("ADDED ");
                break;
            }
            case 4: {
                builder.append("CHANGED ");
                break;
            }
            case 2: {
                builder.append("REMOVED ");
            }
        }
        builder.append(String.valueOf(this.getElementType(this.getElement())) + " ");
        if (this.getElement() != null) {
            builder.append("'" + this.getElement().getElementName() + "' ");
        } else {
            builder.append("'NULL ELEMENT' ");
        }
        if (this.getDeclaringType() != null) {
            builder.append("declaringType='" + this.getDeclaringType().getElementName() + "' ");
        } else {
            builder.append("declaringType='NULL' ");
        }
        builder.append(">");
        return builder.toString();
    }

    private String getElementType(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return "JAVA_MODEL ";
            }
            case 2: {
                return "JAVA_PROJECT ";
            }
            case 3: {
                return "PACKAGE_FRAGMENT_ROOT ";
            }
            case 4: {
                return "PACKAGE_FRAGMENT ";
            }
            case 5: {
                return "COMPILATION_UNIT ";
            }
            case 6: {
                return "CLASS_FILE ";
            }
            case 7: {
                return "TYPE ";
            }
            case 8: {
                return "FIELD ";
            }
            case 9: {
                return "METHOD ";
            }
            case 10: {
                return "INITIALIZER ";
            }
            case 11: {
                return "PACKAGE_DECLARATION ";
            }
            case 12: {
                return "IMPORT_CONTAINER ";
            }
            case 13: {
                return "IMPORT_DECLARATION ";
            }
            case 14: {
                return "LOCAL_VARIABLE ";
            }
            case 15: {
                return "TYPE_PARAMETER ";
            }
            case 16: {
                return "ANNOTATION ";
            }
        }
        return "???";
    }
}

