/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.log;

import java.util.HashSet;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.util.log.SdkLogManager;

public class LogStatus
extends Status {
    private StackTraceElement m_callerElement;

    public LogStatus(Class<?> wrapperClazz, int severity, String pluginId, int code, String message, Throwable exception) {
        super(severity, pluginId, code, message, exception);
        this.setWrapperClass(wrapperClazz);
    }

    public LogStatus(Class<?> wrapperClazz, int severity, String pluginId, String message, Throwable exception) {
        super(severity, pluginId, message, exception);
        this.setWrapperClass(wrapperClazz);
    }

    public LogStatus(Class<?> wrapperClazz, int severity, String pluginId, String message) {
        super(severity, pluginId, message);
        this.setWrapperClass(wrapperClazz);
    }

    public String getMessage() {
        StringBuilder message = new StringBuilder();
        if (this.m_callerElement != null) {
            message.append(this.m_callerElement + "\n\t");
        }
        message.append(super.getMessage());
        return message.toString();
    }

    private void setWrapperClass(Class<?> wrapperClazz) {
        if (this.m_callerElement == null) {
            this.m_callerElement = this.getCallerLine(wrapperClazz);
        }
    }

    private StackTraceElement getCallerLine(Class wrapperClass) {
        try {
            StackTraceElement[] trace = new Exception().getStackTrace();
            int traceIndex = 0;
            HashSet<String> ignoredPackagePrefixes = new HashSet<String>();
            ignoredPackagePrefixes.add(LogStatus.class.getName());
            ignoredPackagePrefixes.add(SdkLogManager.class.getName());
            if (wrapperClass != null) {
                ignoredPackagePrefixes.add(wrapperClass.getName());
            }
            while (traceIndex < trace.length) {
                boolean found = true;
                for (String prefix : ignoredPackagePrefixes) {
                    if (!trace[traceIndex].getClassName().startsWith(prefix)) continue;
                    found = false;
                    break;
                }
                if (found) break;
                ++traceIndex;
            }
            if (traceIndex >= trace.length) {
                traceIndex = trace.length - 1;
            }
            return trace[traceIndex];
        }
        catch (Throwable t) {
            return null;
        }
    }
}

