/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.pde;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;

public final class LazyPluginModel {
    private final IProject m_project;
    private final IFile m_manifestFile;
    private final IFile m_pluginXmlFile;
    private final IFile m_buildPropertiesFile;
    private BundleDescription m_desc;
    private BundlePluginModelBase m_bundlePluginModel;
    private IPluginBase m_pluginBase;
    private IBundle m_bundle;
    private WorkspaceBundleModel m_bundleModel;
    private WorkspaceBuildModel m_buildModel;
    private WorkspaceExtensionsModel m_extensionsModel;

    public LazyPluginModel(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("null project not allowed.");
        }
        this.m_project = project;
        this.m_manifestFile = this.getProject().getFile("META-INF/MANIFEST.MF");
        this.m_pluginXmlFile = this.getProject().getFile("plugin.xml");
        this.m_buildPropertiesFile = this.getProject().getFile("build.properties");
        if (!this.isInteresting()) {
            throw new IllegalArgumentException("the passed project is not a valid plugin.");
        }
    }

    private boolean isInteresting() {
        return this.getProject() != null && this.getProject().isOpen() && this.getProject().exists() && this.getManifestFile() != null && this.getManifestFile().exists() && this.getPluginXmlFile() != null && this.getBuildPropertiesFile() != null;
    }

    public synchronized BundlePluginModelBase getBundlePluginModel() {
        if (this.m_bundlePluginModel == null) {
            this.m_bundlePluginModel = new BundlePluginModel();
            this.m_bundlePluginModel.setEnabled(true);
            this.m_bundlePluginModel.setBundleDescription(this.getBundleDescription());
            this.m_bundlePluginModel.setBundleModel((IBundleModel)this.getBundleModel());
            this.m_bundlePluginModel.setExtensionsModel((ISharedExtensionsModel)this.getExtensionsModel());
            this.m_bundlePluginModel.setBuildModel(this.getBuildModel());
        }
        return this.m_bundlePluginModel;
    }

    public synchronized WorkspaceExtensionsModel getExtensionsModel() {
        if (this.m_extensionsModel == null) {
            this.m_extensionsModel = new WorkspaceExtensionsModel(this.getPluginXmlFile());
            this.m_extensionsModel.setBundleModel((IBundlePluginModelBase)this.getBundlePluginModel());
            this.m_extensionsModel.load(this.getBundleDescription(), LazyPluginModel.getPdeState());
            this.m_extensionsModel.setDirty(false);
        }
        return this.m_extensionsModel;
    }

    public synchronized IPluginBase getPluginBase() {
        if (this.m_pluginBase == null) {
            this.m_pluginBase = this.getBundlePluginModel().getPluginBase(true);
        }
        return this.m_pluginBase;
    }

    public synchronized IBuildModel getBuildModel() {
        if (this.m_buildModel == null) {
            this.m_buildModel = new WorkspaceBuildModel(this.getBuildPropertiesFile());
            this.m_buildModel.load();
            this.m_buildModel.setDirty(false);
        }
        return this.m_buildModel;
    }

    public synchronized IBundle getBundle() {
        if (this.m_bundle == null) {
            this.m_bundle = this.getBundleModel().getBundle();
        }
        return this.m_bundle;
    }

    public synchronized WorkspaceBundleModel getBundleModel() {
        if (this.m_bundleModel == null) {
            this.m_bundleModel = new WorkspaceBundleModel(this.getManifestFile());
            this.m_bundleModel.load();
            this.m_bundleModel.setDirty(false);
        }
        return this.m_bundleModel;
    }

    public static final PDEState getPdeState() {
        return PDECore.getDefault().getModelManager().getState();
    }

    public synchronized BundleDescription getBundleDescription() {
        if (this.m_desc == null) {
            IPluginModelBase pluginBase = PDECore.getDefault().getModelManager().findModel(this.getProject());
            if (pluginBase != null) {
                this.m_desc = pluginBase.getBundleDescription();
            }
            if (this.m_desc == null) {
                throw new IllegalArgumentException("project '" + this.getProject().getName() + "' could not be found in the workspace.");
            }
        }
        return this.m_desc;
    }

    public synchronized void save() {
        if (this.m_bundlePluginModel != null && this.m_bundlePluginModel.isDirty()) {
            this.m_bundlePluginModel.save();
        } else {
            if (this.m_bundleModel != null && this.m_bundleModel.isDirty()) {
                this.m_bundleModel.save();
            }
            if (this.m_extensionsModel != null && this.m_extensionsModel.isDirty()) {
                this.m_extensionsModel.save();
            }
        }
        if (this.m_buildModel != null && this.m_buildModel.isDirty()) {
            this.m_buildModel.save();
        }
    }

    public IProject getProject() {
        return this.m_project;
    }

    public IFile getManifestFile() {
        return this.m_manifestFile;
    }

    public IFile getPluginXmlFile() {
        return this.m_pluginXmlFile;
    }

    public IFile getBuildPropertiesFile() {
        return this.m_buildPropertiesFile;
    }
}

