/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.pde;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.product.WorkspaceProductModel;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.log.ScoutStatus;

public final class LazyProductFileModel {
    private static final Pattern FRAGMENT_PATTERN = Pattern.compile("^(\\sfragment\\=\\\")([^\\\"]*)(\\\")");
    private final IFile m_productFile;
    private WorkspaceProductModel m_productModel;
    private IConfigurationFileInfo m_configFileInfo;
    private Properties m_configFileProperties;
    private Hashtable<Object, Object> m_origConfigFileProperties;
    private IFile m_configIniFile;

    public LazyProductFileModel(IFile productFile) {
        if (productFile == null || !productFile.exists()) {
            throw new IllegalArgumentException("invalid product file passed");
        }
        this.m_productFile = productFile;
    }

    public synchronized WorkspaceProductModel getWorkspaceProductModel() throws CoreException {
        if (this.m_productModel == null) {
            this.m_productModel = new WorkspaceProductModel(this.m_productFile, true);
            this.m_productModel.load();
            this.m_productModel.setDirty(false);
        }
        return this.m_productModel;
    }

    public synchronized IConfigurationFileInfo getConfigurationFileInfo() throws CoreException {
        if (this.m_configFileInfo == null) {
            this.m_configFileInfo = this.getWorkspaceProductModel().getProduct().getConfigurationFileInfo();
        }
        return this.m_configFileInfo;
    }

    public synchronized IFile getConfigIniFile() throws CoreException {
        String osPath;
        if (this.m_configIniFile == null && (osPath = this.getConfigurationFileInfo().getPath(Platform.getOS())) != null) {
            IPath path = new Path(osPath).removeFirstSegments(1);
            this.m_configIniFile = this.m_productFile.getProject().getFile(path);
            if (this.m_configIniFile == null || !this.m_configIniFile.exists()) {
                this.m_configIniFile = null;
                throw new CoreException((IStatus)new ScoutStatus("could not find product configuration file: " + path.toOSString()));
            }
        }
        return this.m_configIniFile;
    }

    public synchronized Properties getConfigFileProperties() throws CoreException {
        if (this.m_configFileProperties == null) {
            this.m_configFileProperties = new Properties();
            IFile configIni = this.getConfigIniFile();
            if (configIni == null) {
                return new Properties();
            }
            InputStream is = null;
            try {
                try {
                    is = configIni.getContents();
                    this.m_configFileProperties.load(is);
                    this.m_origConfigFileProperties = (Hashtable)this.m_configFileProperties.clone();
                }
                catch (IOException e) {
                    this.m_configFileProperties = null;
                    throw new CoreException((IStatus)new ScoutStatus("unable to load product configuration file: " + configIni.getFullPath().toOSString(), e));
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        SdkUtilActivator.logWarning("could not close input stream of file '" + configIni.getFullPath() + "'.", e);
                    }
                }
            }
        }
        return this.m_configFileProperties;
    }

    public synchronized void save() throws CoreException {
        if (this.m_productModel != null && this.m_productModel.isDirty()) {
            this.saveProductModel();
        }
        if (this.isConfigFileDirty()) {
            this.saveConfigIni();
        }
    }

    private void saveConfigIni() throws CoreException {
        IFile configIni = this.getConfigIniFile();
        if (configIni == null) {
            return;
        }
        OutputStream stream = null;
        try {
            try {
                stream = new BufferedOutputStream(new FileOutputStream(configIni.getRawLocation().toFile()));
                this.m_configFileProperties.store(stream, null);
                stream.flush();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new ScoutStatus("unable to save product configuration file: " + configIni.getRawLocation().toOSString(), e));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            configIni.refreshLocal(1, null);
        }
    }

    private boolean isConfigFileDirty() {
        if (this.m_configFileProperties == null || this.m_origConfigFileProperties == null) {
            return false;
        }
        if (this.m_configFileProperties.size() != this.m_origConfigFileProperties.size()) {
            return true;
        }
        for (Map.Entry<Object, Object> entry : this.m_configFileProperties.entrySet()) {
            if (!CompareUtility.notEquals((Object)this.m_origConfigFileProperties.get(entry.getKey()), (Object)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private void saveProductModel() throws CoreException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        PrintWriter writer = new PrintWriter(out, false){

            @Override
            public void print(String s) {
                Matcher matcher = FRAGMENT_PATTERN.matcher(s);
                if (matcher.matches() && StringUtility.isNullOrEmpty((String)matcher.group(2))) {
                    return;
                }
                super.print(s);
            }
        };
        this.m_productModel.save(writer);
        writer.flush();
        writer.close();
        IFile file = (IFile)this.m_productModel.getUnderlyingResource();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        file.setContents((InputStream)in, true, false, null);
        file.refreshLocal(1, null);
    }
}

