/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.signature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.signature.FullyQuallifiedValidator;
import org.eclipse.scout.sdk.util.signature.IImportValidator;

public final class SignatureUtility {
    private static final Pattern QUALIFIED_SIG_REGEX = Pattern.compile("^([\\+\\[]*)([^\\<\\(\\;]*)(.*)$");
    private static final Pattern SIG_REPLACEMENT_REGEX = Pattern.compile("[\\.\\$]{1}");
    private static final Pattern DOL_REPLACEMENT_REGEX = Pattern.compile("\\$");
    private static final Pattern PARAM_SIG_REPLACEMENT_REGEX = Pattern.compile("^([^\\:]*)\\:(.*)$");
    public static final char C_ARBITRARY_ARRAY = '|';
    public static final int ARBITRARY_ARRAY_SIGNATURE = 29;

    private SignatureUtility() {
    }

    public static int getTypeSignatureKind(String signature) {
        if (signature == null || signature.length() < 1) {
            throw new IllegalArgumentException("signature is null or less than 1 char.");
        }
        char c = signature.charAt(0);
        if (c == '|') {
            return 29;
        }
        return Signature.getTypeSignatureKind((String)signature);
    }

    private static String quoteRegexSpecialCharacters(String input) {
        input = input.replace("\\", "\\\\");
        input = input.replace(".", "\\.");
        input = input.replace("+", "\\+");
        input = input.replace("?", "\\?");
        input = input.replace("^", "\\^");
        input = input.replace("$", "\\$");
        input = input.replace("[", "\\[");
        input = input.replace("]", "\\]");
        input = input.replace("(", "\\(");
        input = input.replace(")", "\\)");
        input = input.replace("{", "\\{");
        input = input.replace("}", "\\}");
        input = input.replace("*", "\\*");
        input = input.replace("|", "\\|");
        return input;
    }

    public static String getResolvedSignature(String signature, IType signatureOwner) throws JavaModelException {
        return SignatureUtility.getResolvedSignature(signature, signatureOwner, null);
    }

    private static boolean endsWith(String stringToSearchIn, char charToFind) {
        return stringToSearchIn != null && !stringToSearchIn.isEmpty() && stringToSearchIn.charAt(stringToSearchIn.length() - 1) == charToFind;
    }

    private static boolean startsWith(String stringToSearchIn, char charToFind) {
        return stringToSearchIn != null && !stringToSearchIn.isEmpty() && stringToSearchIn.charAt(0) == charToFind;
    }

    public static String getResolvedSignature(String signature, IType signatureOwner, IType contextType) throws JavaModelException {
        StringBuilder sigBuilder = new StringBuilder();
        switch (SignatureUtility.getTypeSignatureKind(signature)) {
            case 5: {
                sigBuilder.append(signature.charAt(0));
                if (signature.length() <= 1) break;
                sigBuilder.append(SignatureUtility.getResolvedSignature(signature.substring(1), signatureOwner, contextType));
                break;
            }
            case 4: {
                sigBuilder.append('[');
                sigBuilder.append(SignatureUtility.getResolvedSignature(signature.substring(1), signatureOwner, contextType));
                break;
            }
            case 29: {
                sigBuilder.append('|');
                sigBuilder.append(SignatureUtility.getResolvedSignature(signature.substring(1), signatureOwner, contextType));
                break;
            }
            case 2: {
                if (SignatureUtility.endsWith(signature, ';')) {
                    signature = signature.substring(0, signature.length() - 1);
                }
                sigBuilder.append(signature);
                break;
            }
            case 3: {
                String sig = SignatureUtility.findTypeParameterSignature(signature, signatureOwner, contextType);
                sigBuilder.append(SignatureUtility.getResolvedSignature(sig, signatureOwner, contextType));
                break;
            }
            case 1: {
                String[] typeArguments = Signature.getTypeArguments((String)signature);
                signature = Signature.getTypeErasure((String)signature);
                signature = SIG_REPLACEMENT_REGEX.matcher(signature).replaceAll(".");
                if (SignatureUtility.startsWith(signature, 'Q')) {
                    String[][] resolvedTypeName = signatureOwner.resolveType(Signature.getSignatureSimpleName((String)signature));
                    if (resolvedTypeName != null) {
                        if (resolvedTypeName.length == 1) {
                            String fqName = resolvedTypeName[0][0];
                            if (fqName != null && fqName.length() > 0) {
                                fqName = String.valueOf(fqName) + ".";
                            }
                            fqName = String.valueOf(fqName) + resolvedTypeName[0][1];
                            signature = SignatureCache.createTypeSignature(fqName);
                        }
                    } else {
                        String tmpSig = SignatureUtility.findTypeParameterSignature(signature, signatureOwner, contextType);
                        signature = SignatureUtility.getResolvedSignature(tmpSig, signatureOwner, contextType);
                    }
                }
                if (SignatureUtility.endsWith(signature, ';')) {
                    signature = signature.substring(0, signature.length() - 1);
                }
                sigBuilder.append(signature);
                if (typeArguments != null && typeArguments.length > 0) {
                    sigBuilder.append('<');
                    int i = 0;
                    while (i < typeArguments.length) {
                        sigBuilder.append(SignatureUtility.getResolvedSignature(typeArguments[i], signatureOwner, contextType));
                        ++i;
                    }
                    sigBuilder.append('>');
                }
                sigBuilder.append(';');
                break;
            }
            default: {
                SdkUtilActivator.logWarning("unhandled signature type: '" + Signature.getTypeSignatureKind((String)signature) + "'");
            }
        }
        return sigBuilder.toString();
    }

    public static boolean isEqualSignature(String signature1, String signature2) {
        if (signature1 == null && signature2 == null) {
            return true;
        }
        if (signature1 == null || signature2 == null) {
            return false;
        }
        signature1 = DOL_REPLACEMENT_REGEX.matcher(signature1).replaceAll(".");
        signature2 = DOL_REPLACEMENT_REGEX.matcher(signature2).replaceAll(".");
        return signature1.equals(signature2);
    }

    public static String getTypeReferenceFromFqn(String fullyQualifiedTypeName, IImportValidator importValidator) throws JavaModelException {
        return SignatureUtility.getTypeReference(SignatureCache.createTypeSignature(fullyQualifiedTypeName), importValidator);
    }

    public static String getTypeReference(String signature) throws JavaModelException {
        return SignatureUtility.getTypeReference(signature, null, null, new FullyQuallifiedValidator());
    }

    public static String getTypeReference(String signature, IImportValidator importValidator) throws JavaModelException {
        return SignatureUtility.getTypeReference(signature, null, null, importValidator);
    }

    public static String getTypeReference(String signature, IType signatureOwner, IImportValidator validator) throws JavaModelException {
        return SignatureUtility.getTypeReference(signature, signatureOwner, null, validator);
    }

    private static String getTypeReference(String signature, IType signatureOwner, IType contextType, IImportValidator validator) throws JavaModelException {
        StringBuilder sigBuilder = new StringBuilder();
        int arrayCount = 0;
        boolean isArbitraryArray = false;
        switch (SignatureUtility.getTypeSignatureKind(signature)) {
            case 5: {
                sigBuilder.append("?");
                if (signature.length() <= 1) break;
                sigBuilder.append(" extends ");
                sigBuilder.append(SignatureUtility.getTypeReference(signature.substring(1), signatureOwner, contextType, validator));
                break;
            }
            case 4: {
                arrayCount = Signature.getArrayCount((String)signature);
                sigBuilder.append(SignatureUtility.getTypeReference(signature.substring(arrayCount), signatureOwner, contextType, validator));
                break;
            }
            case 29: {
                isArbitraryArray = true;
                sigBuilder.append(SignatureUtility.getTypeReference(signature.substring(1), signatureOwner, contextType, validator));
                break;
            }
            case 2: {
                sigBuilder.append(Signature.getSignatureSimpleName((String)signature));
                break;
            }
            case 3: {
                String sig = SignatureUtility.findTypeParameterSignature(signature, signatureOwner, contextType);
                sigBuilder.append(SignatureUtility.getTypeReference(sig, signatureOwner, contextType, validator));
                break;
            }
            default: {
                String[] typeArguments = Signature.getTypeArguments((String)signature);
                signature = Signature.getTypeErasure((String)signature);
                signature = SIG_REPLACEMENT_REGEX.matcher(signature).replaceAll(".");
                if (SignatureUtility.startsWith(signature, 'Q')) {
                    if (signatureOwner != null) {
                        String[][] resolvedTypeName = signatureOwner.resolveType(Signature.getSignatureSimpleName((String)signature));
                        if (resolvedTypeName != null && resolvedTypeName.length == 1) {
                            String fqName = resolvedTypeName[0][0];
                            if (fqName != null && fqName.length() > 0) {
                                fqName = String.valueOf(fqName) + ".";
                            }
                            fqName = String.valueOf(fqName) + resolvedTypeName[0][1];
                            sigBuilder.append(validator.getTypeName(SignatureCache.createTypeSignature(fqName)));
                        }
                    } else {
                        sigBuilder.append(Signature.toString((String)signature));
                    }
                } else {
                    sigBuilder.append(validator.getTypeName(signature));
                }
                if (typeArguments == null || typeArguments.length <= 0) break;
                sigBuilder.append('<');
                int i = 0;
                while (i < typeArguments.length) {
                    if (i > 0) {
                        sigBuilder.append(", ");
                    }
                    sigBuilder.append(SignatureUtility.getTypeReference(typeArguments[i], signatureOwner, contextType, validator));
                    ++i;
                }
                sigBuilder.append('>');
            }
        }
        int i = 0;
        while (i < arrayCount) {
            sigBuilder.append("[]");
            ++i;
        }
        if (isArbitraryArray) {
            sigBuilder.append("...");
        }
        return sigBuilder.toString();
    }

    public static String[] getMethodParameterSignatureResolved(IMethod method) throws JavaModelException {
        return SignatureUtility.getMethodParameterSignatureResolved(method, method.getDeclaringType());
    }

    public static String[] getMethodParameterSignatureResolved(IMethod jdtMethod, IType contextType) throws JavaModelException {
        String[] methodParameterSignature = SignatureUtility.getMethodParameterSignature(jdtMethod);
        IType methodOwnerType = jdtMethod.getDeclaringType();
        int i = 0;
        while (i < methodParameterSignature.length) {
            methodParameterSignature[i] = SignatureUtility.getResolvedSignature(methodParameterSignature[i], methodOwnerType, contextType);
            ++i;
        }
        return methodParameterSignature;
    }

    public static String[] getMethodParameterSignature(IMethod method) throws JavaModelException {
        String[] paramNames = method.getParameterNames();
        String[] paramSignatures = Arrays.copyOf(method.getParameterTypes(), method.getParameterTypes().length);
        if (paramSignatures != null && paramSignatures.length > 0) {
            String regex;
            String source;
            String lastSig = paramSignatures[paramSignatures.length - 1];
            String lastParamName = paramNames[paramNames.length - 1];
            if (Signature.getTypeSignatureKind((String)lastSig) == 4 && (source = method.getSource()) != null && Pattern.compile(regex = String.valueOf(method.getElementName()) + "\\s*\\(.*([\\.]{3})\\s*" + lastParamName + "\\s*\\)", 8).matcher(source).find()) {
                paramSignatures[paramSignatures.length - 1] = lastSig.replaceFirst("^\\[", "|");
            }
        }
        return paramSignatures;
    }

    public static String getReturnTypeSignatureResolved(IMethod method, IType contextType) throws JavaModelException {
        String returnTypeSignature = method.getReturnType();
        IType methodDeclaringType = method.getDeclaringType();
        returnTypeSignature = SignatureUtility.getResolvedSignature(returnTypeSignature, methodDeclaringType, contextType);
        return returnTypeSignature;
    }

    public static String getMethodIdentifier(IMethod method) throws JavaModelException {
        StringBuilder methodIdBuilder = new StringBuilder(method.getElementName());
        methodIdBuilder.append("(");
        String[] resolvedParamSignatures = SignatureUtility.getMethodParameterSignatureResolved(method);
        int i = 0;
        while (i < resolvedParamSignatures.length) {
            methodIdBuilder.append(resolvedParamSignatures[i]);
            if (i + 1 < resolvedParamSignatures.length) {
                methodIdBuilder.append(",");
            }
            ++i;
        }
        methodIdBuilder.append(")");
        return methodIdBuilder.toString();
    }

    public static String getMethodIdentifier(IMethod method, IType contextType) throws JavaModelException {
        StringBuilder methodIdBuilder = new StringBuilder();
        methodIdBuilder.append(method.getElementName());
        methodIdBuilder.append("(");
        String[] resolvedParamSignatures = SignatureUtility.getMethodParameterSignatureResolved(method, contextType);
        int i = 0;
        while (i < resolvedParamSignatures.length) {
            methodIdBuilder.append(resolvedParamSignatures[i]);
            if (i + 1 < resolvedParamSignatures.length) {
                methodIdBuilder.append(",");
            }
            ++i;
        }
        methodIdBuilder.append(")");
        return methodIdBuilder.toString();
    }

    private static String findTypeParameterSignature(String typeParameterSignature, IType signatureOwner, IType contextType) throws JavaModelException {
        String paramTypeName = Signature.getSignatureSimpleName((String)typeParameterSignature);
        ArrayList<IType> hierarchyList = new ArrayList<IType>();
        if (contextType != null) {
            ITypeHierarchy superTypeHierarchy = contextType.newSupertypeHierarchy(null);
            IType visitorType = contextType;
            while (visitorType != null && !visitorType.equals(signatureOwner)) {
                hierarchyList.add(0, visitorType);
                visitorType = superTypeHierarchy.getSuperclass(visitorType);
            }
        }
        String[] ownerParameterSignatures = signatureOwner.getTypeParameterSignatures();
        int parameterIndex = -1;
        int i = 0;
        while (i < ownerParameterSignatures.length) {
            String paramSig = ownerParameterSignatures[i];
            String paramName = PARAM_SIG_REPLACEMENT_REGEX.matcher(paramSig).replaceAll("$1");
            paramSig = PARAM_SIG_REPLACEMENT_REGEX.matcher(paramSig).replaceAll("$2");
            if (contextType == null) {
                String signature = SignatureUtility.getResolvedSignature(paramSig, signatureOwner, contextType);
                return signature;
            }
            if (paramTypeName.equals(paramName)) {
                parameterIndex = i;
                break;
            }
            ++i;
        }
        if (parameterIndex < 0) {
            return SignatureCache.createTypeSignature(Object.class.getName());
        }
        Iterator iterator = hierarchyList.iterator();
        if (iterator.hasNext()) {
            IType hType = (IType)iterator.next();
            String superClassSignature = hType.getSuperclassTypeSignature();
            if (StringUtility.isNullOrEmpty((String)superClassSignature)) {
                return SignatureCache.createTypeSignature(Object.class.getName());
            }
            String[] superClassParameterSignatures = Signature.getTypeArguments((String)superClassSignature);
            if (superClassParameterSignatures.length < parameterIndex + 1) {
                return SignatureCache.createTypeSignature(Object.class.getName());
            }
            String signature = SignatureUtility.getResolvedSignature(superClassParameterSignatures[parameterIndex], hType, contextType);
            return signature;
        }
        return null;
    }

    public static boolean isGenericSignature(String sig) {
        String[] params = Signature.getTypeArguments((String)sig);
        return params != null && params.length > 0;
    }

    public static String getQuallifiedSignature(String signature, IType jdtType) throws JavaModelException {
        if (SignatureUtility.getTypeSignatureKind(signature) == 2) {
            return signature;
        }
        Matcher m = QUALIFIED_SIG_REGEX.matcher(signature);
        if (m.find()) {
            String[] typeArguments;
            String[][] resolvedTypeName;
            String prefix = m.group(1);
            String simpleSignature = m.group(2);
            String postfix = m.group(3);
            if (simpleSignature.startsWith("Q") && (resolvedTypeName = jdtType.resolveType(Signature.getSignatureSimpleName((String)(String.valueOf(simpleSignature) + ";")))) != null && resolvedTypeName.length == 1) {
                String fqName = resolvedTypeName[0][0];
                if (fqName != null && fqName.length() > 0) {
                    fqName = String.valueOf(fqName) + ".";
                }
                fqName = String.valueOf(fqName) + resolvedTypeName[0][1];
                simpleSignature = SignatureCache.createTypeSignature(fqName).replaceAll("(^.*)\\;$", "$1");
                signature = String.valueOf(prefix) + simpleSignature + postfix;
            }
            String[] stringArray = typeArguments = Signature.getTypeArguments((String)signature);
            int n = typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String typeArg = stringArray[n2];
                signature.replaceFirst("^([^<]*\\<.*)(" + SignatureUtility.quoteRegexSpecialCharacters(typeArg) + ")(.*)$", "$1" + SignatureUtility.getQuallifiedSignature(typeArg, jdtType) + "$3");
                ++n2;
            }
        } else {
            SdkUtilActivator.logWarning("could not quallify types of signature '" + signature + "'");
        }
        return signature;
    }
}

