/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;

public class UrlPatternDefaultCommand
extends AbstractExecutableMarkerCommand {
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private String m_defaultUrlPattern;

    public UrlPatternDefaultCommand(IScoutBundle bundle, SunJaxWsBean sunJaxWsBean, String servletAlias, String problem) {
        super(problem);
        this.m_bundle = bundle;
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.m_defaultUrlPattern = PathNormalizer.toUrlPattern(servletAlias, this.m_sunJaxWsBean.getAlias());
        this.setSolutionDescription("By using this task, the URL pattern is changed to '" + this.m_defaultUrlPattern + "'");
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        this.m_sunJaxWsBean.setUrlPattern(this.m_defaultUrlPattern);
        XmlResource sunJaxWsResource = ResourceFactory.getSunJaxWsResource(this.m_bundle);
        sunJaxWsResource.storeXmlAsync(this.m_sunJaxWsBean.getXml().getDocument(), 32, this.m_sunJaxWsBean.getAlias());
    }
}

