/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.Document;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.ScoutTypeNewOperation;
import org.eclipse.scout.sdk.operation.util.SourceFormatOperation;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class HandlerNewOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private String m_typeName;
    private String m_packageName;
    private boolean m_transactional;
    private IType m_sessionFactoryType;
    private IType m_superType;
    private IType m_createdType;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("bundle not set");
        }
        if (this.m_superType == null) {
            throw new IllegalArgumentException("superType not set");
        }
        if (this.m_typeName == null) {
            throw new IllegalArgumentException("typeName not set");
        }
        if (this.m_packageName == null) {
            throw new IllegalArgumentException("packageName not set");
        }
        if (this.m_transactional && this.m_sessionFactoryType == null) {
            throw new IllegalArgumentException("session factory must be set");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        ScoutTypeNewOperation opType = new ScoutTypeNewOperation(this.m_typeName, this.m_packageName, this.m_bundle);
        String superTypeSignature = this.m_superType.getFullyQualifiedName().equals(LogicalHandler.class.getName()) ? Signature.createTypeSignature((String)(String.valueOf(LogicalHandler.class.getName()) + "<" + LogicalMessageContext.class.getName() + ">"), (boolean)false) : (this.m_superType.getFullyQualifiedName().equals(SOAPHandler.class.getName()) ? Signature.createTypeSignature((String)(String.valueOf(SOAPHandler.class.getName()) + "<" + SOAPMessageContext.class.getName() + ">"), (boolean)false) : SignatureCache.createTypeSignature((String)this.m_superType.getFullyQualifiedName()));
        if (this.m_superType.isInterface()) {
            opType.addInterfaceSignature(superTypeSignature);
        } else {
            opType.setSuperTypeSignature(superTypeSignature);
        }
        opType.run(monitor, workingCopyManager);
        this.m_createdType = opType.getCreatedType();
        workingCopyManager.register(this.m_createdType.getCompilationUnit(), monitor);
        if (this.m_transactional) {
            AnnotationUpdateOperation opAnnotation = new AnnotationUpdateOperation();
            opAnnotation.setDeclaringType(this.m_createdType);
            opAnnotation.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutTransaction"));
            String defaultSessionFactory = (String)TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getMethod("sessionFactory", new String[0]).getDefaultValue().getValue();
            if (!this.isSameType(this.m_sessionFactoryType.getFullyQualifiedName(), defaultSessionFactory)) {
                opAnnotation.addTypeProperty("sessionFactory", this.m_sessionFactoryType);
            }
            opAnnotation.validate();
            opAnnotation.run(monitor, workingCopyManager);
        }
        JaxWsSdkUtility.overrideUnimplementedMethodsAsync(this.m_createdType);
        ICompilationUnit icu = this.m_createdType.getCompilationUnit();
        Document icuDoc = new Document(icu.getBuffer().getContents());
        SourceFormatOperation sourceFormatOp = new SourceFormatOperation(this.m_createdType.getJavaProject(), icuDoc, null);
        sourceFormatOp.run(monitor, workingCopyManager);
        icu.getBuffer().setContents(ScoutUtility.cleanLineSeparator((String)icuDoc.get(), (Document)icuDoc));
        workingCopyManager.reconcile(icu, monitor);
    }

    private IType createType(String qualifiedTypeName, IType interfaceType, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IType type;
        if (TypeUtility.existsType((String)qualifiedTypeName)) {
            type = TypeUtility.getType((String)qualifiedTypeName);
        } else {
            String typeName = Signature.getSimpleName((String)qualifiedTypeName);
            String packageName = Signature.getQualifier((String)qualifiedTypeName);
            ScoutTypeNewOperation newTypeOp = new ScoutTypeNewOperation(typeName, packageName, this.m_bundle);
            newTypeOp.addInterfaceSignature(SignatureCache.createTypeSignature((String)interfaceType.getFullyQualifiedName()));
            newTypeOp.run(monitor, workingCopyManager);
            type = newTypeOp.getCreatedType();
            workingCopyManager.register(type.getCompilationUnit(), monitor);
        }
        return type;
    }

    public String getOperationName() {
        return HandlerNewOperation.class.getName();
    }

    private boolean isSameType(String fullyQualifiedName1, String fullyQualifiedName2) {
        if (fullyQualifiedName1 != null) {
            fullyQualifiedName1 = fullyQualifiedName1.replaceAll("\\$", ".");
        }
        if (fullyQualifiedName2 != null) {
            fullyQualifiedName2 = fullyQualifiedName2.replaceAll("\\$", ".");
        }
        return CompareUtility.equals((Object)fullyQualifiedName1, (Object)fullyQualifiedName2);
    }

    public IType getCreatedType() {
        return this.m_createdType;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }

    public void setPackageName(String packageName) {
        this.m_packageName = packageName;
    }

    public void setTransactional(boolean transactional) {
        this.m_transactional = transactional;
    }

    public void setSessionFactoryType(IType sessionFactoryType) {
        this.m_sessionFactoryType = sessionFactoryType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }
}

