/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;

public class BuildJaxWsBean {
    public static final String XML_PROVIDER = "provider";
    public static final String XML_CONSUMER = "consumer";
    public static final String XML_ALIAS = "name";
    public static final String XML_PROPERTY = "property";
    public static final String XML_PROPERTY_NAME = "name";
    public static final String XML_PROPERTY_VALUE = "value";
    public static final String XML_WSDL = "wsdl";
    private ScoutXmlDocument.ScoutXmlElement m_xml;
    private WebserviceEnum m_webserviceEnum;

    public BuildJaxWsBean(ScoutXmlDocument.ScoutXmlElement xml, WebserviceEnum webserviceEnum) {
        this.m_xml = xml;
        this.m_webserviceEnum = webserviceEnum;
    }

    public ScoutXmlDocument.ScoutXmlElement getXml() {
        return this.m_xml;
    }

    public void setXml(ScoutXmlDocument.ScoutXmlElement xml) {
        this.m_xml = xml;
    }

    public String getAlias() {
        return this.m_xml.getAttribute("name", null);
    }

    public void setAlias(String alias) {
        this.m_xml.removeAttribute("name");
        this.m_xml.setAttribute("name", alias);
    }

    public void setWsdl(String wsdl) {
        this.m_xml.removeAttribute(XML_WSDL);
        this.m_xml.setAttribute(XML_WSDL, wsdl);
    }

    public String getWsdl() {
        return this.m_xml.getAttribute(XML_WSDL, null);
    }

    public Map<String, List<String>> getPropertiers() {
        HashMap<String, List<String>> properties = new HashMap<String, List<String>>();
        List children = this.m_xml.getChildren(XML_PROPERTY);
        for (ScoutXmlDocument.ScoutXmlElement xmlProperty : children) {
            String name = xmlProperty.getAttribute("name", null);
            if (StringUtility.isNullOrEmpty((String)name)) continue;
            String value = xmlProperty.getAttribute(XML_PROPERTY_VALUE, null);
            if (!properties.containsKey(name)) {
                properties.put(name, new LinkedList());
            }
            ((List)properties.get(name)).add(value);
        }
        return properties;
    }

    public void setProperties(Map<String, List<String>> properties) {
        this.m_xml.removeChildren(XML_PROPERTY);
        if (properties == null || properties.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<String>> property : properties.entrySet()) {
            String name = property.getKey();
            if (property.getValue() == null || property.getValue().size() == 0) {
                ScoutXmlDocument.ScoutXmlElement xmlProperty = this.m_xml.addChild(XML_PROPERTY);
                xmlProperty.setAttribute("name", property.getKey());
                continue;
            }
            for (String value : property.getValue()) {
                ScoutXmlDocument.ScoutXmlElement xmlProperty = this.m_xml.addChild(XML_PROPERTY);
                xmlProperty.setAttribute("name", name);
                xmlProperty.setAttribute(XML_PROPERTY_VALUE, value);
            }
        }
    }

    public boolean reload(IScoutBundle bundle) {
        ScoutXmlDocument newDocument = ResourceFactory.getBuildJaxWsResource(bundle).loadXml();
        if (newDocument == null || newDocument.getRoot() == null) {
            return false;
        }
        ScoutXmlDocument.ScoutXmlElement rootXml = newDocument.getRoot();
        if (rootXml == null) {
            return false;
        }
        String nodeName = this.m_webserviceEnum == WebserviceEnum.Provider ? XML_PROVIDER : XML_CONSUMER;
        ScoutXmlDocument.ScoutXmlElement xml = newDocument.getRoot().getChild(nodeName, "name", this.getAlias());
        if (xml == null) {
            return false;
        }
        this.setXml(xml);
        return true;
    }

    public static BuildJaxWsBean load(IScoutBundle bundle, String alias, WebserviceEnum webserviceEnum) {
        if (!StringUtility.hasText((String)alias)) {
            return null;
        }
        ScoutXmlDocument document = ResourceFactory.getBuildJaxWsResource(bundle).loadXml();
        if (document == null || document.getRoot() == null) {
            return null;
        }
        String nodeName = webserviceEnum == WebserviceEnum.Provider ? XML_PROVIDER : XML_CONSUMER;
        ScoutXmlDocument.ScoutXmlElement rootXml = document.getRoot();
        if (rootXml == null || !rootXml.hasChild(nodeName)) {
            return null;
        }
        ScoutXmlDocument.ScoutXmlElement xml = document.getRoot().getChild(nodeName, "name", alias);
        if (xml == null) {
            return null;
        }
        return new BuildJaxWsBean(xml, webserviceEnum);
    }
}

