/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.handler.Handler;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.HandlerNewWizardAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.HandlerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class HandlerTablePage
extends AbstractPage {
    private Map<IPrimaryTypeTypeHierarchy, IType> m_handlerHierarchyMap;
    private ITypeHierarchyChangedListener m_hierarchyChangedListener;

    public HandlerTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get("Handlers"));
        this.setImageDescriptor(JaxWsSdk.getImageDescriptor("handler_folder.png"));
        this.m_hierarchyChangedListener = new P_TypeHierarchyChangedListener();
        this.m_handlerHierarchyMap = new HashMap<IPrimaryTypeTypeHierarchy, IType>();
        IType[] iTypeArray = TypeUtility.getTypes((String)Handler.class.getName());
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IPrimaryTypeTypeHierarchy hierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)type);
            hierarchy.addHierarchyListener(this.m_hierarchyChangedListener);
            this.m_handlerHierarchyMap.put(hierarchy, type);
            ++n2;
        }
    }

    public String getPageId() {
        return IJaxWsPageConstants.HANDLER_TABLE_PAGE;
    }

    public void unloadPage() {
        if (this.m_hierarchyChangedListener != null) {
            for (IPrimaryTypeTypeHierarchy hierarchy : this.m_handlerHierarchyMap.keySet()) {
                hierarchy.removeHierarchyListener(this.m_hierarchyChangedListener);
            }
        }
    }

    public boolean isFolder() {
        return true;
    }

    public void refresh(boolean clearCache) {
        if (clearCache) {
            for (IPrimaryTypeTypeHierarchy hierarchy : this.m_handlerHierarchyMap.keySet()) {
                hierarchy.invalidate();
            }
        }
        super.refresh(clearCache);
    }

    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof HandlerNewWizardAction) {
            ((HandlerNewWizardAction)menu).init(this.getScoutBundle());
        }
    }

    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{HandlerNewWizardAction.class};
    }

    protected void loadChildrenImpl() {
        ArrayList<IType> types = new ArrayList<IType>();
        ITypeFilter filter = new ITypeFilter(){

            public boolean accept(IType candidate) {
                block5: {
                    block4: {
                        try {
                            if (TypeUtility.exists((IJavaElement)candidate)) break block4;
                            return false;
                        }
                        catch (JavaModelException e) {
                            JaxWsSdk.logError(e);
                            return false;
                        }
                    }
                    if (candidate.isClass() && !candidate.isInterface() && !Flags.isAbstract((int)candidate.getFlags())) break block5;
                    return false;
                }
                return TypeUtility.isOnClasspath((IJavaElement)candidate, (IJavaProject)HandlerTablePage.this.getScoutBundle().getJavaProject());
            }
        };
        for (Map.Entry<IPrimaryTypeTypeHierarchy, IType> entry : this.m_handlerHierarchyMap.entrySet()) {
            IPrimaryTypeTypeHierarchy hierarchy = entry.getKey();
            IType type = entry.getValue();
            types.addAll(Arrays.asList(hierarchy.getAllSubtypes(type, filter)));
        }
        JaxWsSdkUtility.sortTypesByName(types, true);
        for (IType handlerType : types) {
            if (Signature.getQualifier((String)handlerType.getFullyQualifiedName()).contains("internal") || JaxWsSdkUtility.isJdtSubType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler").getFullyQualifiedName(), handlerType) || JaxWsSdkUtility.isJdtSubType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler").getFullyQualifiedName(), handlerType)) continue;
            new HandlerNodePage((IPage)this, handlerType);
        }
    }

    private class P_TypeHierarchyChangedListener
    implements ITypeHierarchyChangedListener {
        private P_TypeHierarchyChangedListener() {
        }

        public void hierarchyInvalidated() {
            HandlerTablePage.this.markStructureDirty();
        }
    }
}

