/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.holders.IntegerHolder;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.ScoutSeverityManager;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.IMarkerRebuildListener;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerRebuildUtility;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.resource.IResourceListener;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageLoadedListener;

public class WebServiceProviderHandlerNodePage
extends AbstractPage
implements IMarkerRebuildListener {
    public static final int DATA_SUN_JAXWS_ENTRY = 1;
    private String m_markerGroupUUID;
    private IScoutBundle m_bundle;
    private String m_alias;
    private boolean m_pageUnloaded = false;
    private Object m_pageLoadedListenerLock;
    private SunJaxWsBean m_sunJaxWsBean;
    private IResourceListener m_sunJaxWsResourceListener;
    private Set<IPageLoadedListener> m_pageLoadedListeners;

    public WebServiceProviderHandlerNodePage(IPage parent, SunJaxWsBean sunJaxWsBean) {
        this.setParent(parent);
        this.setName(Texts.get("HandlerRegistration"));
        this.setImageDescriptor(JaxWsSdk.getImageDescriptor("handlers.png"));
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.m_alias = sunJaxWsBean.getAlias();
        this.m_bundle = this.getScoutBundle();
        this.m_markerGroupUUID = UUID.randomUUID().toString();
        this.m_pageLoadedListeners = new HashSet<IPageLoadedListener>();
        this.m_pageLoadedListenerLock = new Object();
        this.m_sunJaxWsResourceListener = new P_SunJaxWsResourceListener();
        ResourceFactory.getSunJaxWsResource(this.m_bundle).addResourceListener(this.getSunJaxWsBean().getAlias(), 512, this.m_sunJaxWsResourceListener);
        JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
    }

    public void reloadPage(int dataMask) {
        if ((dataMask & 1) > 0) {
            ScoutXmlDocument.ScoutXmlElement xmlRoot = this.getSunJaxWsResource().loadXml().getRoot();
            ScoutXmlDocument.ScoutXmlElement sunJaxWsXml = xmlRoot.getChild(StringUtility.join((String)":", (Object[])new Object[]{xmlRoot.getNamePrefix(), "endpoint"}), "name", this.m_alias);
            this.m_sunJaxWsBean = new SunJaxWsBean(sunJaxWsXml);
        }
        this.notifyPageLoadedListeners();
        JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
    }

    public String getPageId() {
        return IJaxWsPageConstants.PROVIDER_HANDLER_NODE_PAGE;
    }

    public boolean isFolder() {
        return false;
    }

    public void refresh(boolean clearCache) {
        if (clearCache) {
            super.refresh(clearCache);
        } else {
            JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
        }
    }

    public void unloadPage() {
        this.m_pageUnloaded = true;
        MarkerUtility.clearMarkers(this.m_bundle, this.m_markerGroupUUID);
        ResourceFactory.getSunJaxWsResource(this.m_bundle).removeResourceListener(this.m_sunJaxWsResourceListener);
        super.unloadPage();
    }

    public int getQuality() {
        final IntegerHolder qualityHolder = new IntegerHolder(Integer.valueOf(MarkerUtility.getQuality((IPage)this, this.m_bundle, this.m_markerGroupUUID)));
        if ((Integer)qualityHolder.getValue() >= 2) {
            return 2;
        }
        this.getSunJaxWsBean().visitHandlers(new SunJaxWsBean.IHandlerVisitor(){

            @Override
            public boolean visit(ScoutXmlDocument.ScoutXmlElement xmlHandlerElement, String fullyQualifiedName, int handlerIndex, int handlerCount) {
                IType type = TypeUtility.getType((String)fullyQualifiedName);
                if (TypeUtility.exists((IJavaElement)type)) {
                    qualityHolder.setValue((Object)Math.max((Integer)qualityHolder.getValue(), ScoutSeverityManager.getInstance().getSeverityOf((Object)type)));
                    if ((Integer)qualityHolder.getValue() >= 2) {
                        return false;
                    }
                }
                return true;
            }
        });
        return (Integer)qualityHolder.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildMarkers() {
        String string = this.m_markerGroupUUID;
        synchronized (string) {
            block8: {
                MarkerUtility.clearMarkers(this.m_bundle, this.m_markerGroupUUID);
                if (!this.isPageUnloaded()) break block8;
                HashSet<IFile> resources = new HashSet<IFile>();
                resources.add(ResourceFactory.getSunJaxWsResource(this.m_bundle).getFile());
                ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
                return;
            }
            try {
                try {
                    MarkerRebuildUtility.rebuildHandlerMarkers(this.getSunJaxWsBean(), this.m_bundle, this.m_markerGroupUUID);
                }
                catch (Exception e) {
                    JaxWsSdk.logWarning("failed to update markers", e);
                    HashSet<IFile> resources = new HashSet<IFile>();
                    resources.add(ResourceFactory.getSunJaxWsResource(this.m_bundle).getFile());
                    ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
                }
            }
            catch (Throwable throwable) {
                HashSet<IFile> resources = new HashSet<IFile>();
                resources.add(ResourceFactory.getSunJaxWsResource(this.m_bundle).getFile());
                ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
                throw throwable;
            }
            HashSet<IFile> resources = new HashSet<IFile>();
            resources.add(ResourceFactory.getSunJaxWsResource(this.m_bundle).getFile());
            ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
        }
    }

    public String getMarkerGroupUUID() {
        return this.m_markerGroupUUID;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public XmlResource getSunJaxWsResource() {
        return ResourceFactory.getSunJaxWsResource(this.m_bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPageLoadedListener(IPageLoadedListener listener) {
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            this.m_pageLoadedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePageLoadedListener(IPageLoadedListener listener) {
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            this.m_pageLoadedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPageLoadedListeners() {
        IPageLoadedListener[] listeners;
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            listeners = this.m_pageLoadedListeners.toArray(new IPageLoadedListener[this.m_pageLoadedListeners.size()]);
        }
        IPageLoadedListener[] iPageLoadedListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPageLoadedListener listener = iPageLoadedListenerArray[n2];
            try {
                listener.pageLoaded();
            }
            catch (Exception e) {
                JaxWsSdk.logError("error while notifying pageLoaded listener", e);
            }
            ++n2;
        }
    }

    public boolean isPageUnloaded() {
        return this.m_pageUnloaded;
    }

    private class P_SunJaxWsResourceListener
    implements IResourceListener {
        private P_SunJaxWsResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceProviderHandlerNodePage.this.reloadPage(1);
        }
    }
}

