/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import javax.wsdl.Definition;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.ScoutSeverityManager;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.marker.IMarkerRebuildListener;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerRebuildUtility;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.resource.IResourceListener;
import org.eclipse.scout.sdk.ws.jaxws.resource.ManagedResource;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.RefreshAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.StubRebuildAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.WsProviderDeleteAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderHandlerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderTablePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.AbstractTypeChangedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageLoadedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageReloadNotification;

public class WebServiceProviderNodePage
extends AbstractPage
implements IMarkerRebuildListener,
IPageReloadNotification {
    public static final int DATA_ENDPOINT_TYPE = 1;
    public static final int DATA_BUILD_JAXWS_ENTRY = 2;
    public static final int DATA_WSDL_FILE = 4;
    public static final int DATA_BINDING_FILE = 8;
    public static final int DATA_STUB_FILES = 16;
    public static final int DATA_SUN_JAXWS_ENTRY = 32;
    private boolean m_pageUnloaded = false;
    private String m_markerGroupUUID;
    private IScoutBundle m_bundle;
    private String m_alias;
    private Object m_pageLoadedListenerLock;
    private SunJaxWsBean m_sunJaxWsBean;
    private BuildJaxWsBean m_buildJaxWsBean;
    private IPrimaryTypeTypeHierarchy m_portTypeInterfaceTypeHierarchy;
    private IResourceListener m_sunJaxWsResourceListener;
    private IResourceListener m_buildJaxWsResourceListener;
    private IResourceListener m_wsdlResourceListener;
    private IResourceListener m_bindingFileResourceListener;
    private IResourceListener m_manifestResourceListener;
    private IResourceListener m_stubJarResourceListener;
    private P_PortTypeChangeListener m_portTypeChangedListener;
    private Set<IPageLoadedListener> m_pageLoadedListeners;
    private WsdlResource m_wsdlResource;
    private Definition m_wsdlDefinition;
    private XmlResource[] m_bindingFileResources;
    private ManagedResource m_manifestResource;
    private ManagedResource m_stubJarResource;

    public WebServiceProviderNodePage(IPage parent, String alias) {
        this.setParent(parent);
        this.setName(StringUtility.nvl((Object)alias, (String)"?"));
        this.setImageDescriptor(JaxWsSdk.getImageDescriptor("service_obj.gif"));
        this.m_alias = alias;
        this.m_bundle = this.getScoutBundle();
        this.m_markerGroupUUID = UUID.randomUUID().toString();
        this.m_wsdlResource = new WsdlResource(this.m_bundle);
        this.m_wsdlResourceListener = new P_WsdlResourceListener();
        this.m_manifestResource = new ManagedResource(this.m_bundle.getProject());
        this.m_manifestResource.setFile(new PluginModelHelper((IProject)this.m_bundle.getProject()).Manifest.getFile());
        this.m_manifestResourceListener = new P_ManifestResourceListener();
        this.m_stubJarResource = new ManagedResource(this.m_bundle.getProject());
        this.m_stubJarResourceListener = new P_StubJarResourceListener();
        this.m_sunJaxWsResourceListener = new P_SunJaxWsResourceListener();
        this.m_buildJaxWsResourceListener = new P_BuildJaxWsListener();
        this.m_bindingFileResources = new XmlResource[0];
        this.m_bindingFileResourceListener = new P_BindingFileResourceListener();
        this.m_pageLoadedListeners = new HashSet<IPageLoadedListener>();
        this.m_pageLoadedListenerLock = new Object();
        this.getSunJaxWsResource().addResourceListener(this.m_sunJaxWsResourceListener);
        this.getBuildJaxWsResource().addResourceListener(this.m_buildJaxWsResourceListener);
        this.getWsdlResource().addResourceListener(7, this.m_wsdlResourceListener);
        this.m_manifestResource.addResourceListener(3, this.m_manifestResourceListener);
        this.m_stubJarResource.addResourceListener(this.m_stubJarResourceListener);
        JaxWsSdk.getDefault().registerPage(WebServiceProviderNodePage.class, this);
        this.m_portTypeChangedListener = new P_PortTypeChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.m_portTypeChangedListener);
        this.reloadPage(63);
    }

    public String getPageId() {
        return IJaxWsPageConstants.PROVIDER_NODE_PAGE;
    }

    public boolean isFolder() {
        return false;
    }

    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof WsProviderDeleteAction) {
            ((WsProviderDeleteAction)menu).init(this.m_bundle, this.getSunJaxWsBean(), this.getBuildJaxWsBean());
        } else if (menu instanceof StubRebuildAction) {
            ((StubRebuildAction)menu).init(this.m_bundle, this.getBuildJaxWsBean(), this.getWsdlResource(), this.m_markerGroupUUID, WebserviceEnum.Provider);
        }
    }

    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        ArrayList<Class<StubRebuildAction>> actions = new ArrayList<Class<StubRebuildAction>>();
        actions.add(WsProviderDeleteAction.class);
        actions.add(RefreshAction.class);
        if (this.getBuildJaxWsBean() != null && this.getSunJaxWsBean() != null && !MarkerUtility.containsMarker(this.m_bundle, JaxWsConstants.MarkerType.StubFolder, this.getMarkerGroupUUID(), 2) && !MarkerUtility.containsMarker(this.m_bundle, JaxWsConstants.MarkerType.Wsdl, this.getMarkerGroupUUID(), 2)) {
            actions.add(StubRebuildAction.class);
        }
        return actions.toArray(new Class[actions.size()]);
    }

    @Override
    public void reloadPage(int dataMask) {
        if ((dataMask & 0x20) > 0) {
            SunJaxWsBean sunJaxWsBean = this.getSunJaxWsBean();
            if (sunJaxWsBean == null) {
                this.m_sunJaxWsBean = SunJaxWsBean.load(this.m_bundle, this.m_alias);
            } else if (!sunJaxWsBean.reload(this.m_bundle)) {
                this.m_sunJaxWsBean = null;
            }
        }
        if (this.m_sunJaxWsBean == null) {
            return;
        }
        if ((dataMask & 2) > 0) {
            BuildJaxWsBean buildJaxWsBean = this.getBuildJaxWsBean();
            if (buildJaxWsBean == null) {
                this.m_buildJaxWsBean = BuildJaxWsBean.load(this.m_bundle, this.m_alias, WebserviceEnum.Provider);
            } else if (!buildJaxWsBean.reload(this.m_bundle)) {
                this.m_buildJaxWsBean = null;
            }
        }
        if ((dataMask & 4) > 0) {
            this.m_wsdlDefinition = this.loadWsdlDefinition();
        }
        if ((dataMask & 8) > 0 || (dataMask & 2) > 0) {
            this.m_bindingFileResources = this.loadBindingFiles();
        }
        if ((dataMask & 0x10) > 0) {
            String wsdlFileName = null;
            if (this.m_sunJaxWsBean != null) {
                wsdlFileName = this.m_sunJaxWsBean.getWsdl();
            }
            this.m_stubJarResource.setFile(JaxWsSdkUtility.getStubJarFile(this.m_bundle, this.m_buildJaxWsBean, wsdlFileName));
        }
        this.notifyPageLoadedListeners();
        JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
    }

    public void refresh(boolean clearCache) {
        if (clearCache) {
            super.refresh(clearCache);
        } else {
            JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
        }
    }

    public void unloadPage() {
        this.m_pageUnloaded = true;
        MarkerUtility.clearMarkers(this.m_bundle, this.m_markerGroupUUID);
        this.getSunJaxWsResource().removeResourceListener(this.m_sunJaxWsResourceListener);
        this.getBuildJaxWsResource().removeResourceListener(this.m_buildJaxWsResourceListener);
        this.getWsdlResource().removeResourceListener(this.m_wsdlResourceListener);
        this.m_manifestResource.removeResourceListener(this.m_manifestResourceListener);
        this.m_stubJarResource.removeResourceListener(this.m_stubJarResourceListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.m_portTypeChangedListener);
        XmlResource[] xmlResourceArray = this.m_bindingFileResources;
        int n = this.m_bindingFileResources.length;
        int n2 = 0;
        while (n2 < n) {
            XmlResource resource = xmlResourceArray[n2];
            resource.removeResourceListener(this.m_bindingFileResourceListener);
            ++n2;
        }
        JaxWsSdk.getDefault().unregisterPage(WebServiceProviderNodePage.class, this);
        super.unloadPage();
    }

    public int getQuality() {
        int quality = MarkerUtility.getQuality((IPage)this, this.m_bundle, this.m_markerGroupUUID);
        if (quality == 2) {
            return quality;
        }
        IType portType = this.getPortType();
        if (portType != null) {
            quality = Math.max(quality, ScoutSeverityManager.getInstance().getSeverityOf((Object)portType));
        }
        return quality;
    }

    public boolean handleDoubleClickedDelegate() {
        if (this.getPortType() != null) {
            try {
                JavaUI.openInEditor((IJavaElement)this.getPortType());
            }
            catch (Exception e) {
                JaxWsSdk.logWarning("could not open type in editor", e);
            }
            return true;
        }
        return false;
    }

    protected void loadChildrenImpl() {
        new WebServiceProviderHandlerNodePage((IPage)this, this.getSunJaxWsBean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rebuildMarkers() {
        var1_1 = this.m_markerGroupUUID;
        synchronized (var1_1) {
            try {
                MarkerUtility.clearMarkers(this.m_bundle, this.m_markerGroupUUID);
                if (this.isPageUnloaded()) {
                }
                if (!MarkerRebuildUtility.rebuildBuildJaxWsMarkers(this.getBuildJaxWsResource().getFile(), this.m_buildJaxWsBean, this.m_alias, this.m_wsdlResource, this.m_markerGroupUUID, this.m_bundle, WebserviceEnum.Provider)) {
                }
                if (!MarkerRebuildUtility.rebuildSunJaxWsMarkers(this.getBuildJaxWsResource().getFile(), this.m_sunJaxWsBean, this.m_wsdlResource, this.m_markerGroupUUID, this.m_bundle)) {
                }
                portType = JaxWsSdkUtility.getPortType(this.getWsdlDefinition(), this.m_sunJaxWsBean.getServiceQNameSafe(), this.m_sunJaxWsBean.getPort());
                portTypeQName = null;
                if (portType != null) {
                    portTypeQName = portType.getQName();
                }
                if (!MarkerRebuildUtility.rebuildStubJarFileMarkers(this.m_buildJaxWsBean, this.m_wsdlResource, portTypeQName, this.m_sunJaxWsBean.getServiceQNameSafe(), this.m_bundle, this.m_markerGroupUUID)) {
                }
                if (!MarkerRebuildUtility.rebuildPortTypeImplMarkers(this.getSunJaxWsResource().getFile(), this.m_sunJaxWsBean, this.m_buildJaxWsBean, this.getPortType(), this.m_wsdlDefinition, this.m_markerGroupUUID, this.m_bundle)) {
                }
                if (!MarkerRebuildUtility.rebuildBindingFileMarkers(this.getBuildJaxWsResource().getFile(), this.m_bindingFileResources, this.m_wsdlResource, this.m_markerGroupUUID, this.m_bundle)) {
                }
                if (!MarkerRebuildUtility.rebuildWsdlMarkers(this.m_wsdlResource, this.m_buildJaxWsBean, this.m_sunJaxWsBean, this.m_markerGroupUUID, this.m_bundle)) {
                }
            }
            catch (Exception e) {
                JaxWsSdk.logWarning("failed to update markers", e);
            }
            finally {
                resources = new HashSet<Object>();
                if (JaxWsSdkUtility.exists((IResource)this.getSunJaxWsResource().getFile())) {
                    resources.add(this.getSunJaxWsResource().getFile());
                }
                if (JaxWsSdkUtility.exists((IResource)this.getBuildJaxWsResource().getFile())) {
                    resources.add(this.getBuildJaxWsResource().getFile());
                }
                if (JaxWsSdkUtility.exists((IResource)this.getWsdlResource().getFile())) {
                    resources.add(this.getWsdlResource().getFile());
                }
                var9_19 = this.m_bindingFileResources;
                var8_29 = this.m_bindingFileResources.length;
                var7_39 = 0;
                if (true) ** GOTO lbl50
            }
            do {
                if (JaxWsSdkUtility.exists((IResource)(resource = var9_19[var7_39]).getFile())) {
                    resources.add(resource.getFile());
                }
                ++var7_39;
lbl50:
                // 2 sources

            } while (var7_39 < var8_29);
            if (TypeUtility.exists((IJavaElement)this.getPortType())) {
                resources.add(this.getPortType().getResource());
            }
            ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
            return;
        }
    }

    private Definition loadWsdlDefinition() {
        IFile file = this.m_sunJaxWsBean == null || this.m_sunJaxWsBean.getWsdl() == null ? null : JaxWsSdkUtility.getFile(this.m_bundle, (IPath)new Path(this.m_sunJaxWsBean.getWsdl()), false);
        if (!this.getWsdlResource().isSameFile(file)) {
            this.getWsdlResource().setFile(file);
        }
        return this.getWsdlResource().loadWsdlDefinition();
    }

    private XmlResource[] loadBindingFiles() {
        XmlResource[] xmlResourceArray = this.m_bindingFileResources;
        int n = this.m_bindingFileResources.length;
        int n2 = 0;
        while (n2 < n) {
            XmlResource resource = xmlResourceArray[n2];
            resource.removeResourceListener(this.m_bindingFileResourceListener);
            ++n2;
        }
        LinkedList<XmlResource> bindingFileResources = new LinkedList<XmlResource>();
        if (this.m_buildJaxWsBean != null) {
            IFile[] bindingFiles;
            IFile[] iFileArray = bindingFiles = JaxWsSdkUtility.getBindingFiles(this.m_bundle, this.m_buildJaxWsBean.getPropertiers());
            int n3 = bindingFiles.length;
            int n4 = 0;
            while (n4 < n3) {
                IFile bindingFile = iFileArray[n4];
                XmlResource xmlResource = new XmlResource(this.m_bundle);
                xmlResource.setFile(bindingFile);
                xmlResource.addResourceListener(this.m_bindingFileResourceListener);
                bindingFileResources.add(xmlResource);
                ++n4;
            }
        }
        return bindingFileResources.toArray(new XmlResource[bindingFileResources.size()]);
    }

    public WebServiceProviderTablePage getParent() {
        return (WebServiceProviderTablePage)super.getParent();
    }

    @Override
    public String getMarkerGroupUUID() {
        return this.m_markerGroupUUID;
    }

    public IType getPortType() {
        IType portType = null;
        if (this.m_sunJaxWsBean != null) {
            portType = TypeUtility.getType((String)this.m_sunJaxWsBean.getImplementation());
        }
        if (this.m_portTypeChangedListener != null) {
            this.m_portTypeChangedListener.setType(portType);
        }
        return portType;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public Definition getWsdlDefinition() {
        if (this.m_wsdlDefinition == null) {
            this.m_wsdlDefinition = this.loadWsdlDefinition();
        }
        return this.m_wsdlDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPageLoadedListener(IPageLoadedListener listener) {
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            this.m_pageLoadedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePageLoadedListener(IPageLoadedListener listener) {
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            this.m_pageLoadedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPageLoadedListeners() {
        IPageLoadedListener[] listeners;
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            listeners = this.m_pageLoadedListeners.toArray(new IPageLoadedListener[this.m_pageLoadedListeners.size()]);
        }
        IPageLoadedListener[] iPageLoadedListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPageLoadedListener listener = iPageLoadedListenerArray[n2];
            try {
                listener.pageLoaded();
            }
            catch (Exception e) {
                JaxWsSdk.logError("error while notifying pageLoaded listener", e);
            }
            ++n2;
        }
    }

    public XmlResource getSunJaxWsResource() {
        return ResourceFactory.getSunJaxWsResource(this.m_bundle);
    }

    public XmlResource getBuildJaxWsResource() {
        return ResourceFactory.getBuildJaxWsResource(this.m_bundle);
    }

    public WsdlResource getWsdlResource() {
        return this.m_wsdlResource;
    }

    public XmlResource[] getBindingFileResources() {
        return this.m_bindingFileResources;
    }

    public boolean isPageUnloaded() {
        return this.m_pageUnloaded;
    }

    private class P_BindingFileResourceListener
    implements IResourceListener {
        private P_BindingFileResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceProviderNodePage.this.reloadPage(8);
        }
    }

    private class P_BuildJaxWsListener
    implements IResourceListener {
        private P_BuildJaxWsListener() {
        }

        @Override
        public void changed(String element, int event) {
            if (event == 8) {
                WebServiceProviderNodePage.this.reloadPage(2);
            } else {
                JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(WebServiceProviderNodePage.this);
            }
        }
    }

    private class P_ManifestResourceListener
    implements IResourceListener {
        private P_ManifestResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceProviderNodePage.this.reloadPage(16);
        }
    }

    private class P_PortTypeChangeListener
    extends AbstractTypeChangedListener {
        private P_PortTypeChangeListener() {
        }

        @Override
        protected boolean shouldAnalayseForChange(IResourceChangeEvent event) {
            return !WebServiceProviderNodePage.this.isPageUnloaded();
        }

        @Override
        protected void typeChanged() {
            WebServiceProviderNodePage.this.reloadPage(1);
        }
    }

    private class P_StubJarResourceListener
    implements IResourceListener {
        private P_StubJarResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceProviderNodePage.this.reloadPage(16);
        }
    }

    private class P_SunJaxWsResourceListener
    implements IResourceListener {
        private P_SunJaxWsResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            if (event == 512 || event == 32) {
                WebServiceProviderNodePage.this.reloadPage(32);
            } else if (event == 16 || event == 2 || event == 1) {
                WebServiceProviderNodePage.this.reloadPage(36);
            } else {
                JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(WebServiceProviderNodePage.this);
            }
        }
    }

    private class P_WsdlResourceListener
    implements IResourceListener {
        private P_WsdlResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceProviderNodePage.this.reloadPage(4);
        }
    }
}

