/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.part;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.util.IScoutSeverityListener;
import org.eclipse.scout.sdk.util.ScoutSeverityManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.FileOpenAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.HandlerAddAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.HandlerChainFilterEditAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.HandlerChainNewAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.HandlerChainRemoveAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderHandlerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.ActionPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.HandlerPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.TypePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.HandlerChainFilterWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageLoadedListener;
import org.eclipse.swt.layout.GridData;

public class WebServiceProviderHandlerNodePagePropertyViewPart
extends AbstractSinglePageSectionBasedViewPart {
    public static final int PRESENTER_ID_HANDLER = 2;
    public static final String SECTION_ID_LINKS = "section.jaxws.links";
    public static final String SECTION_ID_HANDLER_CHAIN_PREFIX = "section.jaxws.handlerchain.";
    private P_ScoutSeverityListener m_severityListener;
    private IPageLoadedListener m_pageLoadedListener;
    private List<TypePresenter> m_handlerPresenters;
    private Set<String> m_sectionsIdentifiers;
    private IScoutBundle m_bundle;

    protected void init() {
        this.m_bundle = this.getPage().getScoutBundle();
        this.m_sectionsIdentifiers = new HashSet<String>();
        this.m_handlerPresenters = new ArrayList<TypePresenter>();
        this.m_severityListener = new P_ScoutSeverityListener();
        ScoutSeverityManager.getInstance().addQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        this.m_pageLoadedListener = new P_PageLoadedListener();
        this.getPage().addPageLoadedListener(this.m_pageLoadedListener);
    }

    protected void cleanup() {
        ScoutSeverityManager.getInstance().removeQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        this.getPage().removePageLoadedListener(this.m_pageLoadedListener);
    }

    public WebServiceProviderHandlerNodePage getPage() {
        return (WebServiceProviderHandlerNodePage)super.getPage();
    }

    protected void createSections() {
        this.getForm().setRedraw(true);
        try {
            this.createSection(SECTION_ID_LINKS, Texts.get("ConsiderLinks"));
            FileOpenAction a = new FileOpenAction();
            a.init(ResourceFactory.getSunJaxWsResource(this.m_bundle).getFile(), ResourceFactory.getSunJaxWsResource(this.m_bundle).getFile().getName(), JaxWsSdk.getImageDescriptor("sunJaxWs.png"), FileOpenAction.FileExtensionType.Xml);
            a.setToolTip(Texts.get("JaxWsDeploymentDescriptor"));
            ActionPresenter actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), a, this.getFormToolkit());
            this.applyLayoutData(actionPresenter);
            if (this.getPage().getSunJaxWsBean() == null) {
                return;
            }
            HandlerChainNewAction action = new HandlerChainNewAction();
            action.init(this.m_bundle, this.getPage().getSunJaxWsBean());
            ActionPresenter presenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), action, this.getFormToolkit());
            presenter.setEnabled(this.getPage().getSunJaxWsBean() != null);
            GridData gd = new GridData(768);
            gd.horizontalAlignment = 131072;
            presenter.getContainer().setLayoutData((Object)gd);
            this.createHandlerChainSections(this.getPage().getSunJaxWsBean());
        }
        finally {
            this.getForm().setRedraw(true);
        }
    }

    private void applyLayoutData(AbstractPresenter presenter) {
        GridData layoutData = new GridData(768);
        presenter.getContainer().setLayoutData((Object)layoutData);
    }

    private void createHandlerChainSections(SunJaxWsBean sunJaxWsBean) {
        this.getForm().setRedraw(false);
        try {
            for (String sectionId : this.m_sectionsIdentifiers) {
                this.removeSection(sectionId);
            }
            this.m_sectionsIdentifiers.clear();
            if (this.getPage().getSunJaxWsBean() == null) {
                return;
            }
            List<ScoutXmlDocument.ScoutXmlElement> xmlHandlerChains = sunJaxWsBean.getHandlerChains();
            int i = 0;
            while (i < xmlHandlerChains.size()) {
                ScoutXmlDocument.ScoutXmlElement xmlHandlerChain = xmlHandlerChains.get(i);
                final String sectionId = SECTION_ID_HANDLER_CHAIN_PREFIX + Integer.toString(i);
                this.m_sectionsIdentifiers.add(sectionId);
                ISection section = this.createSection(sectionId, "", null, false);
                String handlerChainName = null;
                if (xmlHandlerChain.hasAttribute("name")) {
                    handlerChainName = xmlHandlerChain.getAttribute("name");
                }
                if (StringUtility.hasText(handlerChainName)) {
                    section.setText(Texts.get("HandlerChainX", handlerChainName));
                } else {
                    section.setText(Texts.get("HandlerChain"));
                }
                HandlerChainFilterEditAction filterAction = new HandlerChainFilterEditAction();
                HandlerChainFilterWizardPage.FilterTypeEnum filterType = this.getFilterType(sunJaxWsBean, xmlHandlerChain);
                if (filterType != HandlerChainFilterWizardPage.FilterTypeEnum.NoFilter) {
                    filterAction.setLinkText(Texts.get("EditFilterXActive", filterType.getLabel()));
                }
                filterAction.init(this.m_bundle, this.getPage().getSunJaxWsBean(), xmlHandlerChain);
                ActionPresenter presenter = new ActionPresenter(section.getSectionClient(), filterAction, this.getFormToolkit());
                GridData gd = new GridData(768);
                gd.horizontalAlignment = 131072;
                presenter.getContainer().setLayoutData((Object)gd);
                HandlerChainRemoveAction removeChainAction = new HandlerChainRemoveAction();
                removeChainAction.init(this.m_bundle, this.getPage().getSunJaxWsBean(), xmlHandlerChain);
                presenter = new ActionPresenter(section.getSectionClient(), removeChainAction, this.getFormToolkit());
                gd = new GridData(768);
                gd.horizontalAlignment = 131072;
                presenter.getContainer().setLayoutData((Object)gd);
                HandlerAddAction newHandlerAction = new HandlerAddAction();
                newHandlerAction.init(this.m_bundle, this.getPage().getSunJaxWsBean(), xmlHandlerChain);
                presenter = new ActionPresenter(section.getSectionClient(), newHandlerAction, this.getFormToolkit());
                gd = new GridData(768);
                gd.verticalIndent = 20;
                gd.horizontalAlignment = 131072;
                presenter.getContainer().setLayoutData((Object)gd);
                sunJaxWsBean.visitHandlers(xmlHandlerChain, new SunJaxWsBean.IHandlerVisitor(){

                    @Override
                    public boolean visit(ScoutXmlDocument.ScoutXmlElement xmlHandlerElement, String fullyQualifiedName, int handlerIndex, int handlerCount) {
                        String handlerClassElementName = WebServiceProviderHandlerNodePagePropertyViewPart.this.getPage().getSunJaxWsBean().toQualifiedName("handler-class");
                        ScoutXmlDocument.ScoutXmlElement xmlHandlerClassElement = xmlHandlerElement.getChild(handlerClassElementName);
                        String handlerClass = null;
                        if (xmlHandlerClassElement != null) {
                            handlerClass = xmlHandlerClassElement.getText();
                        }
                        HandlerPresenter p = new HandlerPresenter(WebServiceProviderHandlerNodePagePropertyViewPart.this.m_bundle, WebServiceProviderHandlerNodePagePropertyViewPart.this.getSection(sectionId).getSectionClient(), handlerIndex, handlerCount, WebServiceProviderHandlerNodePagePropertyViewPart.this.getFormToolkit());
                        p.setPresenterId(2 + new Random().nextInt());
                        p.setMarkerGroupUUID(JaxWsSdkUtility.toMarkerGroupUUID(WebServiceProviderHandlerNodePagePropertyViewPart.this.getPage().getMarkerGroupUUID(), handlerIndex));
                        p.setXmlHandlerElement(xmlHandlerElement);
                        p.setSunJaxWsBean(WebServiceProviderHandlerNodePagePropertyViewPart.this.getPage().getSunJaxWsBean());
                        p.setInput(handlerClass);
                        WebServiceProviderHandlerNodePagePropertyViewPart.this.m_handlerPresenters.add(p);
                        WebServiceProviderHandlerNodePagePropertyViewPart.this.applyLayoutData(p);
                        return true;
                    }
                });
                JaxWsSdkUtility.doLayoutSection(section);
                ++i;
            }
        }
        finally {
            this.getForm().setRedraw(true);
        }
    }

    private HandlerChainFilterWizardPage.FilterTypeEnum getFilterType(SunJaxWsBean sunJaxWsBean, ScoutXmlDocument.ScoutXmlElement xmlHandlerChain) {
        if (xmlHandlerChain.hasChild(sunJaxWsBean.toQualifiedName("protocol-bindings"))) {
            return HandlerChainFilterWizardPage.FilterTypeEnum.ProtocolFilter;
        }
        if (xmlHandlerChain.hasChild(sunJaxWsBean.toQualifiedName("service-name-pattern"))) {
            return HandlerChainFilterWizardPage.FilterTypeEnum.ServiceFilter;
        }
        if (xmlHandlerChain.hasChild(sunJaxWsBean.toQualifiedName("port-name-pattern"))) {
            return HandlerChainFilterWizardPage.FilterTypeEnum.PortFilter;
        }
        return HandlerChainFilterWizardPage.FilterTypeEnum.NoFilter;
    }

    private class P_PageLoadedListener
    implements IPageLoadedListener {
        private P_PageLoadedListener() {
        }

        @Override
        public void pageLoaded() {
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WebServiceProviderHandlerNodePagePropertyViewPart.this.getPage().isPageUnloaded() || WebServiceProviderHandlerNodePagePropertyViewPart.this.getForm().isDisposed()) {
                        return;
                    }
                    WebServiceProviderHandlerNodePagePropertyViewPart.this.createHandlerChainSections(WebServiceProviderHandlerNodePagePropertyViewPart.this.getPage().getSunJaxWsBean());
                }
            });
        }
    }

    private class P_ScoutSeverityListener
    implements IScoutSeverityListener {
        private P_ScoutSeverityListener() {
        }

        public void severityChanged(IResource resource) {
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WebServiceProviderHandlerNodePagePropertyViewPart.this.getPage().isPageUnloaded() || WebServiceProviderHandlerNodePagePropertyViewPart.this.getForm().isDisposed()) {
                        return;
                    }
                    for (TypePresenter presenter : WebServiceProviderHandlerNodePagePropertyViewPart.this.m_handlerPresenters) {
                        presenter.updateInfo();
                    }
                }
            });
        }
    }
}

