/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.util.EclipseFileHandle;
import org.eclipse.scout.sdk.ws.jaxws.util.IFileHandle;
import org.eclipse.scout.sdk.ws.jaxws.util.ISchemaArtefactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.JavaFileHandle;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public final class SchemaUtility {
    private SchemaUtility() {
    }

    public static void visitArtefacts(IFile wsdlFile, ISchemaArtefactVisitor<IFile> visitor) {
        SchemaUtility.visit(visitor, new EclipseFileHandle((IResource)wsdlFile));
    }

    public static void visitArtefacts(File wsdlFile, ISchemaArtefactVisitor<File> visitor) {
        SchemaUtility.visit(visitor, new JavaFileHandle(wsdlFile));
    }

    private static <T> void visit(ISchemaArtefactVisitor<T> visitor, IFileHandle<T> wsdlFileHandle) {
        if (wsdlFileHandle == null || !wsdlFileHandle.exists()) {
            return;
        }
        Definition wsdlDefinition = JaxWsSdkUtility.loadWsdlDefinition(wsdlFileHandle);
        if (wsdlDefinition == null) {
            return;
        }
        WsdlArtefact<T> rootWsdlArtefact = new WsdlArtefact<T>(wsdlFileHandle, WsdlArtefact.TypeEnum.RootWsdl, wsdlDefinition);
        visitor.onRootWsdlArtefact(rootWsdlArtefact);
        HashSet<WsdlArtefact<T>> wsdlArtefacts = new HashSet<WsdlArtefact<T>>();
        wsdlArtefacts.add(rootWsdlArtefact);
        Set<WsdlArtefact<T>> referencedWsdlArtefacts = SchemaUtility.getReferencedWsdlResourcesRec(wsdlFileHandle, wsdlDefinition);
        wsdlArtefacts.addAll(referencedWsdlArtefacts);
        for (WsdlArtefact<T> wsdlArtefact : referencedWsdlArtefacts) {
            visitor.onReferencedWsdlArtefact(wsdlArtefact);
        }
        for (WsdlArtefact<Object> wsdlArtefact : wsdlArtefacts) {
            if (wsdlArtefact.getWsdlDefinition() == null) {
                JaxWsSdk.logWarning("Unexpected: WSDL definition should not be null '" + wsdlArtefact + "'");
                continue;
            }
            Types types = wsdlArtefact.getWsdlDefinition().getTypes();
            if (types == null) continue;
            HashSet<Schema> inlineSchemas = new HashSet<Schema>();
            for (Object type : types.getExtensibilityElements()) {
                if (!(type instanceof Schema)) continue;
                Schema schema = (Schema)type;
                inlineSchemas.add(schema);
                SchemaUtility.visitReferencedSchemaResources(visitor, wsdlArtefact.getFileHandle(), schema);
            }
            wsdlArtefact.setInlineSchemas(inlineSchemas.toArray(new Schema[inlineSchemas.size()]));
        }
    }

    public static String getSchemaTargetNamespace(Schema schema) {
        if (schema == null) {
            return null;
        }
        if (schema.getElement().hasAttribute("targetNamespace")) {
            return schema.getElement().getAttribute("targetNamespace");
        }
        return null;
    }

    private static <T> Set<WsdlArtefact<T>> getReferencedWsdlResourcesRec(IFileHandle<T> parentWsdlFileHandle, Definition parentWsdlDefinition) {
        if (parentWsdlFileHandle == null || !parentWsdlFileHandle.exists()) {
            return Collections.emptySet();
        }
        IFileHandle<T> folder = parentWsdlFileHandle.getParent();
        HashSet<WsdlArtefact<T>> wsdlArtefacts = new HashSet<WsdlArtefact<T>>();
        Map importMap = parentWsdlDefinition.getImports();
        for (Object importValue : importMap.values()) {
            if (!(importValue instanceof List)) continue;
            List importList = (List)importValue;
            for (Object importObject : importList) {
                if (!(importObject instanceof Import)) continue;
                Import importDirective = (Import)importObject;
                Definition wsdlDefinition = importDirective.getDefinition();
                IFileHandle<T> wsdlFileHandle = folder.getChild((IPath)new Path(importDirective.getLocationURI()));
                if (wsdlFileHandle == null) continue;
                wsdlArtefacts.add(new WsdlArtefact<T>(wsdlFileHandle, WsdlArtefact.TypeEnum.ReferencedWsdl, wsdlDefinition));
                wsdlArtefacts.addAll(SchemaUtility.getReferencedWsdlResourcesRec(wsdlFileHandle, wsdlDefinition));
            }
        }
        return wsdlArtefacts;
    }

    private static <T> void visitReferencedSchemaResources(ISchemaArtefactVisitor<T> visitor, IFileHandle<T> fileHandle, Schema schema) {
        Map importMap;
        if (fileHandle == null || !fileHandle.exists() || schema == null) {
            return;
        }
        IFileHandle<T> parentResouce = fileHandle.getParent();
        List includes = schema.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            for (Object include : includes) {
                IFileHandle<T> referencedSchemaResource;
                SchemaReference schemaInclude;
                String schemaLocationURI;
                if (!(include instanceof SchemaReference) || !StringUtility.hasText((String)(schemaLocationURI = (schemaInclude = (SchemaReference)include).getSchemaLocationURI())) || (referencedSchemaResource = parentResouce.getChild((IPath)new Path(schemaLocationURI))) == null) continue;
                Schema referencedSchema = schemaInclude.getReferencedSchema();
                SchemaIncludeArtefact<T> artefact = new SchemaIncludeArtefact<T>(referencedSchemaResource, referencedSchema);
                visitor.onSchemaIncludeArtefact(artefact);
                SchemaUtility.visitReferencedSchemaResources(visitor, referencedSchemaResource, referencedSchema);
            }
        }
        if ((importMap = schema.getImports()) != null && !importMap.isEmpty()) {
            for (Object importObject : importMap.values()) {
                if (!(importObject instanceof List)) continue;
                for (Object importDirective : (List)importObject) {
                    IFileHandle<T> referencedSchemaResource;
                    SchemaImport schemaImport;
                    String schemaLocationURI;
                    if (!(importDirective instanceof SchemaImport) || !StringUtility.hasText((String)(schemaLocationURI = (schemaImport = (SchemaImport)importDirective).getSchemaLocationURI())) || (referencedSchemaResource = parentResouce.getChild((IPath)new Path(schemaLocationURI))) == null) continue;
                    Schema referencedSchema = schemaImport.getReferencedSchema();
                    SchemaImportArtefact<T> artefact = new SchemaImportArtefact<T>(referencedSchemaResource, referencedSchema, schemaImport.getNamespaceURI());
                    visitor.onSchemaImportArtefact(artefact);
                    SchemaUtility.visitReferencedSchemaResources(visitor, referencedSchemaResource, referencedSchema);
                }
            }
        }
    }

    public static abstract class Artefact<T> {
        private IFileHandle<T> m_fileHandle;

        public Artefact(IFileHandle<T> fileHandle) {
            this.m_fileHandle = fileHandle;
        }

        public IFileHandle<T> getFileHandle() {
            return this.m_fileHandle;
        }

        public void setFileHandle(IFileHandle<T> resource) {
            this.m_fileHandle = resource;
        }

        public int hashCode() {
            return this.m_fileHandle.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.m_fileHandle.equals(((Artefact)obj).m_fileHandle);
        }
    }

    public static abstract class SchemaArtefact<T>
    extends Artefact<T> {
        private Schema m_schema;

        public SchemaArtefact(IFileHandle<T> schemaResource, Schema schema) {
            super(schemaResource);
            this.m_schema = schema;
        }

        public Schema getSchema() {
            return this.m_schema;
        }

        public void setSchema(Schema schema) {
            this.m_schema = schema;
        }
    }

    public static class SchemaImportArtefact<T>
    extends SchemaArtefact<T> {
        private String m_namespaceUri;

        public SchemaImportArtefact(IFileHandle<T> schemaFileHandle, Schema schema, String namespaceUri) {
            super(schemaFileHandle, schema);
            this.m_namespaceUri = namespaceUri;
        }

        public String getNamespaceUri() {
            return this.m_namespaceUri;
        }

        public void setNamespaceUri(String namespaceUri) {
            this.m_namespaceUri = namespaceUri;
        }
    }

    public static class SchemaIncludeArtefact<T>
    extends SchemaArtefact<T> {
        public SchemaIncludeArtefact(IFileHandle<T> schemaFileHandle, Schema schema) {
            super(schemaFileHandle, schema);
        }
    }

    public static class WsdlArtefact<T>
    extends Artefact<T> {
        private TypeEnum m_typeEnum;
        private Definition m_wsdlDefintion;
        private Schema[] m_inlineSchemas = new Schema[0];

        public WsdlArtefact(IFileHandle<T> wsdlFileHandle, TypeEnum typeEnum, Definition wsdlDefintion) {
            super(wsdlFileHandle);
            this.m_typeEnum = typeEnum;
            this.m_wsdlDefintion = wsdlDefintion;
        }

        public TypeEnum getTypeEnum() {
            return this.m_typeEnum;
        }

        public void setTypeEnum(TypeEnum typeEnum) {
            this.m_typeEnum = typeEnum;
        }

        public Definition getWsdlDefinition() {
            return this.m_wsdlDefintion;
        }

        public void setWsdlDefintion(Definition wsdlDefintion) {
            this.m_wsdlDefintion = wsdlDefintion;
        }

        public Schema[] getInlineSchemas() {
            if (this.m_inlineSchemas == null) {
                return new Schema[0];
            }
            return this.m_inlineSchemas;
        }

        public void setInlineSchemas(Schema[] inlineSchemas) {
            this.m_inlineSchemas = inlineSchemas;
        }

        public static enum TypeEnum {
            RootWsdl,
            ReferencedWsdl;

        }
    }
}

