/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.validator;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;
import org.eclipse.scout.sdk.ws.jaxws.validator.IUrlPatternValidation;

public final class UrlPatternValidator {
    private UrlPatternValidator() {
    }

    public static boolean validate(String urlPattern, String servletAlias, IUrlPatternValidation validation) {
        if (!StringUtility.hasText((String)urlPattern) || new Path(urlPattern).makeRelative().isEmpty()) {
            validation.onEmpty();
            return false;
        }
        if (!urlPattern.matches("[\\w\\-/]*")) {
            validation.onIllegalCharacters();
            return false;
        }
        if (StringUtility.hasText((String)servletAlias)) {
            if (!urlPattern.startsWith(PathNormalizer.toServletAlias(servletAlias))) {
                validation.onNotStartingWithServletAlias();
                return false;
            }
            if (new Path(urlPattern).makeRelativeTo((IPath)new Path(PathNormalizer.toServletAlias(servletAlias))).isEmpty()) {
                validation.onEmpty();
                return false;
            }
        }
        if (!urlPattern.equals(PathNormalizer.toUrlPattern(urlPattern))) {
            validation.onWrongSeparators();
            return false;
        }
        return true;
    }
}

