/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.svg.ui.rap;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.browser.BrowserExtension;
import org.eclipse.scout.rt.ui.rap.ext.browser.IHyperlinkCallback;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public abstract class AbstractRwtScoutSvgComposite<T extends IFormField>
extends RwtScoutFieldComposite<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractRwtScoutSvgComposite.class);
    protected static final int SVG_ELEMENT_INNER_SPACE = 7;
    private static final String DOCUMENT_ENCODING = "UTF-8";
    private BrowserExtension m_browserExtension;

    private void setBrowserExtension(BrowserExtension browserExtension) {
        this.m_browserExtension = browserExtension;
    }

    protected BrowserExtension getBrowserExtension() {
        return this.m_browserExtension;
    }

    protected void initializeUi(Composite parent) {
        super.initializeUi(parent);
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        this.setUiContainer(container);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.setUiLabel((ILabelComposite)label);
        Browser browser = this.getUiEnvironment().getFormToolkit().createBrowser(container, 16);
        this.setUiField((Control)browser);
        browser.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                AbstractRwtScoutSvgComposite.this.getBrowserExtension().detach();
            }
        });
        browser.addControlListener(new ControlListener(){
            private static final long serialVersionUID = 1L;

            public void controlResized(ControlEvent e) {
                AbstractRwtScoutSvgComposite.this.updateSvgDocument();
            }

            public void controlMoved(ControlEvent e) {
                AbstractRwtScoutSvgComposite.this.updateSvgDocument();
            }
        });
        this.setBrowserExtension(new BrowserExtension(browser, new IHyperlinkCallback(){

            public void execute(String url) {
                AbstractRwtScoutSvgComposite.this.hyperlinkActivatedFromUi(url);
            }
        }));
        this.getBrowserExtension().attach();
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    protected static String getSvgContentFromDocument(SVGDocument doc) throws ProcessingException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DOMSource domSource = new DOMSource((Node)doc.getRootElement());
            StreamResult streamResult = new StreamResult(out);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("encoding", DOCUMENT_ENCODING);
            t.transform(domSource, streamResult);
            out.close();
            return new String(out.toByteArray(), DOCUMENT_ENCODING);
        }
        catch (Exception e) {
            throw new ProcessingException("Writing SVG Failed", (Throwable)e);
        }
    }

    protected void updateSvgDocument() {
        this.getBrowserExtension().clearLocalHyperlinkCache();
        this.getBrowserExtension().clearResourceCache();
        SVGDocument doc = this.getSvgDocument();
        if (doc == null) {
            this.getUiField().setText("");
            return;
        }
        try {
            Rectangle browserBounds = this.getAbsoluteBrowserBounds();
            doc.getRootElement().setAttribute("height", String.valueOf(browserBounds.height) + "px");
            doc.getRootElement().setAttribute("width", String.valueOf(browserBounds.width) + "px");
            String svgText = this.getBrowserExtension().adaptLocalHyperlinks(AbstractRwtScoutSvgComposite.getSvgContentFromDocument(doc));
            String contextMenuHideScript = "parent.parent.org.eclipse.rwt.MenuManager.getInstance().update(null, 'mousedown');";
            String backgroundColorInheritScript = null;
            backgroundColorInheritScript = ((IFormField)this.getScoutObject()).getBackgroundColor() == null ? "var iframes = parent.document.getElementsByTagName('iframe');for(var i=0;i<iframes.length;i++) {  var field=iframes[i].parentNode;  var color=field.style.backgroundColor;  if(color && color.toLowerCase() === 'rgb(255, 255, 255)')     field.style.backgroundColor='';}" : "";
            this.getUiField().setText("<html><body width=\"100%\" height=\"100%\" onload=\"" + backgroundColorInheritScript + "\" onclick=\"" + contextMenuHideScript + "\">" + svgText + "</body></html>");
        }
        catch (Exception e) {
            LOG.error("preparing svg browser content", (Throwable)e);
            this.getUiField().setText("");
        }
    }

    protected Rectangle getAbsoluteBrowserBounds() {
        Point pt = this.getUiField().getDisplay().map((Control)this.getUiField(), null, new Point(0, 0));
        return new Rectangle(pt.x, pt.y, this.getUiField().getBounds().width - 7, this.getUiField().getBounds().height);
    }

    public Browser getUiField() {
        return (Browser)super.getUiField();
    }

    protected abstract SVGDocument getSvgDocument();

    protected abstract void hyperlinkActivatedFromUi(String var1);

    protected void setEnabledFromScout(boolean b) {
    }
}

