/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.utils;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaResourcesFilter {
    public static Set<IContainer> getBinaryContainers(IProject project) {
        HashSet<IContainer> binaryContainers = new HashSet<IContainer>();
        if (project != null && project.isAccessible()) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IFolder folder;
                    IJavaProject jp = JavaCore.create((IProject)project);
                    IPath outputPath = jp.getOutputLocation();
                    if (outputPath != null && (folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath)).exists()) {
                        binaryContainers.add((IContainer)folder);
                    }
                    IClasspathEntry[] iClasspathEntryArray = jp.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFolder folder2;
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 3 && (outputPath = entry.getOutputLocation()) != null && (folder2 = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath)).exists()) {
                            binaryContainers.add((IContainer)folder2);
                        }
                        ++n2;
                    }
                } else {
                    binaryContainers.addAll(ResourceUtils.getContainerChildren((IContainer)project));
                    binaryContainers.add((IContainer)project);
                }
            }
            catch (JavaModelException e) {
                ScaCoreCommonPlugin.log((Exception)((Object)e), 4);
            }
            catch (CoreException e) {
                ScaCoreCommonPlugin.log((Exception)((Object)e), 4);
            }
        }
        return binaryContainers;
    }

    public static Set<IContainer> getSourceContainers(IProject project) {
        HashSet<IContainer> sourceFolders = new HashSet<IContainer>();
        if (project != null && project.isAccessible()) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject jp = JavaCore.create((IProject)project);
                    IClasspathEntry[] iClasspathEntryArray = jp.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 3) {
                            IPath srcPath = entry.getPath();
                            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(srcPath);
                            if (folder.exists()) {
                                sourceFolders.add((IContainer)folder);
                            }
                        }
                        ++n2;
                    }
                } else {
                    sourceFolders.addAll(ResourceUtils.getContainerChildren((IContainer)project));
                    sourceFolders.add((IContainer)project);
                }
            }
            catch (JavaModelException e) {
                ScaCoreCommonPlugin.log((Exception)((Object)e), 4);
            }
            catch (CoreException e) {
                ScaCoreCommonPlugin.log((Exception)((Object)e), 4);
            }
        }
        return sourceFolders;
    }
}

