/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_1.common.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.soa.sca.core.common.internal.provisional.utils.IScaSignature;
import org.eclipse.soa.sca.core.common.internal.provisional.utils.ScaCompositeBuildOrderHelper;
import org.eclipse.soa.sca.core.common.internal.provisional.utils.ScaValidationEntryBean;
import org.eclipse.soa.sca.core.common.utils.JDTUtils;
import org.eclipse.soa.sca.sca1_1.common.Messages;
import org.eclipse.soa.sca.sca1_1.common.Sca1_1CommonPlugin;
import org.eclipse.soa.sca.sca1_1.common.builder.ScaBuilderUtils;
import org.eclipse.soa.sca.sca1_1.common.utils.ScaSignature;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaImplementation;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.soa.sca.sca1_1.model.sca.Wire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaJavaBuildHelper
implements ScaCompositeBuildOrderHelper<Composite> {
    private IFile scaFile;
    private IJavaProject javaProject;
    private Map<String, JavaToCompositeElement> classNameToJavaElt;
    private Map<Component, String> componentNameToJavaImpl;
    private List<JavaCompatibilityElement> promotes;
    private List<JavaCompatibilityElement> impls;
    private List<JavaCompatibilityElement> wires;

    public boolean initialize(Composite composite, IFile scaFile) {
        boolean initialized = false;
        this.scaFile = scaFile;
        try {
            if (scaFile.getProject().isAccessible() && scaFile.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                this.javaProject = JDTUtils.getJavaProject((IProject)scaFile.getProject());
                this.classNameToJavaElt = new HashMap<String, JavaToCompositeElement>();
                this.componentNameToJavaImpl = new HashMap<Component, String>();
                this.impls = new ArrayList<JavaCompatibilityElement>();
                this.wires = new ArrayList<JavaCompatibilityElement>();
                this.promotes = new ArrayList<JavaCompatibilityElement>();
                this.buildJavaRelations(composite, this.javaProject);
                initialized = true;
            }
        }
        catch (CoreException e) {
            Sca1_1CommonPlugin.log((Exception)((Object)e), 2);
        }
        return initialized;
    }

    private void buildJavaRelations(Composite c, IJavaProject javaProject) {
        JavaToCompositeElement jtc;
        for (Service s : c.getService()) {
            if (s.getInterface() == null || !(s.getInterface() instanceof JavaInterface)) continue;
            jtc = new JavaToCompositeElement();
            jtc._class = ((JavaInterface)s.getInterface()).getInterface();
            jtc.eobject = s.getInterface();
            this.classNameToJavaElt.put(jtc._class, jtc);
            if (s.getPromote() == null || s.getPromote().getInterface() == null || !(s.getPromote().getInterface() instanceof JavaInterface)) continue;
            JavaCompatibilityElement jce = new JavaCompatibilityElement();
            jce._superClass.add(jtc._class);
            jce._class = ((JavaInterface)s.getPromote().getInterface()).getInterface();
            this.promotes.add(jce);
        }
        for (Wire w : c.getWire()) {
            JavaCompatibilityElement jce = new JavaCompatibilityElement();
            if (w.getSource2() != null && w.getSource2().getInterface() != null && w.getSource2().getInterface() instanceof JavaInterface) {
                jce._superClass.add(((JavaInterface)w.getSource2().getInterface()).getInterface());
            }
            if (w.getTarget2() != null && w.getTarget2().getInterface() != null && w.getTarget2().getInterface() instanceof JavaInterface) {
                jce._class = ((JavaInterface)w.getTarget2().getInterface()).getInterface();
            }
            if (jce._class == null || jce._superClass == null) continue;
            this.wires.add(jce);
        }
        for (Reference r : c.getReference()) {
            if (r.getInterface() == null || !(r.getInterface() instanceof JavaInterface)) continue;
            jtc = new JavaToCompositeElement();
            jtc._class = ((JavaInterface)r.getInterface()).getInterface();
            jtc.eobject = r.getInterface();
            this.classNameToJavaElt.put(jtc._class, jtc);
            for (ComponentReference cs : r.getPromote()) {
                if (cs.getInterface() == null || !(cs.getInterface() instanceof JavaInterface)) continue;
                JavaCompatibilityElement jce = new JavaCompatibilityElement();
                jce._class = jtc._class;
                jce._superClass.add(((JavaInterface)cs.getInterface()).getInterface());
                this.promotes.add(jce);
            }
        }
        for (Component comp : c.getComponent()) {
            JavaCompatibilityElement jceComponent = new JavaCompatibilityElement();
            if (comp.getImplementation() != null && comp.getImplementation() instanceof JavaImplementation) {
                JavaToCompositeElement jtcComponent = new JavaToCompositeElement();
                jtcComponent.isInterface = false;
                jtcComponent._class = ((JavaImplementation)comp.getImplementation()).getClass_();
                jtcComponent.eobject = comp.getImplementation();
                this.classNameToJavaElt.put(jtcComponent._class, jtcComponent);
                jceComponent._class = jtcComponent._class;
                this.componentNameToJavaImpl.put(comp, jtcComponent._class);
            }
            for (ComponentService s : comp.getService()) {
                if (s.getInterface() == null || !(s.getInterface() instanceof JavaInterface)) continue;
                JavaToCompositeElement jtcService = new JavaToCompositeElement();
                jtcService._class = ((JavaInterface)s.getInterface()).getInterface();
                jtcService.eobject = s.getInterface();
                this.classNameToJavaElt.put(jtcService._class, jtcService);
                jceComponent._superClass.add(jtcService._class);
            }
            this.impls.add(jceComponent);
            for (ComponentReference r : comp.getReference()) {
                if (r.getInterface() == null || !(r.getInterface() instanceof JavaInterface)) continue;
                JavaToCompositeElement jtc2 = new JavaToCompositeElement();
                jtc2._class = ((JavaInterface)r.getInterface()).getInterface();
                jtc2.eobject = r.getInterface();
                this.classNameToJavaElt.put(jtc2._class, jtc2);
                for (ComponentService cs : r.getTarget()) {
                    if (cs.getInterface() == null || !(cs.getInterface() instanceof JavaInterface)) continue;
                    JavaCompatibilityElement jce = new JavaCompatibilityElement();
                    jce._class = ((JavaInterface)cs.getInterface()).getInterface();
                    jce._superClass.add(jtc2._class);
                    this.wires.add(jce);
                }
            }
        }
    }

    public Collection<ScaValidationEntryBean> validateInterfaceCompatibilityInPromotes() {
        ArrayList<ScaValidationEntryBean> result = new ArrayList<ScaValidationEntryBean>();
        for (JavaCompatibilityElement jce : this.promotes) {
            JavaToCompositeElement elt = this.classNameToJavaElt.get(jce._class);
            if (elt == null || !elt.isInClassPath || this.isEqual(jce._class, jce._superClass)) continue;
            List notImplemented = JDTUtils.implementsOrExtendsAll((IJavaProject)this.javaProject, (String)jce._class, jce._superClass);
            for (String ni : notImplemented) {
                String msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_17, (Object[])new Object[]{jce._class, ni});
                result.add(new ScaValidationEntryBean(this.scaFile, msg, 4, (IScaSignature)new ScaSignature(elt.eobject), elt.eobject));
            }
        }
        return result;
    }

    public Collection<ScaValidationEntryBean> validateInterfaceCompatibilityInWires() {
        ArrayList<ScaValidationEntryBean> result = new ArrayList<ScaValidationEntryBean>();
        for (JavaCompatibilityElement jce : this.wires) {
            JavaToCompositeElement elt = this.classNameToJavaElt.get(jce._class);
            if (elt == null || !elt.isInClassPath || this.isEqual(jce._class, jce._superClass)) continue;
            List notImplemented = JDTUtils.implementsOrExtendsAll((IJavaProject)this.javaProject, (String)jce._class, jce._superClass);
            for (String ni : notImplemented) {
                String msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_3, (Object[])new Object[]{jce._class, ni});
                result.add(new ScaValidationEntryBean(this.scaFile, msg, 4, (IScaSignature)new ScaSignature(elt.eobject), elt.eobject));
            }
        }
        return result;
    }

    public Collection<ScaValidationEntryBean> validateInterfaceImplementations() {
        ArrayList<ScaValidationEntryBean> result = new ArrayList<ScaValidationEntryBean>();
        for (JavaCompatibilityElement jce : this.impls) {
            JavaToCompositeElement elt = this.classNameToJavaElt.get(jce._class);
            if (elt == null || !elt.isInClassPath || this.isEqual(jce._class, jce._superClass)) continue;
            List notImplemented = JDTUtils.implementsOrExtendsAll((IJavaProject)this.javaProject, (String)jce._class, jce._superClass);
            for (String ni : notImplemented) {
                String msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_30, (Object[])new Object[]{jce._class, ni});
                result.add(new ScaValidationEntryBean(this.scaFile, msg, 4, (IScaSignature)new ScaSignature(elt.eobject), elt.eobject));
            }
        }
        return result;
    }

    public Collection<ScaValidationEntryBean> validateOthers() {
        return Collections.emptyList();
    }

    public Collection<ScaValidationEntryBean> validatePreRequisites() {
        ArrayList<ScaValidationEntryBean> result = new ArrayList<ScaValidationEntryBean>();
        for (JavaToCompositeElement jtc : this.classNameToJavaElt.values()) {
            if (jtc._class == null) {
                String msg = Messages.ScaBuilderJavaExtension_7;
                result.add(new ScaValidationEntryBean(this.scaFile, msg, 4, (IScaSignature)new ScaSignature(jtc.eobject), jtc.eobject));
                continue;
            }
            try {
                String msg;
                Diagnostic diag = JDTUtils.validateJavaTypeName((String)jtc._class, (EObject)jtc.eobject);
                if (diag != null) {
                    result.addAll(ScaBuilderUtils.convertDiagnostics(diag, this.scaFile));
                    continue;
                }
                IType iType = this.javaProject.findType(jtc._class);
                if (iType == null) {
                    msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_22, (Object)jtc._class);
                    result.add(new ScaValidationEntryBean(this.scaFile, msg, 2, (IScaSignature)new ScaSignature(jtc.eobject), jtc.eobject));
                    continue;
                }
                jtc.isInClassPath = true;
                if (jtc.isInterface) {
                    if (iType.isInterface()) continue;
                    msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_13, (Object)jtc._class);
                    result.add(new ScaValidationEntryBean(this.scaFile, msg, 2, (IScaSignature)new ScaSignature(jtc.eobject), jtc.eobject));
                    continue;
                }
                if (iType.isClass()) continue;
                msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_25, (Object)jtc._class);
                result.add(new ScaValidationEntryBean(this.scaFile, msg, 4, (IScaSignature)new ScaSignature(jtc.eobject), jtc.eobject));
            }
            catch (JavaModelException e) {
                Sca1_1CommonPlugin.log((Exception)((Object)e), 4);
            }
        }
        return result;
    }

    public Collection<ScaValidationEntryBean> validateReferencesInImplementations() {
        ArrayList<ScaValidationEntryBean> result = new ArrayList<ScaValidationEntryBean>();
        for (Map.Entry<Component, String> entry : this.componentNameToJavaImpl.entrySet()) {
            if (this.classNameToJavaElt.get((Object)entry.getValue()).isInClassPath) continue;
        }
        return result;
    }

    private boolean isEqual(String className, List<String> superClassNames) {
        return superClassNames.size() == 1 && superClassNames.get(0).equals(className);
    }

    private static class JavaCompatibilityElement {
        String _class;
        List<String> _superClass = new ArrayList<String>();

        private JavaCompatibilityElement() {
        }
    }

    private static class JavaToCompositeElement {
        String _class;
        boolean isInterface = true;
        boolean isInClassPath = false;
        EObject eobject;

        private JavaToCompositeElement() {
        }
    }
}

