/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.data;

import org.eclipse.stardust.ide.simulation.ui.curves.data.Range;

public class DiscreteRange
implements Range {
    double t0;
    double t1;
    int numberOfSteps;

    public DiscreteRange(double t0, double t1, int numberOfSteps) {
        this.t0 = Math.min(t0, t1);
        this.t1 = Math.max(t0, t1);
        this.numberOfSteps = Math.max(numberOfSteps, 2);
    }

    public DiscreteRange(double t0, double t1, double resolution) {
        this.t0 = Math.min(t0, t1);
        this.t1 = Math.max(t0, t1);
        this.numberOfSteps = (int)(Math.round((this.t1 - this.t0) / resolution) + 1L);
    }

    public DiscreteRange(double t0, double t1) {
        this.t0 = Math.min(t0, t1);
        this.t1 = Math.max(t0, t1);
        this.numberOfSteps = 2;
    }

    public DiscreteRange(Range range, int numberOfSteps) {
        this.t0 = range.getT0();
        this.t1 = range.getT1();
        this.numberOfSteps = Math.max(numberOfSteps, 2);
    }

    @Override
    public double getT0() {
        return this.t0;
    }

    @Override
    public double getT1() {
        return this.t1;
    }

    @Override
    public double getRange() {
        return this.t1 - this.t0;
    }

    @Override
    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    @Override
    public double getResolution() {
        return this.getRange() / (double)(this.numberOfSteps - 1);
    }
}

