/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.stardust.ide.simulation.ui.curves.draw2d.AbstractOverlayFigure;
import org.eclipse.stardust.ide.simulation.ui.curves.draw2d.NullLayout;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;

public class ZoomFigure
extends AbstractOverlayFigure {
    boolean on;
    boolean pin;
    Figure thumbnail;
    Figure zoom;

    public ZoomFigure(Configuration configuration, Figure thumbnail, Figure zoom) {
        super(configuration);
        this.thumbnail = thumbnail;
        this.zoom = zoom;
        this.add((IFigure)thumbnail);
        this.add((IFigure)zoom);
        this.setLayoutManager((LayoutManager)new NullLayout());
        this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                ZoomFigure.this.setZoomOn(true);
                ZoomFigure.this.forceRepaint();
            }

            public void mouseExited(MouseEvent me) {
                if (!ZoomFigure.this.getBounds().contains(me.getLocation())) {
                    ZoomFigure.this.setZoomOn(false);
                    ZoomFigure.this.forceRepaint();
                }
            }
        });
    }

    public boolean isZoomOn() {
        return this.pin || this.on;
    }

    public void setZoomOn(boolean on) {
        this.on = on;
        this.forceRepaint();
    }

    public boolean isPin() {
        return this.pin;
    }

    public void setPin(boolean pin) {
        this.pin = pin;
        this.forceRepaint();
    }

    public boolean containsPoint(int x, int y) {
        Point pt = new Point(x, y);
        this.translateFromParent((Translatable)pt);
        return this.isZoomOn() ? this.zoom.containsPoint(pt.x, pt.y) : this.thumbnail.containsPoint(pt.x, pt.y);
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (!this.isEnabled()) {
            return null;
        }
        IFigure found = this.zoom.findFigureAt(x, y, search);
        if (this.isZoomOn() && found != null) {
            return found;
        }
        if (!this.isZoomOn() && this.thumbnail.findFigureAt(x, y, search) != null) {
            return this;
        }
        return null;
    }

    protected void paintChildren(Graphics graphics) {
        if (this.isZoomOn()) {
            this.zoom.paint(graphics);
        } else {
            this.thumbnail.paint(graphics);
        }
    }
}

