/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayerBase;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class DottedCurveLayer
extends CurveLayerBase {
    int dotSize;
    RGB white = new RGB(255, 255, 255);

    public DottedCurveLayer(DataProvider provider, int curveNr, int dotSize) {
        super(provider, curveNr);
        this.dotSize = dotSize;
    }

    public DottedCurveLayer(DataProvider provider, RGB color, int dotSize) {
        super(provider, color);
        this.dotSize = dotSize;
    }

    public DottedCurveLayer(DataProvider provider, RGB color) {
        super(provider, color);
        this.dotSize = 5;
    }

    public DottedCurveLayer(DataProvider provider, int curveNr) {
        super(provider, curveNr);
        this.dotSize = 5;
    }

    public DottedCurveLayer(CurveLayer wrapped, int dotSize) {
        super(wrapped);
        this.dotSize = dotSize;
    }

    public DottedCurveLayer(CurveLayer wrapped) {
        super(wrapped);
        this.dotSize = 5;
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
        super.draw(gc, metrics, configuration);
        if (this.getCoords().length > 0) {
            int halfDotSize = this.dotSize / 2;
            gc.pushState();
            gc.setBackgroundColor(configuration.getColorObject(this.white));
            gc.setForegroundColor(this.getColor(configuration));
            Point[] points = Coord2D.model2swt(metrics.transposeToCanvas(this.getCoords()));
            int i = 0;
            while (i < points.length) {
                gc.fillOval(points[i].x - halfDotSize, points[i].y - halfDotSize, this.dotSize, this.dotSize);
                gc.drawOval(points[i].x - halfDotSize, points[i].y - halfDotSize, this.dotSize, this.dotSize);
                ++i;
            }
            gc.popState();
        }
    }
}

