/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.timeline;

import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.TimelineEditor;
import org.eclipse.swt.widgets.Composite;

public class CalendarEditor
extends TimelineEditor {
    public CalendarEditor(Composite parent, int style, Configuration configuration) {
        super(parent, style, configuration);
    }

    @Override
    public void actionExecute(Coord2D point, boolean appendMode) {
        this.redraw();
    }

    @Override
    public void actionSelect(Coord2D point, boolean appendMode) {
        Coord2D found = this.curve.isNearHorizontal(point, 1.0);
        if (found != null) {
            if (found.getY() > 0.0) {
                Coord2D changed = new Coord2D(found.getX(), 0.0);
                this.notifyListenersOnSelect(found, 256);
                this.curve.replacePoints(new Coord2D[]{found}, new Coord2D[]{changed});
                this.notifyListenersOnDrag(found, changed, 256);
            } else {
                Coord2D changed = new Coord2D(found.getX(), 1.0);
                this.notifyListenersOnSelect(found, 512);
                this.curve.replacePoints(new Coord2D[]{found}, new Coord2D[]{changed});
                this.notifyListenersOnDrag(found, changed, 512);
            }
        }
        this.notifyListenersOnDragEnd();
        this.redraw();
    }

    @Override
    public void actionPopup(Coord2D point, boolean appendMode) {
        this.notifyListenersOnPopup(point, 512);
    }

    @Override
    public void actionDragCommit(Coord2D source, Coord2D distance, Coord2D target) {
        this.redraw();
        this.notifyListenersOnDragEnd();
    }

    @Override
    public void actionDragAbort() {
        this.redraw();
        this.notifyListenersOnDragEnd();
    }

    @Override
    public void actionDragPreview(Coord2D source, Coord2D distance, Coord2D target) {
        this.redraw();
    }

    @Override
    public void actionMovePreview(Coord2D position) {
        this.notifyListenersOnPoint(position, 256);
    }

    @Override
    public void updateSensivity(Rectangle2D sensivity) {
    }
}

