/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfigurationList;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.propertypages.SimulationConfigurationPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.IApplicationPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.core.editors.ui.TableManager;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.ModelElementAdaptable;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ModelSimulationPropertyPage
extends AbstractModelElementPropertyPage
implements IApplicationPropertyPage,
IButtonManager {
    private static final String PAGE_NAME = "org.eclipse.stardust.ide.simulation.ui.modelSimulationPropertyPage";
    private transient TableManager tableManager;
    private Button[] buttons;
    private Object selection;
    private SimulationConfigurationList simulationConfigurationList;

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.simulationConfigurationList = new SimulationConfigurationList(ModelUtils.findContainingModel((EObject)element));
        this.resetContent();
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        this.simulationConfigurationList.writeSimulationConfigurationsToModel();
    }

    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)3);
        Tree tree = new Tree(composite, 67584);
        tree.setHeaderVisible(true);
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                Object selection = item.getData();
                ModelSimulationPropertyPage.this.updateButtons(selection, ModelSimulationPropertyPage.this.buttons);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object selection = ModelSimulationPropertyPage.this.tableManager.getSelectedItem();
                if (selection instanceof SimulationConfiguration) {
                    ModelSimulationPropertyPage.this.selectPageForObject(selection);
                }
            }
        });
        GridData treeGridData = new GridData();
        treeGridData.horizontalSpan = 3;
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.horizontalAlignment = 4;
        treeGridData.verticalAlignment = 4;
        tree.setLayoutData((Object)treeGridData);
        this.tableManager = new TableManager(tree);
        this.tableManager.setColumnSizes(new int[]{70, 30});
        this.tableManager.setColumnNames(new String[]{Simulation_Modeling_Messages.PROPERTY_PAGE_MODEL_COLUMN_NAME, Simulation_Modeling_Messages.PROPERTY_PAGE_MODEL_COLUMN_CURRENT});
        this.tableManager.setAttributeNames(new String[]{"name", "currentString"});
        return composite;
    }

    public void contributeVerticalButtons(Composite parent) {
        this.buttons = this.createButtons(parent);
    }

    public Button[] createButtons(Composite parent) {
        Button[] buttons = new Button[]{FormBuilder.createButton((Composite)parent, (String)Simulation_Modeling_Messages.PROPERTY_PAGE_MODEL_BUTTON_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSimulationPropertyPage.this.performAdd();
            }
        }), FormBuilder.createButton((Composite)parent, (String)Simulation_Modeling_Messages.PROPERTY_PAGE_MODEL_BUTTON_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSimulationPropertyPage.this.performDelete();
            }
        }), FormBuilder.createButton((Composite)parent, (String)Simulation_Modeling_Messages.PROPERTY_PAGE_MODEL_BUTTON_COPY, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSimulationPropertyPage.this.performCopy();
            }
        })};
        return buttons;
    }

    public Object getSelection() {
        return this.selection == null ? this.tableManager.getSelectedItem() : this.selection;
    }

    public void updateButtons(Object selection, Button[] arg1) {
        this.selection = selection;
    }

    public void resetContent() {
        this.removePreferenceNodes(ModelElementPropertyDialog.convertId((String)PAGE_NAME), false);
        this.tableManager.removeAll();
        this.updateButtons(null, this.buttons);
        for (SimulationConfiguration simulationConfiguration : this.simulationConfigurationList.getAllConfigurations()) {
            this.addSimulationConfiguration(simulationConfiguration);
        }
        this.refreshTree();
    }

    private void performDelete() {
        SimulationConfiguration simulationConfiguration = (SimulationConfiguration)this.getSelection();
        if (simulationConfiguration != null) {
            this.simulationConfigurationList.remove(simulationConfiguration);
            this.resetContent();
            this.updateButtons(null, this.buttons);
            this.selectPage(ModelElementPropertyDialog.convertId((String)PAGE_NAME));
        }
    }

    private void performAdd() {
        SimulationConfiguration simulationConfiguration = this.simulationConfigurationList.create();
        this.addSimulationConfiguration(simulationConfiguration);
        this.selectPageForObject(simulationConfiguration);
    }

    private void performCopy() {
        SimulationConfiguration simulationConfiguration = this.simulationConfigurationList.create();
        this.addSimulationConfiguration(simulationConfiguration);
        this.selectPageForObject(simulationConfiguration);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateButtons(this.tableManager.getSelectedItem(), this.buttons);
        }
        super.setVisible(visible);
    }

    private void addSimulationConfiguration(SimulationConfiguration simulationConfiguration) {
        this.tableManager.addElement((Object)"SimulationConfiguration", (Object)simulationConfiguration);
        MyConfigurationElement config = new MyConfigurationElement(simulationConfiguration);
        CarnotPreferenceNode node = new CarnotPreferenceNode((ConfigurationElement)config, (IAdaptable)new ModelElementAdaptable(new Class[]{IButtonManager.class, SimulationConfiguration.class, SimulationConfigurationList.class}, new Object[]{this, simulationConfiguration, this.simulationConfigurationList}, this.getElement()), -2);
        this.addNodeTo(ModelElementPropertyDialog.convertId((String)PAGE_NAME), node, null);
        this.refreshTree();
    }

    private class MyConfigurationElement
    extends ConfigurationElement {
        private HashMap attributes;

        public MyConfigurationElement(SimulationConfiguration config) {
            super("page");
            this.attributes = new HashMap();
            this.attributes.put("id", "bla" + System.currentTimeMillis());
            this.attributes.put("name", config.getName());
            this.attributes.put("icon", null);
            this.attributes.put("propertyPageClass", SimulationConfigurationPropertyPage.class.getName());
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            return new SimulationConfigurationPropertyPage();
        }

        public String getAttribute(String name) throws InvalidRegistryObjectException {
            return (String)this.attributes.get(name);
        }

        public String[] getAttributeNames() {
            return this.attributes.keySet().toArray(new String[this.attributes.size()]);
        }
    }
}

