/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import java.util.Date;
import java.util.HashMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DiscreteIntegral;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.DragListener;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.distributions.AvailabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AbstractSimulationPanel;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForCalendarPopupMenu;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForCurvePopupMenu;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForSliderButton;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.StackLayoutComposite;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.TimelineWidget;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.CurveUtils;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AvailabilityPanel
extends AbstractSimulationPanel {
    Button unlimitedButton;
    Composite availabilityPanel;
    TimelineWidget dayWidget;
    AdapterForCurvePopupMenu dayPopup;
    TimelineWidget calendarWidget;
    AdapterForCalendarPopupMenu calendarPopup;
    TimelineWidget yearWidget;
    AdapterForCurvePopupMenu yearPopup;
    AdapterForSliderButton multiplicatorSlider;
    Text multiplicatorStatusText;
    AvailabilityConfiguration configuration;
    Coord2D dayCurveSnap = new Coord2D(0.25, 0.01);

    public AvailabilityPanel(Composite parent, int style, String unlimitedLabel, String dayLabel, String calendarLabel, String yearLabel, int dayWidgetType) {
        super(parent, style);
        if (unlimitedLabel != null) {
            this.unlimitedButton = FormBuilder.createCheckBox((Composite)this.configPanel, (String)unlimitedLabel);
            this.unlimitedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AvailabilityPanel.this.setChildrenEnabled(!AvailabilityPanel.this.unlimitedButton.getSelection());
                }
            });
        }
        this.detailsStackBox = new StackLayoutComposite(this.configPanel, 0);
        this.emptyDetailsPanel = FormBuilder.createComposite((Composite)this.detailsStackBox, (int)1);
        this.availabilityPanel = FormBuilder.createComposite((Composite)this.detailsStackBox, (int)1);
        this.yearWidget = new TimelineWidget(this.availabilityPanel, 1024, 3);
        this.yearWidget.setTitleLabel(yearLabel);
        this.yearWidget.getEditor().addDragListener((DragListener)new DragListener.Stub(){

            public void onPopup(Coord2D source, int direction) {
                if ((direction & 0x300) != 0) {
                    Coord2D target = source;
                    target = direction == 256 ? new Coord2D(AvailabilityPanel.this.enterDayValue(source.getX()), source.getY()) : new Coord2D(source.getX(), AvailabilityPanel.this.enterDoubleValue(source.getY()));
                    AvailabilityPanel.this.yearWidget.getEditor().actionDragCommit(source, target.minus(source), target);
                } else {
                    Coord2D[] curve = AvailabilityPanel.this.yearWidget.getEditor().getCurveData();
                    AvailabilityPanel.this.yearWidget.getEditor().setCurveData(curve);
                }
            }
        });
        this.yearPopup = AdapterForCurvePopupMenu.createAvailavilityMenu(this.getShell(), this.yearWidget.getEditor());
        this.yearWidget.setPopupMenu(this.yearPopup.getMenu());
        this.calendarWidget = new TimelineWidget(this.availabilityPanel, 1024, 2);
        this.calendarWidget.setTitleLabel(calendarLabel);
        this.calendarPopup = new AdapterForCalendarPopupMenu(this.getShell(), this.calendarWidget.getEditor());
        this.calendarWidget.setPopupMenu(this.calendarPopup.getMenu());
        if (dayWidgetType == 6) {
            this.dayCurveSnap = new Coord2D(0.25, 0.001);
        }
        this.dayWidget = new TimelineWidget(this.availabilityPanel, 0, dayWidgetType);
        this.dayWidget.setTitleLabel(dayLabel);
        this.dayWidget.getEditor().addDragListener((DragListener)new DragListener.Stub(){

            public void onPopup(Coord2D source, int direction) {
                if ((direction & 0x300) != 0) {
                    Coord2D target = source;
                    if (direction == 256) {
                        target = new Coord2D(AvailabilityPanel.this.enterHourValue(source.getX()), source.getY());
                    } else if (AvailabilityPanel.this.dayWidget.getEditor().getType() == 6) {
                        DiscreteIntegral integralCalculator = AvailabilityPanel.this.dayWidget.getEditor().getCurveIntegralCalculator();
                        target = new Coord2D(source.getX(), AvailabilityPanel.this.enterAreaValue(source.getX(), source.getY(), integralCalculator));
                    } else {
                        target = new Coord2D(source.getX(), AvailabilityPanel.this.enterPCentValue(source.getY(), 100.0));
                    }
                    AvailabilityPanel.this.dayWidget.getEditor().actionDragCommit(source, target.minus(source), target);
                }
            }
        });
        this.dayPopup = dayWidgetType != 6 ? AdapterForCurvePopupMenu.createDailyMenu(this.getShell(), this.dayWidget.getEditor()) : AdapterForCurvePopupMenu.createArrivalRateMenu(this.getShell(), this.dayWidget.getEditor());
        this.dayWidget.setPopupMenu(this.dayPopup.getMenu());
        this.multiplicatorSlider = new AdapterForSliderButton(this.yearWidget.getTitleSlot(), new AdjustableDoubleRange(yearLabel, 0.0, 100.0, 10.0));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).hint(22, 20).applyTo((Control)this.multiplicatorSlider.getControl());
        this.multiplicatorStatusText = new Text(this.yearWidget.getTitleSlot(), 2056);
        this.multiplicatorSlider.addStatusComponent((Control)this.multiplicatorStatusText);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).hint(80, -1).applyTo((Control)this.multiplicatorStatusText);
        this.detailsStackBox.setTopControl(this.availabilityPanel);
        if (unlimitedLabel == null) {
            this.setChildrenEnabled(true);
        }
        if (this.unlimitedButton != null) {
            GridDataFactory.fillDefaults().align(16384, 4).grab(false, false).applyTo((Control)this.unlimitedButton);
        }
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.detailsStackBox);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo(this.emptyDetailsPanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo(this.availabilityPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.dayWidget);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.calendarWidget);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.yearWidget);
    }

    @Override
    protected void onAuditCheckBoxChange() {
        boolean enabled = !this.auditCheckBox.getSelection();
        this.dayWidget.setEnabled(enabled);
        this.calendarWidget.setEnabled(enabled);
        this.yearWidget.setEnabled(enabled);
        if (this.unlimitedButton != null) {
            this.unlimitedButton.setEnabled(enabled);
            if (!this.unlimitedButton.isEnabled()) {
                this.unlimitedButton.setSelection(false);
            }
            this.setChildrenEnabled(!this.unlimitedButton.getSelection());
        }
        this.multiplicatorSlider.getControl().setEnabled(enabled);
    }

    public AdapterForSliderButton getMultiplicatorSlider() {
        return this.multiplicatorSlider;
    }

    public boolean isUnlimited() {
        return this.unlimitedButton != null ? this.unlimitedButton.getSelection() : false;
    }

    public void setUnlimited(boolean unlimited) {
        if (this.unlimitedButton != null) {
            this.unlimitedButton.setSelection(unlimited);
            this.setChildrenEnabled(!this.isUnlimited());
        } else {
            this.setChildrenEnabled(true);
        }
    }

    public void setDayData(Coord2D[] data) {
        this.dayWidget.setCurveData(data);
    }

    public Coord2D[] getDayData() {
        return this.dayWidget.getCurveData();
    }

    public void setCalendarData(Coord2D[] data) {
        this.calendarWidget.setCurveData(data);
    }

    public Coord2D[] getCalendarData() {
        return this.calendarWidget.getCurveData();
    }

    public void setYearData(Coord2D[] data) {
        this.yearWidget.setCurveData(data);
    }

    public Coord2D[] getYearData() {
        return this.yearWidget.getCurveData();
    }

    public AvailabilityConfiguration getConfiguration() {
        this.configuration.setUnlimited(this.isUnlimited());
        this.configuration.setFromAuditTrail(this.isFromAuditTrailMode());
        this.configuration.setDay(CurveUtils.fromCurve(3600000L, this.dayWidget.getCurveData()));
        this.configuration.setCalendar(CurveUtils.fromCurve(86400000L, this.calendarWidget.getCurveData()));
        this.configuration.setPredefinedCalendars(this.calendarPopup.getSelectedCalendarIds());
        this.configuration.setYear(CurveUtils.fromCurve(86400000L, this.yearWidget.getCurveData()));
        this.configuration.setMultiplicatorSlider(this.multiplicatorSlider.getSliderRange());
        return this.configuration;
    }

    public void setConfiguration(AvailabilityConfiguration configuration) {
        this.configuration = configuration;
        this.setFromAuditTrailMode(configuration.isFromAuditTrail());
        this.setUnlimited(configuration.isUnlimited());
        Date startDate = configuration.getInterval().getStartDate();
        Date endDate = configuration.getInterval().getEndDate();
        this.dayWidget.setTimeline(startDate, endDate, 11, 1.0, this.dayCurveSnap);
        this.dayWidget.setCurveData(CurveUtils.toCurve(3600000.0, configuration.getDay()));
        this.calendarWidget.setTimeline(configuration.getInterval().getStartDate(), configuration.getInterval().getEndDate(), 6, 1.0, new Coord2D(1.0, 1.0));
        this.calendarWidget.setCurveData(CurveUtils.toCurve(8.64E7, configuration.getCalendar()));
        this.yearWidget.setTimeline(configuration.getInterval().getStartDate(), configuration.getInterval().getEndDate(), 6, 10.0, new Coord2D(1.0, 1.0));
        this.yearWidget.setCurveData(CurveUtils.toCurve(8.64E7, configuration.getYear()));
        this.multiplicatorSlider.setSliderRange(configuration.getMultiplicatorSlider());
        this.multiplicatorStatusText.setText(AdapterForSliderButton.MULTIPLICATOR_FORMATTER.format(configuration.getMultiplicator().getValue()));
        this.calendarPopup.setSelectedCalendarIds(configuration.getPredefinedCalendars());
    }

    private void setChildrenEnabled(boolean enabled) {
        this.yearPopup.getMenu().setEnabled(enabled);
        this.calendarPopup.getMenu().setEnabled(enabled);
        if (this.dayPopup != null) {
            this.dayPopup.getMenu().setEnabled(enabled);
        }
        if (enabled) {
            this.detailsStackBox.setTopControl(this.availabilityPanel);
        } else {
            this.detailsStackBox.setTopControl(this.emptyDetailsPanel);
        }
    }

    protected double enterDayValue(double d) {
        return d;
    }

    public static void main(String[] args) {
        int configurationId = 4711;
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("DistributionPanel Test");
        shell.setLayout((Layout)new FillLayout());
        SimulationInterval intervalConfiguration = new SimulationInterval(TimeCalculator.now().toDate(), TimeCalculator.fromNow(2, 1).toDate());
        AvailabilityPanel panel = new AvailabilityPanel((Composite)shell, 0, "Some Text", Simulation_Modeling_Messages.DAILY_AVAILABILITY, Simulation_Modeling_Messages.CALENDAR_AVAILABILITY, Simulation_Modeling_Messages.AVAILABLE_RESOURCE, 1);
        AvailabilityConfiguration ac1 = new AvailabilityConfiguration(intervalConfiguration);
        ac1.read(new HashMap(), configurationId);
        panel.setConfiguration(ac1);
        shell.setSize(600, 800);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

