/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import java.util.HashMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.DragListener;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.distributions.DistributionFactory;
import org.eclipse.stardust.ide.simulation.ui.distributions.ProbabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AbstractSimulationPanel;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForCurvePopupMenu;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForSliderButton;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.EmbeddedDistributionPanel;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.StackLayoutComposite;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.TimelineWidget;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.CurveUtils;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProbabilityPanel
extends AbstractSimulationPanel {
    Composite probabilityPanel;
    TimelineWidget curveWidget;
    AdapterForCurvePopupMenu curvePopup;
    AdapterForSliderButton multiplicatorSlider;
    Text multiplicatorStatusText;
    EmbeddedDistributionPanel distributionPanel;
    ProbabilityConfiguration configuration;

    public ProbabilityPanel(Composite parent, int style) {
        super(parent, style);
        this.detailsStackBox = new StackLayoutComposite(this.configPanel, 0);
        this.emptyDetailsPanel = FormBuilder.createComposite((Composite)this.detailsStackBox, (int)1);
        this.probabilityPanel = FormBuilder.createComposite((Composite)this.detailsStackBox, (int)1);
        this.buildProbabilityPanel(this.probabilityPanel);
        this.buildRepetitionDistributionPanel(this.probabilityPanel);
        this.detailsStackBox.setTopControl(this.probabilityPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.detailsStackBox);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo(this.emptyDetailsPanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(5, 8).numColumns(1).applyTo(this.probabilityPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.curveWidget);
    }

    protected void buildProbabilityPanel(Composite parent) {
        this.curveWidget = new TimelineWidget(parent, 0, 5);
        this.curveWidget.setTitleLabel(Simulation_Modeling_Messages.PROBABILITY_CURVE);
        this.curveWidget.getEditor().addDragListener((DragListener)new DragListener.Stub(){

            public void onPopup(Coord2D source, int direction) {
                if ((direction & 0x300) != 0) {
                    Coord2D target = source;
                    target = direction == 256 ? new Coord2D(ProbabilityPanel.this.enterHourValue(source.getX()), source.getY()) : new Coord2D(source.getX(), ProbabilityPanel.this.enterPCentValue(source.getY(), 1.0));
                    ProbabilityPanel.this.curveWidget.getEditor().actionDragCommit(source, target.minus(source), target);
                }
            }
        });
        this.curvePopup = AdapterForCurvePopupMenu.createProbabilityMenu(this.getShell(), this.curveWidget.getEditor());
        this.curveWidget.setPopupMenu(this.curvePopup.getMenu());
        this.multiplicatorSlider = new AdapterForSliderButton(this.curveWidget.getTitleSlot(), new AdjustableDoubleRange(Simulation_Modeling_Messages.PROBABILITY_COLUMN, 0.0, 100.0, 10.0));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).hint(22, 20).applyTo((Control)this.multiplicatorSlider.getControl());
        this.multiplicatorStatusText = new Text(this.curveWidget.getTitleSlot(), 2056);
        this.multiplicatorSlider.addStatusComponent((Control)this.multiplicatorStatusText);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).hint(80, -1).applyTo((Control)this.multiplicatorStatusText);
    }

    protected void buildRepetitionDistributionPanel(Composite parent) {
        Label headline = new Label(parent, 0);
        headline.setText(Simulation_Modeling_Messages.MAX_TRAVERSAL_COUNT);
        headline.setFont(this.bold(headline.getFont(), headline.getDisplay()));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)headline);
        this.distributionPanel = new EmbeddedDistributionPanel(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.probabilityPanel);
    }

    public void addDragListener(DragListener listener) {
        this.curveWidget.getEditor().addDragListener(listener);
    }

    @Override
    protected boolean showConfigurationInfoWidget() {
        return false;
    }

    @Override
    protected void onAuditCheckBoxChange() {
        this.setChildrenEnabled(!this.auditCheckBox.getSelection());
    }

    public ProbabilityConfiguration getConfiguration() {
        if (this.configuration != null) {
            this.configuration.setCurve(CurveUtils.fromCurve(86400000L, this.curveWidget.getCurveData()));
            this.configuration.setMultiplicatorSlider(this.multiplicatorSlider.getSliderRange());
            this.configuration.setFromAuditTrail(this.isFromAuditTrailMode());
            this.distributionPanel.setDistributionFactory(new DistributionFactory(this.configuration.getInterval()));
            this.configuration.setRepetitionDistribution(this.distributionPanel.getConfiguration());
        }
        return this.configuration;
    }

    public void setConfiguration(ProbabilityConfiguration configuration) {
        this.configuration = configuration;
        this.curveWidget.setTimeline(configuration.getInterval().getStartDate(), configuration.getInterval().getEndDate(), 6, 100.0, new Coord2D(1.0, 1.0));
        this.curveWidget.setCurveData(CurveUtils.toCurve(8.64E7, configuration.getCurve()));
        this.multiplicatorSlider.setSliderRange(configuration.getMultiplicatorSlider());
        this.multiplicatorStatusText.setText(AdapterForSliderButton.MULTIPLICATOR_FORMATTER.format(configuration.getMultiplicator().getValue()));
        this.distributionPanel.setDistributionFactory(new DistributionFactory(configuration.getInterval()));
        this.distributionPanel.setConfiguration(configuration.getRepetitionDistribution());
        this.setFromAuditTrailMode(configuration.isFromAuditTrail());
        this.detailsStackBox.layout();
    }

    private void setChildrenEnabled(boolean enabled) {
        this.curveWidget.setEnabled(enabled);
        this.multiplicatorSlider.getControl().setEnabled(enabled);
        this.distributionPanel.setEnabled(enabled);
    }

    public static void main(String[] args) {
        int configurationId = 4711;
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("DistributionPanel Test");
        shell.setLayout((Layout)new FillLayout());
        SimulationInterval intervalConfiguration = new SimulationInterval(TimeCalculator.now().toDate(), TimeCalculator.fromNow(2, 1).toDate());
        ProbabilityPanel panel = new ProbabilityPanel((Composite)shell, 0);
        ProbabilityConfiguration ac1 = new ProbabilityConfiguration(intervalConfiguration, 100.0);
        ac1.read(new HashMap(), configurationId);
        panel.setConfiguration(ac1);
        shell.setSize(600, 800);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

