/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import org.eclipse.stardust.ide.simulation.ui.timeutils.Interval;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampHelper;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValueList;

public class ClassifiedTimestampList
extends TimestampValueList {
    Interval interval;

    public ClassifiedTimestampList(Interval interval) {
        this.interval = interval;
    }

    public ClassifiedTimestampList(long start, long duration) {
        this.interval = new Interval(start, duration);
    }

    public Interval getInterval() {
        return this.interval;
    }

    public ClassifiedTimestampList getNormalized(double value100Pcent) {
        ClassifiedTimestampList result = new ClassifiedTimestampList(this.interval);
        int i = 0;
        while (i < this.size()) {
            result.add((TimestampValue)this.get(i).normalize(value100Pcent));
            ++i;
        }
        return result;
    }

    public ClassifiedTimestampList getRelative(long offset) {
        ClassifiedTimestampList result = new ClassifiedTimestampList(this.interval);
        int i = 0;
        while (i < this.size()) {
            result.add((TimestampValue)this.get(i).shift(offset - this.interval.time));
            ++i;
        }
        return result;
    }

    public static ClassifiedTimestampList[] createGrid(long millis, long first, long last) {
        Interval[] grid = TimestampHelper.createGrid(millis, first, last);
        ClassifiedTimestampList[] result = new ClassifiedTimestampList[grid.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new ClassifiedTimestampList(grid[i]);
            ++i;
        }
        return result;
    }

    public static ClassifiedTimestampList[] createDayGrid(long first, long last) {
        Interval[] grid = TimestampHelper.createDayGrid(first, last);
        ClassifiedTimestampList[] result = new ClassifiedTimestampList[grid.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new ClassifiedTimestampList(grid[i]);
            ++i;
        }
        return result;
    }

    public static ClassifiedTimestampList[] createWeekGrid(long first, long last) {
        Interval[] grid = TimestampHelper.createWeekGrid(first, last);
        ClassifiedTimestampList[] result = new ClassifiedTimestampList[grid.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new ClassifiedTimestampList(grid[i]);
            ++i;
        }
        return result;
    }

    public static ClassifiedTimestampList[] createMonthGrid(long first, long last) {
        Interval[] grid = TimestampHelper.createMonthGrid(first, last);
        ClassifiedTimestampList[] result = new ClassifiedTimestampList[grid.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new ClassifiedTimestampList(grid[i]);
            ++i;
        }
        return result;
    }

    public static ClassifiedTimestampList[] createGrid(int calendarUnit, long first, long last) {
        if (calendarUnit == 2) {
            return ClassifiedTimestampList.createMonthGrid(first, last);
        }
        if (calendarUnit == 3) {
            return ClassifiedTimestampList.createWeekGrid(first, last);
        }
        return ClassifiedTimestampList.createDayGrid(first, last);
    }

    @Override
    public String toString() {
        return "INTERVAL: " + this.interval.toString() + "\n" + super.toString();
    }
}

