/*******************************************************************************
 * Copyright (c) 2011, 2012 SunGard CSA LLC and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SunGard CSA LLC - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.stardust.ide.wst.facet.portal;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.*;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.ide.wst.common.ExternalLibrary;
import org.eclipse.stardust.ide.wst.common.IModuleConfigurator;
import org.eclipse.stardust.ide.wst.common.IWebModuleConfigurator;
import org.eclipse.stardust.ide.wst.common.IWstCommonConstants;
import org.eclipse.stardust.ide.wst.common.utils.*;
import org.eclipse.stardust.modeling.common.platform.utils.BundleUtils;
import org.eclipse.stardust.modeling.common.projectnature.BpmProjectNature;
import org.eclipse.stardust.modeling.transformation.messaging.format.FormatManager;
import org.eclipse.stardust.modeling.transformation.messaging.format.IMessageFormatDependencyProvider;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;



public class InstallDelegate extends AbstractDelegate implements IModuleConfigurator,
      IWebModuleConfigurator
{
   /* Extension point ID */
   private static final String ICEFACES_JAR_REPLACEMENT = "org.eclipse.stardust.ide.wst.facet.portal.springContextXmlExclusion"; //$NON-NLS-1$

   public void execute(IProject project, IProjectFacetVersion fv, Object config,
         IProgressMonitor monitor) throws CoreException
   {
      monitor.beginTask("", 4); //$NON-NLS-1$
      try
      {
         FacetSetupUtils.configureModule(project, this);
         monitor.worked(1);
         FacetSetupUtils.configureWebModule(project, this);
         monitor.worked(1);
         BpmProjectNature.enableBpmNature(project);
         monitor.worked(1);
         IPath srcFolder = BundleUtils.getBundleLocation(IPPPortalBundleActivator.getInstance()
               .getBundle());

         ExternalLibrary engineJar = CommonLibraryUtils.resolveEngineLibrary("carnot-engine.jar"); //$NON-NLS-1$
         URL engineJarEntryUrl = Platform.getBundle(
               IWstCommonConstants.ENGINE_BUNDLE_ID).getEntry(engineJar.extension);


         ExternalLibrary engineBaseJar = CommonLibraryUtils.resolveEngineLibrary("carnot-base.jar"); //$NON-NLS-1$
         URL engineBaseJarEntryUrl = Platform.getBundle(
               IWstCommonConstants.ENGINE_BASE_BUNDLE_ID).getEntry(engineBaseJar.extension);
         URL baseUrl = null;
         try
         {
            baseUrl = FileLocator.toFileURL(engineBaseJarEntryUrl);
            System.out.println("base url: "+baseUrl); //$NON-NLS-1$
         }
         catch(Exception e)
         {
            e.printStackTrace();
         }


         URL engineJarUrl;
         try
         {
            engineJarUrl = FileLocator.toFileURL(engineJarEntryUrl);
         }
         catch (IOException e)
         {
            throw new RuntimeException(
                  MessageFormat.format(
                        Portals_Messages.EXC_CANNOT_RESOLVE_DEPENDENCY_URL_NULL_CHECK_THE_IMPL_FOR_DELEGATE,
                        new Object[] { engineJarEntryUrl,
                              IWstCommonConstants.ENGINE_BUNDLE_ID }), e);
         }



         Map<String, String> properties = CollectionUtils.newMap();
         properties.put("templatesDir", srcFolder.append("template").toOSString()); //$NON-NLS-1$ //$NON-NLS-2$
         properties.put("settingsDir", project.getFolder(".settings") //$NON-NLS-1$ //$NON-NLS-2$
               .getLocation()
               .toOSString());
         properties.put("sourceFile", engineJarUrl.getPath()); //$NON-NLS-1$ //$NON-NLS-2$
         properties.put("toDir", project.getFolder(IPPPortalFacet.PORTAL_ROOT) //$NON-NLS-1$
               .getLocation()
               .toOSString());
         properties.put("prjLocalPath", project.getFolder(IPPPortalFacet.PORTAL_ROOT) //$NON-NLS-1$
               .getFullPath()
               .toOSString());
         properties.put("projectName", project.getName()); //$NON-NLS-1$
         properties.put("licensePath", ProjectSetupUtils.getLicensePath()); //$NON-NLS-1$
         properties.put("excludeSpringContextXml", getSpringContextExclusion()); //$NON-NLS-1$
         ProjectSetupUtils.addCommonProperties(project, properties);

         FacetSetupUtils.executeAntTarget(project, srcFolder.append("tools/templates.xml"), //$NON-NLS-1$
               "copyTemplates", properties); //$NON-NLS-1$

         invokeDelegateExtensions(INSTALL_DELEGATE_ELEM_ID, project, fv, config, monitor);

         ProjectSetupUtils.refreshCommonFolders(project);
         monitor.worked(1);
      }
      finally
      {
         monitor.done();
      }
   }

   /**
    * @return Return the spring context file which will NOT be part of the possible context files.
    * This is used to distinguish between stardust and IPP.
    */
   private static String getSpringContextExclusion()
   {
      String exclusion = null;
      IConfigurationElement[] configElements = RegistryFactory.getRegistry()
            .getConfigurationElementsFor(ICEFACES_JAR_REPLACEMENT);
      if (configElements != null && configElements.length > 0)
      {
         // get first element
         exclusion = configElements[0].getAttribute("fileName"); //$NON-NLS-1$
      }

      if(StringUtils.isEmpty(exclusion))
      {
         // fall back to exclude IPP version of this file
         exclusion = "carnot-spring-context.xml"; //$NON-NLS-1$
      }

      return exclusion;
   }

   public void performConfiguration(ArtifactEdit artifact)
   {

      addMessageFormatLibraries(artifact);
      ExternalLibrary[] libs = IPPPortalFacet.getExternalLibraries();

      for (int i = 0; i < libs.length; i++ )
      {
         ExternalLibrary lib = libs[i];
         ArtifactUtils.addWebLibraryFromVar(artifact, lib.var + "/" + lib.extension); //$NON-NLS-1$
      }

      // add spring related settings
      ExternalLibrary carnotSpringJar = IPPPortalBundleActivator.getInstance()
            .resolveExternalLibrary("carnot-spring.jar"); //$NON-NLS-1$
      ExternalLibrary[] externalSpringLibs = IPPPortalFacet.getExternalSpringLibraries();

      ArtifactUtils.addWebLibraryFromVar(artifact, carnotSpringJar.var + "/" //$NON-NLS-1$
            + carnotSpringJar.extension);
      for (int i = 0; i < externalSpringLibs.length; i++ )
      {
         ExternalLibrary lib = externalSpringLibs[i];
         ArtifactUtils.addWebLibraryFromVar(artifact, lib.var + "/" + lib.extension); //$NON-NLS-1$
      }

      try
      {
         IVirtualFolder root = artifact.getComponent().getRootFolder();

         String portalRoot = "/" + IPPPortalFacet.PORTAL_ROOT; //$NON-NLS-1$
         root.createLink(new Path(portalRoot), 0, null);
      }
      catch (CoreException ce)
      {

      }

      new WebModuleConfigurator(WebModuleConfigurator.INSTALL_CONFIGURATOR_ELEM_ID)
         .performConfiguration(artifact);
   }

   private void addMessageFormatLibraries(ArtifactEdit artifact)
   {
      IPath srcFolder = BundleUtils.getBundleLocation(IPPPortalBundleActivator.getInstance()
            .getBundle());
      IProject project = artifact.getProject();
      List<String> messageFormats = FormatManager.getMessageFormats();

      for (String messageFormat : messageFormats)
      {
         IMessageFormatDependencyProvider messageFormatDependencyProvider = FormatManager.getMessageFormatDependencyProvider(messageFormat);
         if (messageFormatDependencyProvider != null)
         {
            URL[] libraries = messageFormatDependencyProvider.getRuntimeDependencies();
            for (int j = 0; j < libraries.length; j++)
            {
               URL dependencyUrl = libraries[j];
               if (dependencyUrl == null)
               {
                  // ignore non-valid URLs
                  continue;
               }

               URL fileUrl;
               try
               {
                  fileUrl = FileLocator.toFileURL(dependencyUrl);
               }
               catch (IOException e)
               {
                  throw new RuntimeException(
                        MessageFormat.format(
                              Portals_Messages.EXC_CANNOT_RESOLVE_DEPENDENCY_URL_NULL_CHECK_THE_IMPL_FOR_MSG_FORMAT_ONE,
                              new Object[] {dependencyUrl, messageFormat}), e);
               }

               Map<String, String> properties = CollectionUtils.newMap();
               properties.put("sourceFile", fileUrl.getPath()); //$NON-NLS-1$
               properties.put("toDir", project.getFolder(IPPPortalFacet.PORTAL_ROOT) //$NON-NLS-1$
                     .getLocation()
                     .toOSString());

               FacetSetupUtils.executeAntTarget(project, srcFolder.append("tools/templates.xml"), //$NON-NLS-1$
                     "installExternalJar", properties); //$NON-NLS-1$
            }
         }
      }
      try
      {
         project.refreshLocal(IResource.DEPTH_INFINITE, null);
      }
      catch (CoreException e)
      {
         throw new RuntimeException(e);
      }
   }

   public void performConfiguration(WebArtifactEdit artifact)
   {
      final WebApp root = artifact.getWebApp();

      WebXmlUtils.addContextParam(root, "javax.faces.STATE_SAVING_METHOD", "server"); //$NON-NLS-1$ //$NON-NLS-2$

      WebXmlUtils.addContextParam(root, "facelets.DEVELOPMENT", "true"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addContextParam(root, "facelets.SKIP_COMMENTS", "true"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addContextParam(root, "facelets.VIEW_MAPPINGS", "*.xhtml;*.jspx"); //$NON-NLS-1$ //$NON-NLS-2$

      WebXmlUtils.addContextParam(root, "javax.faces.CONFIG_FILES", //$NON-NLS-1$
            "/WEB-INF/config/ipp/jsf/faces-config.xml,/WEB-INF/config/ipp/jsf/processportal-beans.xml"); //$NON-NLS-1$

      // add spring related setting
      WebXmlUtils.addContextParam(root, "contextConfigLocation", "WEB-INF/config/ipp/spring/*-context.xml,WEB-INF/jax-ws-cxf-context.xml"); //$NON-NLS-1$ //$NON-NLS-2$

      WebXmlUtils.addContextParam(root, "carnot.login.APPLICATION_ID", "processPortal"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addContextParam(root, "carnot.login.ADMINISTRATOR_ROLE_REQUIRED", "false"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addContextParam(root, "carnot.login.MODEL_REQUIRED", "true"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addContextParam(root, "carnot.login.HEADING", "portal-common-messages#portalFramework.title"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addContextParamValue(root, "com.infinity.bpm.portal.common.logoutURI", //$NON-NLS-1$
            "/ipp/common/ippPortalLogout.jsp"); //$NON-NLS-1$

      WebXmlUtils.addContextParamValue(root, "carnot.SESSION_LISTENERS", //$NON-NLS-1$
         "ippRADProcessPortalSessionInitializer,ippAdmPortalSessionListenerBean"); //$NON-NLS-1$

      WebXmlUtils.addContextParamValue(root,
            "ag.carnot.processportal.integration.BUSINESSCONTROLCENTER_URL", //$NON-NLS-1$
            "../../../plugins/common/portalFramework.iface"); //$NON-NLS-1$

      WebXmlUtils.addContextParamValue(root, "com.icesoft.faces.uploadMaxFileSize", "10485760"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addContextParamValue(root, "facelets.RESOURCE_RESOLVER", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.viewscommon.common.PortalPluginFaceletsResourceResolver"); //$NON-NLS-1$

      WebXmlUtils.addContextParam(root, "javax.faces.DEFAULT_SUFFIX", ".xhtml"); //$NON-NLS-1$ //$NON-NLS-2$

      WebXmlUtils.addContextParam(root, "com.icesoft.faces.delegateNonIface", "true"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addContextParam(root, "com.icesoft.faces.synchronousUpdate", "false"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addContextParam(root, "com.icesoft.faces.concurrentDOMViews", "true"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addContextParam(root, "com.icesoft.faces.ignoreUserRoleAttributes", "true"); //$NON-NLS-1$ //$NON-NLS-2$
      //

      WebXmlUtils.addContextParam(root, "org.apache.myfaces.trinidad.DISABLE_DIALOG_OUTCOMES", "true"); //$NON-NLS-1$ //$NON-NLS-2$

      WebXmlUtils.addListener(root,
            "org.apache.myfaces.webapp.StartupServletContextListener"); //$NON-NLS-1$
      WebXmlUtils.addListener(root,
            "org.eclipse.stardust.ui.web.viewscommon.common.listener.SessionContextListener"); //$NON-NLS-1$
      WebXmlUtils.addListener(root,
            "com.icesoft.faces.util.event.servlet.ContextEventRepeater"); //$NON-NLS-1$

      Servlet facesServlet = WebXmlUtils.addServlet(root, "faces", //$NON-NLS-1$
            "javax.faces.webapp.FacesServlet", 1); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, facesServlet, "/faces/*"); //$NON-NLS-1$

      Servlet mailServlet = WebXmlUtils.addServlet(root, "MailConfirmationServlet", //$NON-NLS-1$
            "org.eclipse.stardust.engine.extensions.mail.web.servlet.MailApplicationReceptionServlet"); //$NON-NLS-1$
      WebXmlUtils.addServletParam(mailServlet, "successPage", ""); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addServletParam(mailServlet, "errorPage", ""); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addServletParam(mailServlet, "user", "motu"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addServletParam(mailServlet, "password", "motu"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addServletMapping(root, mailServlet, "/mail-confirmation"); //$NON-NLS-1$

      Servlet dmsContentServlet = WebXmlUtils.addServlet(root, "DmsContentServlet", //$NON-NLS-1$
            "org.eclipse.stardust.engine.api.web.dms.DmsContentServlet"); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, dmsContentServlet, "/dms-content/*"); //$NON-NLS-1$

      Servlet skinContentServlet = WebXmlUtils.addServlet(root, "SkinContentServlet", //$NON-NLS-1$
      "org.eclipse.stardust.ui.client.dms.SkinContentServlet"); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, skinContentServlet, "/skin-content/*"); //$NON-NLS-1$

      Servlet fsdContentServlet = WebXmlUtils.addServlet(root, "FsdContentServlet", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.viewscommon.docmgmt.FileSystemDocumentServlet"); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, fsdContentServlet, "/fsd-content/*"); //$NON-NLS-1$

      Servlet pfs = WebXmlUtils.addServlet(root, "Persistent Faces Servlet", //$NON-NLS-1$
            "com.icesoft.faces.webapp.xmlhttp.PersistentFacesServlet", 1); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, pfs, "*.iface"); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, pfs, "/xmlhttp/*"); //$NON-NLS-1$

      Servlet bs = WebXmlUtils.addServlet(root, "Blocking Servlet", //$NON-NLS-1$
            "com.icesoft.faces.webapp.xmlhttp.BlockingServlet", 1); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, bs, "/block/*"); //$NON-NLS-1$

      // JAX-WS CXF
      Servlet jaxWsServlet = WebXmlUtils.addServlet(root, "cxf-jaxws-servlet", //$NON-NLS-1$
            "org.eclipse.stardust.engine.ws.servlet.DynamicCXFServlet"); //$NON-NLS-1$
      WebXmlUtils.addServletParam(jaxWsServlet,
            "config-location", //$NON-NLS-1$
            "classpath*:META-INF/spring/cxf/*ws-cxf-context.xml,WEB-INF/jax-ws-cxf-context.xml"); //$NON-NLS-1$

      WebXmlUtils.addServletMapping(root, jaxWsServlet, "/services/soap/*"); //$NON-NLS-1$

      // JAX-RS CXF
      Servlet jaxRsServlet = WebXmlUtils.addServlet(root, "cxf-jaxrs-servlet", //$NON-NLS-1$
            "org.apache.cxf.transport.servlet.CXFServlet"); //$NON-NLS-1$
      WebXmlUtils.addServletParam(jaxRsServlet,
            "config-location", //$NON-NLS-1$
            "classpath*:META-INF/spring/cxf/*rs-cxf-context.xml"); //$NON-NLS-1$

      WebXmlUtils.addServletMapping(root, jaxRsServlet, "/services/rest/*"); //$NON-NLS-1$

      // Add spring related settings
      WebXmlUtils.addListener(root,
            "org.springframework.web.context.ContextLoaderListener"); //$NON-NLS-1$

      Servlet springRemotingServlet = WebXmlUtils.addServlet(root,
            "carnot-spring-remoting", //$NON-NLS-1$
            "org.springframework.web.servlet.DispatcherServlet"); //$NON-NLS-1$
      WebXmlUtils.addServletParam(springRemotingServlet, "contextConfigLocation", //$NON-NLS-1$
            "/WEB-INF/config/ipp/spring/carnot-spring-remoting-servlet.xml"); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, springRemotingServlet, "/remoting/*"); //$NON-NLS-1$

      WebXmlUtils.addWelcomeFileList(root, new String[] {"index.jsp"}); //$NON-NLS-1$

      WebXmlUtils.addResourceRef(root, "jdbc/AuditTrail.DataSource", //$NON-NLS-1$
            "javax.sql.DataSource", true); //$NON-NLS-1$

      //////////////////////////////

      WebXmlUtils.addListener(root, "org.springframework.web.context.ContextLoaderListener"); //$NON-NLS-1$
      WebXmlUtils.addListener(root, "org.springframework.web.context.request.RequestContextListener"); //$NON-NLS-1$

      WebXmlUtils.addContextParamValue(root, "contextConfigLocation", "classpath*:META-INF/spring/*-context.xml"); //$NON-NLS-1$ //$NON-NLS-2$

      Servlet ippPdfServlet = WebXmlUtils.addServlet(root, "IppPdfRendererServlet", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.viewscommon.views.document.pdf.viewer.PdfRenderer", 1); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, ippPdfServlet, "/IppPdfRenderer"); //$NON-NLS-1$

      Servlet ippTiffServlet = WebXmlUtils.addServlet(root, "IppTiffRendererServlet", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.viewscommon.views.document.tiff.TiffRenderer", 1); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, ippTiffServlet, "/IppTiffRenderer"); //$NON-NLS-1$

      Filter birtSessionFilter = WebXmlUtils.addFilter(root, "BirtSessionFilter", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.bcc.reporting.BirtSessionFilter"); //$NON-NLS-1$
      WebXmlUtils.addFilterMapping(root, birtSessionFilter, "/frameset"); //$NON-NLS-1$

      Servlet ippUploadServlet = WebXmlUtils.addServlet(root, "IppUploadServlet", //$NON-NLS-1$
            "com.icesoft.faces.component.inputfile.FileUploadServlet", 1); //$NON-NLS-1$
      WebXmlUtils.addServletMapping(root, ippUploadServlet, "/uploadHtml"); //$NON-NLS-1$

      Filter contentFilter = WebXmlUtils.addFilter(root, "portalPluginContentFilter", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.plugin.support.PortalPluginContentFilter"); //$NON-NLS-1$
      WebXmlUtils.addFilterMapping(root, contentFilter, "/plugins/*"); //$NON-NLS-1$
      WebXmlUtils.addFilterMapping(root, contentFilter, "/skins/*"); //$NON-NLS-1$

      Filter loginFilter = WebXmlUtils.addFilter(root, "IppPortalLoginFilter", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.viewscommon.login.filter.LoginFilter"); //$NON-NLS-1$
      WebXmlUtils.addFilterMapping(root, loginFilter, "*.iface", new //$NON-NLS-1$
            String[] { "REQUEST" , "FORWARD" }); //$NON-NLS-1$ //$NON-NLS-2$

      Filter charsetFilter = WebXmlUtils.addFilter(root, "IppPortalCharsetFilter", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.viewscommon.common.CharsetFilter"); //$NON-NLS-1$
      WebXmlUtils.addFilterParam(charsetFilter, "requestEncoding", "UTF-8"); //$NON-NLS-1$ //$NON-NLS-2$
      WebXmlUtils.addFilterMapping(root, charsetFilter, "/uploadHtml"); //$NON-NLS-1$

      Filter touchSessionFilter = WebXmlUtils.addFilter(root, "touchSessionFilter", //$NON-NLS-1$
      "com.icesoft.faces.webapp.http.servlet.TouchSessionFilter"); //$NON-NLS-1$
      WebXmlUtils.addFilterMapping(root, touchSessionFilter, "/services/rest/*"); //$NON-NLS-1$

      new WebModuleConfigurator(WebModuleConfigurator.INSTALL_CONFIGURATOR_ELEM_ID)
         .performConfiguration(artifact);
   }
}