/*******************************************************************************
 * Copyright (c) 2011, 2012 SunGard CSA LLC and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SunGard CSA LLC - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.stardust.ide.wst.facet.portal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.*;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.ide.wst.common.ExternalLibrary;
import org.eclipse.stardust.ide.wst.common.IModuleConfigurator;
import org.eclipse.stardust.ide.wst.common.IWebModuleConfigurator;
import org.eclipse.stardust.ide.wst.common.utils.FacetSetupUtils;
import org.eclipse.stardust.ide.wst.common.utils.ProjectSetupUtils;
import org.eclipse.stardust.ide.wst.common.utils.WebXmlUtils;
import org.eclipse.stardust.modeling.common.projectnature.BpmProjectNature;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/**
 * @author rsauer
 * @version $Revision: 33052 $
 */
public class UninstallDelegate extends AbstractDelegate implements IModuleConfigurator,
      IWebModuleConfigurator
{
   public void execute(final IProject project, final IProjectFacetVersion fv,
         final Object config, final IProgressMonitor monitor) throws CoreException
   {
      monitor.beginTask("", 3); //$NON-NLS-1$
      try
      {
         FacetSetupUtils.configureModule(project, this);
         monitor.worked(1);
         FacetSetupUtils.configureWebModule(project, this);
         monitor.worked(1);
         BpmProjectNature.disableBpmNature(project);
         monitor.worked(1);

         final IFolder resourceFolder =
            ProjectSetupUtils.getIppResourceFolder(project);
         final IFolder configFolder =
            ProjectSetupUtils.getIppConfigFolder(project);

         final IFolder processPortalRoot = project.getFolder(IPPPortalFacet.PORTAL_ROOT);
         if (processPortalRoot.exists())
         {
            new UIJob(Portals_Messages.TXT_INFINITY_PORTAL_FACET)
            {
               public IStatus runInUIThread(IProgressMonitor monitor)
               {
                  IFolder _configFolder = configFolder;
                  Object[] msgParams = new Object[] {
                        IPPPortalFacet.PORTAL_ROOT,
                        "", ""}; //$NON-NLS-1$ //$NON-NLS-2$
                  StringBuffer msgTemplate = new StringBuffer("Should the ''{0}'' "); //$NON-NLS-1$
                  if(resourceFolder != null && resourceFolder.exists())
                  {
                     msgTemplate.append("and ''{1}'' "); //$NON-NLS-1$
                     msgParams[1] = resourceFolder.getProjectRelativePath().toOSString();
                  }
                  msgTemplate.append("folder "); //$NON-NLS-1$
                  if(_configFolder != null && _configFolder.exists())
                  {
                     try
                     {
                        msgTemplate.append("and the content of ''{2}'' "); //$NON-NLS-1$
                        if(((IFolder)_configFolder.getParent()).members().length == 1)
                        {
                           // only ipp folder exists, so we can drop the whole config folder
                           _configFolder = (IFolder) _configFolder.getParent();
                        }
                     }
                     catch(CoreException e)
                     {}
                     msgParams[2] = _configFolder.getProjectRelativePath().toOSString();
                  }
                  msgTemplate.append("be deleted?"); //$NON-NLS-1$
                  if (MessageDialog.openQuestion(null, "Infinity Portal Facet", //$NON-NLS-1$
                        MessageFormat.format(msgTemplate.toString(), msgParams)))
                  {
                     try
                     {
                        invokeDelegateExtensions(UNINSTALL_DELEGATE_ELEM_ID, project, fv, config, monitor);

                        processPortalRoot.refreshLocal(IResource.DEPTH_INFINITE, monitor);
                        processPortalRoot.delete(false, monitor);
                        if(resourceFolder != null && resourceFolder.exists())
                        {
                           resourceFolder.delete(false, monitor);
                        }
                        if(_configFolder != null && _configFolder.exists())
                        {
                           _configFolder.delete(false, monitor);
                           IProject project = _configFolder.getProject();
                           if(project.hasNature(JavaCore.NATURE_ID))
                           {
                              IJavaProject javaProject = JavaCore.create(project);
                              IClasspathEntry cpEntries[] = javaProject.getRawClasspath();
                              List<IClasspathEntry> cpEntriesList = CollectionUtils.newArrayList();
                              IPath proRelPath = new Path("/" + project.getName() + "/" + resourceFolder.getProjectRelativePath()); //$NON-NLS-1$ //$NON-NLS-2$
                              for(int i = 0; i < cpEntries.length; ++i)
                              {
                                 IClasspathEntry entry = cpEntries[i];
                                 if(IClasspathEntry.CPE_SOURCE == entry.getEntryKind() &&
                                       proRelPath.equals(entry.getPath()))
                                 {
                                    // skip our ipp-resource folder
                                    continue;
                                 }
                                 else
                                 {
                                    cpEntriesList.add(entry);
                                 }
                              }
                              cpEntries = new IClasspathEntry[cpEntriesList.size()];
                              cpEntriesList.toArray(cpEntries);
                              javaProject.setRawClasspath(cpEntries, null);
                           }
                        }
                     }
                     catch (CoreException e)
                     {
                        MessageDialog
                              .openWarning(
                                    null,
                                    Portals_Messages.MSG_DIA_WARNING,
                                    Portals_Messages.MSG_DIA_PROBLEMS_ENCOUNTERED_WHILE_DELETING_RESOURCE);
                        e.printStackTrace();
                     }
                  }
                  return Status.OK_STATUS;
               }
            }.schedule();
         }
      }
      finally
      {
         monitor.done();
      }
   }

   public void performConfiguration(ArtifactEdit artifact)
   {
      new WebModuleConfigurator(WebModuleConfigurator.UNINSTALL_CONFIGURATOR_ELEM_ID)
         .performConfiguration(artifact);

      ExternalLibrary[] externalLibs = IPPPortalFacet.getExternalLibraries();
      ExternalLibrary[] externalSpringLibs = IPPPortalFacet.getExternalSpringLibraries();
      ExternalLibrary[] deprecatedLibs = IPPPortalFacet.getDeprecatedLibraries();

      List<ExternalLibrary> springLibs = new ArrayList<ExternalLibrary>();
      springLibs.add(IPPPortalBundleActivator.getInstance().resolveExternalLibrary(
            "carnot-spring.jar")); //$NON-NLS-1$
      springLibs.add(IPPPortalBundleActivator.getInstance().resolveExternalLibrary(
            "carnot-hibernate.jar")); //$NON-NLS-1$

      List<ExternalLibrary> libs = new ArrayList<ExternalLibrary>();
      libs.addAll(Arrays.asList(externalLibs));
      libs.addAll(Arrays.asList(externalSpringLibs));
      libs.addAll(springLibs);
      libs.addAll(Arrays.asList(deprecatedLibs));

      List<IVirtualReference> refs = new ArrayList<IVirtualReference>(
            Arrays.asList(artifact.getComponent().getReferences()));
      for (ExternalLibrary lib : libs)
      {
         String libName = "var/" + lib.var + "/" + lib.extension; //$NON-NLS-1$ //$NON-NLS-2$

         for (Iterator<IVirtualReference> refItr = refs.iterator(); refItr.hasNext();)
         {
            IVirtualReference ref = refItr.next();
            IVirtualComponent component = ref.getReferencedComponent();
            if ((null != component) && libName.equals(component.getName()))
            {
               refItr.remove();
            }
         }
      }

      artifact.getComponent().setReferences(
            (IVirtualReference[]) refs.toArray(new IVirtualReference[0]));

      try
      {
         IVirtualFolder root = artifact.getComponent().getRootFolder();

         String portalRoot = "/" + IPPPortalFacet.PORTAL_ROOT; //$NON-NLS-1$
         root.removeLink(new Path(portalRoot), 0, null);
      }
      catch (CoreException ce)
      {

      }
   }

   public void performConfiguration(WebArtifactEdit artifact)
   {
      new WebModuleConfigurator(WebModuleConfigurator.UNINSTALL_CONFIGURATOR_ELEM_ID)
         .performConfiguration(artifact);

      final WebApp root = artifact.getWebApp();

      WebXmlUtils.removeContextParam(root, "javax.faces.STATE_SAVING_METHOD"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "facelets.DEVELOPMENT"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "facelets.SKIP_COMMENTS"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "facelets.VIEW_MAPPINGS"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "javax.faces.CONFIG_FILES"); //$NON-NLS-1$

      WebXmlUtils.removeContextParam(root, "ag.carnot.processportal.integration.ADMIN_PORTAL_URL"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "ag.carnot.processportal.integration.REPORTING_URL"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "ag.carnot.processportal.integration.BUSINESSCONTROLCENTER_URL"); //$NON-NLS-1$

      WebXmlUtils.removeContextParam(root, "javax.faces.DEFAULT_SUFFIX"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "com.icesoft.faces.delegateNonIface"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "com.icesoft.faces.synchronousUpdate"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "com.icesoft.faces.concurrentDOMViews"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "com.icesoft.faces.ignoreUserRoleAttributes"); //$NON-NLS-1$

      WebXmlUtils.removeContextParam(root, "org.apache.myfaces.trinidad.DISABLE_DIALOG_OUTCOMES"); //$NON-NLS-1$

      // remove related spring setting
      WebXmlUtils.removeContextParam(root, "contextConfigLocation"); //$NON-NLS-1$

      WebXmlUtils.removeContextParam(root, "carnot.login.APPLICATION_ID"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "carnot.login.ADMINISTRATOR_ROLE_REQUIRED"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "carnot.login.MODEL_REQUIRED"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "carnot.login.HEADING"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "com.infinity.bpm.portal.common.logoutURI"); //$NON-NLS-1$

      WebXmlUtils.removeContextParam(root, "carnot.SESSION_LISTENERS"); //$NON-NLS-1$

      //
      WebXmlUtils.removeContextParam(root, "com.icesoft.faces.sessionExpiredRedirectURI"); //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "com.icesoft.faces.uploadMaxFileSize");       //$NON-NLS-1$
      WebXmlUtils.removeContextParam(root, "facelets.RESOURCE_RESOLVER");       //$NON-NLS-1$

      WebXmlUtils.removeListener(root,
            "org.apache.myfaces.webapp.StartupServletContextListener"); //$NON-NLS-1$
      WebXmlUtils.removeListener(root,
            "ag.carnot.web.jsf.common.SessionContextListener"); //$NON-NLS-1$
      WebXmlUtils.removeListener(root,
            "com.infinity.bpm.portal.common.listener.SessionContextListener"); //$NON-NLS-1$
      WebXmlUtils.removeListener(root,
            "org.eclipse.stardust.ui.web.common.listener.SessionContextListener"); //$NON-NLS-1$
      WebXmlUtils.removeListener(root,
            "org.eclipse.stardust.ui.web.viewscommon.common.listener.SessionContextListener"); //$NON-NLS-1$
      WebXmlUtils.removeListener(root,
            "org.eclipse.stardust.ui.web.jsf.common.PortalPluginFaceletsResourceResolver"); //$NON-NLS-1$
      WebXmlUtils.removeListener(root,
            "org.eclipse.stardust.ui.web.viewscommon.common.PortalPluginFaceletsResourceResolver"); //$NON-NLS-1$
      WebXmlUtils.removeListener(root,
            "com.icesoft.faces.util.event.servlet.ContextEventRepeater"); //$NON-NLS-1$

      Servlet facesServlet = WebXmlUtils.findServlet(root, "faces", //$NON-NLS-1$
            "javax.faces.webapp.FacesServlet"); //$NON-NLS-1$
      WebXmlUtils.removeServletMapping(root, facesServlet, "/faces/*"); //$NON-NLS-1$
      WebXmlUtils.removeServlet(root, facesServlet);

      // Remove only as trinidad no longer availables
      Servlet resourceServlet = WebXmlUtils.findServlet(root, "ResourceServlet", //$NON-NLS-1$
            "org.apache.myfaces.trinidad.webapp.ResourceServlet"); //$NON-NLS-1$
      if (resourceServlet != null)
      {
         WebXmlUtils.removeServletMapping(root, resourceServlet, "/adf/*"); //$NON-NLS-1$
         WebXmlUtils.removeServletMapping(root, resourceServlet, "/skins/*"); //$NON-NLS-1$
         WebXmlUtils.removeServletMapping(root, resourceServlet, "/plugins/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, resourceServlet);
      }

      Servlet executorServlet = WebXmlUtils.findServlet(root, "jspExecutor", //$NON-NLS-1$
            "ag.carnot.web.jsf.processportal.ExecutorServlet"); //$NON-NLS-1$
      WebXmlUtils.removeServletMapping(root, executorServlet, "/executor.jsp"); //$NON-NLS-1$
      WebXmlUtils.removeServlet(root, executorServlet);

      Servlet mailServlet = WebXmlUtils.findServlet(root, "MailConfirmationServlet", //$NON-NLS-1$
            "org.eclipse.stardust.engine.extensions.mail.web.servlet.MailApplicationReceptionServlet"); //$NON-NLS-1$
      if (null != mailServlet)
      {
         WebXmlUtils.removeServletMapping(root, mailServlet, "/mail-confirmation"); //$NON-NLS-1$
         WebXmlUtils.removeServletParam(mailServlet, "successPage"); //$NON-NLS-1$
         WebXmlUtils.removeServletParam(mailServlet, "errorPage"); //$NON-NLS-1$
         WebXmlUtils.removeServletParam(mailServlet, "user"); //$NON-NLS-1$
         WebXmlUtils.removeServletParam(mailServlet, "password"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, mailServlet);
      }

      // remove pre-Stardust version of the servlet
      Servlet dmsContentServlet = WebXmlUtils.findServlet(root, "DmsContentServlet", //$NON-NLS-1$
            "com.infinity.bpm.web.dms.DmsContentServlet"); //$NON-NLS-1$
      if (null != dmsContentServlet)
      {
         WebXmlUtils.removeServletMapping(root, dmsContentServlet, "/dms-content/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, dmsContentServlet);
      }

      dmsContentServlet = WebXmlUtils.findServlet(root, "DmsContentServlet", //$NON-NLS-1$
            "org.eclipse.stardust.engine.api.web.dms.DmsContentServlet"); //$NON-NLS-1$
      if (null != dmsContentServlet)
      {
         WebXmlUtils.removeServletMapping(root, dmsContentServlet, "/dms-content/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, dmsContentServlet);
      }

      Servlet skinContentServlet = WebXmlUtils.findServlet(root, "SkinContentServlet", //$NON-NLS-1$
            "org.eclipse.stardust.ui.client.dms.SkinContentServlet"); //$NON-NLS-1$
      if (null != skinContentServlet)
      {
         WebXmlUtils.removeServletMapping(root, skinContentServlet, "/skin-content/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, skinContentServlet);
      }

      Servlet fsdContentServlet = WebXmlUtils.findServlet(root, "FsdContentServlet", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.viewscommon.docmgmt.FileSystemDocumentServlet"); //$NON-NLS-1$
      if (null != fsdContentServlet)
      {
         WebXmlUtils.removeServletMapping(root, fsdContentServlet, "/fsd-content/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, fsdContentServlet);
      }

      Servlet dmsContentProxyServlet = WebXmlUtils.findServlet(root, "DmsContentProxyServlet", //$NON-NLS-1$
            "com.sungard.infinity.bpm.vfs.impl.jcr.web.ProxyVfsContentServlet"); //$NON-NLS-1$
      if (null != dmsContentProxyServlet)
      {
         WebXmlUtils.removeServletMapping(root, dmsContentProxyServlet,
               "/dms-content-proxy/*"); //$NON-NLS-1$
         WebXmlUtils.removeServletParam(dmsContentProxyServlet, "contentServletUri"); //$NON-NLS-1$
         WebXmlUtils.removeServletParam(dmsContentProxyServlet, "connectionTimeout"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, dmsContentProxyServlet);
      }
      dmsContentProxyServlet = WebXmlUtils.findServlet(root, "DmsContentProxyServlet", //$NON-NLS-1$
         "org.eclipse.stardust.vfs.impl.jcr.web.ProxyVfsContentServlet"); //$NON-NLS-1$
      if (null != dmsContentProxyServlet)
      {
         WebXmlUtils.removeServletMapping(root, dmsContentProxyServlet,
               "/dms-content-proxy/*"); //$NON-NLS-1$
         WebXmlUtils.removeServletParam(dmsContentProxyServlet, "contentServletUri"); //$NON-NLS-1$
         WebXmlUtils.removeServletParam(dmsContentProxyServlet, "connectionTimeout"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, dmsContentProxyServlet);
      }

      // Remove only as trinidad no longer availables
      Filter adfFacesFilter = WebXmlUtils.findFilter(root, "adfFaces", //$NON-NLS-1$
            "org.apache.myfaces.trinidad.webapp.TrinidadFilter"); //$NON-NLS-1$
      if (adfFacesFilter != null)
      {
         WebXmlUtils.removeFilterMapping(root, adfFacesFilter, facesServlet);
         WebXmlUtils.removeFilter(root, adfFacesFilter);
      }

      Filter tomahawkFilter = WebXmlUtils.findFilter(root, "MyFacesExtensionsFilter", //$NON-NLS-1$
            "org.apache.myfaces.webapp.filter.ExtensionsFilter"); //$NON-NLS-1$
      WebXmlUtils.removeFilterParam(tomahawkFilter, "maxFileSize"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, tomahawkFilter, facesServlet);
      WebXmlUtils.removeFilterMapping(root, tomahawkFilter, "/faces/myFacesExtensionResource/*"); //$NON-NLS-1$
      WebXmlUtils.removeFilter(root, tomahawkFilter);

      Filter loginFilter = WebXmlUtils.findFilter(root, "LoginFilter", //$NON-NLS-1$
            "ag.carnot.web.jsf.common.LoginFilter"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, loginFilter, "*.jspx"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, loginFilter, "*.xhtml"); //$NON-NLS-1$
      WebXmlUtils.removeFilter(root, loginFilter);

      // remove pre-Stardust version of the filter
      loginFilter = WebXmlUtils.findFilter(root, "IppPortalLoginFilter", //$NON-NLS-1$
         "com.infinity.bpm.portal.common.filter.LoginFilter"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, loginFilter, "*.iface"); //$NON-NLS-1$
      WebXmlUtils.removeFilter(root, loginFilter);

      loginFilter = WebXmlUtils.findFilter(root, "IppPortalLoginFilter", //$NON-NLS-1$
         "org.eclipse.stardust.ui.web.viewscommon.login.filter.LoginFilter"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, loginFilter, "*.iface"); //$NON-NLS-1$
      WebXmlUtils.removeFilter(root, loginFilter);

      // remove pre-Stardust version of the filter
      Filter pluginFilter = WebXmlUtils.findFilter(root, "portalPluginContentFilter", //$NON-NLS-1$
            "com.infinity.bpm.portal.plugin.support.PortalPluginContentFilter"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, pluginFilter, "/plugins/*"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, pluginFilter, "/skins/*"); //$NON-NLS-1$
      WebXmlUtils.removeFilter(root, pluginFilter);

      pluginFilter = WebXmlUtils.findFilter(root, "portalPluginContentFilter", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.plugin.support.PortalPluginContentFilter"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, pluginFilter, "/plugins/*"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, pluginFilter, "/skins/*"); //$NON-NLS-1$
      WebXmlUtils.removeFilter(root, pluginFilter);

      Servlet pfs = WebXmlUtils.findServlet(root, "Persistent Faces Servlet", //$NON-NLS-1$
            "com.icesoft.faces.webapp.xmlhttp.PersistentFacesServlet"); //$NON-NLS-1$
      if (null != pfs)
      {
         WebXmlUtils.removeServletMapping(root, pfs, "*.iface"); //$NON-NLS-1$
         WebXmlUtils.removeServletMapping(root, pfs, "/xmlhttp/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, pfs);
      }

      Servlet bs = WebXmlUtils.findServlet(root, "Blocking Servlet", //$NON-NLS-1$
            "com.icesoft.faces.webapp.xmlhttp.BlockingServlet"); //$NON-NLS-1$
      if (null != bs)
      {
         WebXmlUtils.removeServletMapping(root, bs, "/block/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, bs);
      }

      // JAX-WS CXF
      Servlet cxfJaxWsServlet = WebXmlUtils.findServlet(root, "cxf-jaxws-servlet", //$NON-NLS-1$
            "org.eclipse.stardust.engine.ws.servlet.DynamicCXFServlet"); //$NON-NLS-1$
      if (null != cxfJaxWsServlet)
      {
         WebXmlUtils.removeServletMapping(root, cxfJaxWsServlet, "/services/soap/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, cxfJaxWsServlet);
      }

      // JAX-WS Metro for older releases
      WebXmlUtils.removeListener(root,
            "com.sun.xml.ws.transport.http.servlet.WSServletContextListener"); //$NON-NLS-1$

      Servlet jaxWsServlet = WebXmlUtils.findServlet(root, "jaxws-servlet", //$NON-NLS-1$
            "com.sun.xml.ws.transport.http.servlet.WSServlet"); //$NON-NLS-1$
      if (null != jaxWsServlet)
      {
         WebXmlUtils.removeServletMapping(root, jaxWsServlet, "/services/soap/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, jaxWsServlet);
      }
      jaxWsServlet = WebXmlUtils.findServlet(root, "jaxws-servlet", //$NON-NLS-1$
            "com.infinity.bpm.rt.impl.api.ws.servlet.IppWsServlet"); //$NON-NLS-1$
      if (null != jaxWsServlet)
      {
         WebXmlUtils.removeServletMapping(root, jaxWsServlet, "/services/soap/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, jaxWsServlet);
      }

      // JAX-RS CXF
      Servlet jaxRsServlet2 = WebXmlUtils.findServlet(root, "cxf-jaxrs-servlet", //$NON-NLS-1$
            "org.apache.cxf.transport.servlet.CXFServlet"); //$NON-NLS-1$
      if (null != jaxRsServlet2)
      {
         WebXmlUtils.removeServletMapping(root, jaxRsServlet2, "/services/rest/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, jaxRsServlet2);
      }

      // JAX-RS Jersey for older releases
      Servlet jaxRsServlet = WebXmlUtils.findServlet(root, "jersey-jaxrs-servlet", //$NON-NLS-1$
            "com.sun.jersey.spi.container.servlet.ServletContainer"); //$NON-NLS-1$
      if (null != jaxRsServlet)
      {
         WebXmlUtils.removeServletMapping(root, jaxRsServlet, "/services/rest/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, jaxRsServlet);
      }

      // remove spring related settings
      WebXmlUtils.removeListener(root,
            "org.springframework.web.context.ContextLoaderListener"); //$NON-NLS-1$

      Servlet springRemotingServlet = WebXmlUtils.findServlet(root,
            "carnot-spring-remoting", //$NON-NLS-1$
            "org.springframework.web.servlet.DispatcherServlet"); //$NON-NLS-1$
      WebXmlUtils.removeServletMapping(root, springRemotingServlet, "/remoting/*"); //$NON-NLS-1$
      WebXmlUtils.removeServletParam(springRemotingServlet, "contextConfigLocation"); //$NON-NLS-1$
      WebXmlUtils.removeServlet(root, springRemotingServlet);

      ResourceRef auditTrail = WebXmlUtils.findResourceRef(root,
            "jdbc/AuditTrail.DataSource", "javax.sql.DataSource"); //$NON-NLS-1$ //$NON-NLS-2$
      if(null != auditTrail)
      {
         WebXmlUtils.removeResourceRef(root, auditTrail);
      }

      //////////

      WebXmlUtils.removeListener(root, "org.springframework.web.context.ContextLoaderListener"); //$NON-NLS-1$
      WebXmlUtils.removeListener(root, "org.springframework.web.context.request.RequestContextListener"); //$NON-NLS-1$

      // don't remove contextConfigLocation entries as they are needed by Context Portal, too
      //WebXmlUtils.removeContextParamValue(root, "contextConfigLocation", "classpath*:META-INF/spring/*-context.xml");
      //...

      // old bccPdfRendererServlet used before package name was refactored
      Servlet pdfServlet = WebXmlUtils.findServlet(root,
            "bccPdfRendererServlet", //$NON-NLS-1$
            "com.infinity.bpm.portal.business_control_center.pdf.PdfRenderer"); //$NON-NLS-1$
      if (null != pdfServlet)
      {
         WebXmlUtils.removeServletMapping(root, pdfServlet, "/bccPdfRenderer"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, pdfServlet);
      }

      // bccPdfRendererServlet after package name refactoring
      pdfServlet = WebXmlUtils.findServlet(root,
            "bccPdfRendererServlet", //$NON-NLS-1$
            "com.infinity.bpm.portal.bcc.pdf.PdfRenderer"); //$NON-NLS-1$
      if (null != pdfServlet)
      {
         WebXmlUtils.removeServletMapping(root, pdfServlet, "/bccPdfRenderer"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, pdfServlet);
      }

      pdfServlet = WebXmlUtils.findServlet(root,
            "IPPPdfRendererServlet", //$NON-NLS-1$
            "com.infinity.bpm.ui.web.viewscommon.views.document.pdf.PdfRenderer"); //$NON-NLS-1$
      if (null != pdfServlet)
      {
         WebXmlUtils.removeServletMapping(root, pdfServlet, "/IPPPdfRenderer"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, pdfServlet);
      }

      // remove pre-Stardust version of the servlet
      pdfServlet = WebXmlUtils.findServlet(root,
            "IppPdfRendererServlet", //$NON-NLS-1$
            "com.infinity.bpm.ui.web.viewscommon.views.document.pdf.PdfRenderer"); //$NON-NLS-1$
      if (null != pdfServlet)
      {
         WebXmlUtils.removeServletMapping(root, pdfServlet, "/IppPdfRenderer"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, pdfServlet);
      }

      pdfServlet = WebXmlUtils.findServlet(root,
            "IppPdfRendererServlet", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.viewscommon.views.document.pdf.viewer.PdfRenderer"); //$NON-NLS-1$
      if (null != pdfServlet)
      {
         WebXmlUtils.removeServletMapping(root, pdfServlet, "/IppPdfRenderer"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, pdfServlet);
      }

      // remove pre-Stardust version of the servlet
      Servlet tiffServlet = WebXmlUtils.findServlet(root,
            "IppTiffRendererServlet", //$NON-NLS-1$
            "com.infinity.bpm.ui.web.viewscommon.views.document.tiff.TiffRenderer"); //$NON-NLS-1$
      if (null != tiffServlet)
      {
         WebXmlUtils.removeServletMapping(root, tiffServlet, "/IppTiffRenderer"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, tiffServlet);
      }

      tiffServlet = WebXmlUtils.findServlet(root,
            "IppTiffRendererServlet", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.viewscommon.views.document.tiff.TiffRenderer"); //$NON-NLS-1$
      if (null != tiffServlet)
      {
         WebXmlUtils.removeServletMapping(root, tiffServlet, "/IppTiffRenderer"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, tiffServlet);
      }

      // old BirtSessionFilter used before package name was refactored
      Filter birtSessionFilter = WebXmlUtils.findFilter(root, "BirtSessionFilter", "com.infinity.bpm.portal.business_control_center.reporting.BirtSessionFilter"); //$NON-NLS-1$ //$NON-NLS-2$
      if (null != birtSessionFilter)
      {
         WebXmlUtils.removeFilter(root, birtSessionFilter);
         WebXmlUtils.removeFilterMapping(root, birtSessionFilter, "/frameset"); //$NON-NLS-1$
      }

      // Remove pre-Stardust version of the filter
      birtSessionFilter = WebXmlUtils.findFilter(root, "BirtSessionFilter", "com.infinity.bpm.portal.bcc.reporting.BirtSessionFilter"); //$NON-NLS-1$ //$NON-NLS-2$
      if (null != birtSessionFilter)
      {
         WebXmlUtils.removeFilter(root, birtSessionFilter);
         WebXmlUtils.removeFilterMapping(root, birtSessionFilter, "/frameset"); //$NON-NLS-1$
      }

      birtSessionFilter = WebXmlUtils.findFilter(root, "BirtSessionFilter", "org.eclipse.stardust.ui.web.bcc.reporting.BirtSessionFilter"); //$NON-NLS-1$ //$NON-NLS-2$
      if (null != birtSessionFilter)
      {
         WebXmlUtils.removeFilter(root, birtSessionFilter);
         WebXmlUtils.removeFilterMapping(root, birtSessionFilter, "/frameset"); //$NON-NLS-1$
      }

      Servlet bccUploadServlet = WebXmlUtils.findServlet(root,
            "bccUploadServlet", //$NON-NLS-1$
            "com.icesoft.faces.component.inputfile.FileUploadServlet"); //$NON-NLS-1$
      if (null != bccUploadServlet)
      {
         WebXmlUtils.removeServletMapping(root, bccUploadServlet, "/uploadHtml"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, bccUploadServlet);
      }

      Servlet ippUploadServlet = WebXmlUtils.findServlet(root,
            "IppUploadServlet", //$NON-NLS-1$
            "com.icesoft.faces.component.inputfile.FileUploadServlet"); //$NON-NLS-1$
      if (null != ippUploadServlet)
      {
         WebXmlUtils.removeServletMapping(root, ippUploadServlet, "/uploadHtml"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, ippUploadServlet);
      }

      Servlet atmosphereMeteorServlet = WebXmlUtils.findServlet(root,
            "Atmosphere - Meteor Servlet", //$NON-NLS-1$
            "org.atmosphere.cpr.MeteorServlet"); //$NON-NLS-1$
      if (null != atmosphereMeteorServlet)
      {
         WebXmlUtils.removeServletMapping(root, atmosphereMeteorServlet, "/services/streaming/*"); //$NON-NLS-1$
         WebXmlUtils.removeServlet(root, atmosphereMeteorServlet);
      }

      // Remove pre-Stardust version of the filter
      Filter charsetFilter = WebXmlUtils.findFilter(root, "IppPortalCharsetFilter", //$NON-NLS-1$
            "com.infinity.bpm.ui.web.viewscommon.common.CharsetFilter"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, charsetFilter, "/uploadHtml"); //$NON-NLS-1$
      WebXmlUtils.removeFilter(root, charsetFilter);

      charsetFilter = WebXmlUtils.findFilter(root, "IppPortalCharsetFilter", //$NON-NLS-1$
            "org.eclipse.stardust.ui.web.viewscommon.common.CharsetFilter"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, charsetFilter, "/uploadHtml"); //$NON-NLS-1$
      WebXmlUtils.removeFilter(root, charsetFilter);

      Filter touchSessionFilter = WebXmlUtils.findFilter(root, "touchSessionFilter", //$NON-NLS-1$
      "com.icesoft.faces.webapp.http.servlet.TouchSessionFilter"); //$NON-NLS-1$
      WebXmlUtils.removeFilterMapping(root, touchSessionFilter, "/services/rest/*"); //$NON-NLS-1$
      WebXmlUtils.removeFilter(root, touchSessionFilter);
   }
}