/*******************************************************************************
 * Copyright (c) 2011, 2012 SunGard CSA LLC and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SunGard CSA LLC - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.stardust.ide.wst.facet.portal.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.stardust.ide.wst.facet.portal.IPPPortalBundleActivator;
import org.eclipse.stardust.ide.wst.facet.portal.Portals_Messages;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;



public class WorkbenchPreferencesPage extends PreferencePage
   implements IWorkbenchPreferencePage
{
   private Button chkHideInternalWebBrowserWarning;
   
   protected Control createContents(Composite parent)
   {
      Composite panel = FormBuilder.createComposite(parent, 3);

      this.chkHideInternalWebBrowserWarning = FormBuilder.createCheckBox(panel,
            Portals_Messages.BOX_DO_NOT_WARN_ON_USE_OF_INTERNAL_WEBBROWSER, 3);
      
      updateCheckBox();
      
      return panel;
   }

   public void init(IWorkbench workbench)
   {
      // TODO Auto-generated method stub
      
   }

   private void updateCheckBox()
   {
      chkHideInternalWebBrowserWarning.setSelection(
            PlatformUI.getPreferenceStore().getBoolean(
                  IPPPortalBundleActivator.BUNDLE_ID + ".hideInternalWebBrowserWarning")); //$NON-NLS-1$
   }
   
   public boolean performOk()
   {
      PlatformUI.getPreferenceStore().setValue(
            IPPPortalBundleActivator.BUNDLE_ID + ".hideInternalWebBrowserWarning", //$NON-NLS-1$
            chkHideInternalWebBrowserWarning.getSelection());
      return true;
   }
   
   protected void performDefaults()
   {
      PlatformUI.getPreferenceStore().setToDefault(
            IPPPortalBundleActivator.BUNDLE_ID + ".hideInternalWebBrowserWarning"); //$NON-NLS-1$
      updateCheckBox();
   }
}