/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum JoinSplitType implements Enumerator
{
    NONE_LITERAL(0, "None", "None"),
    XOR_LITERAL(1, "XOR", "XOR"),
    AND_LITERAL(2, "AND", "AND");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int NONE = 0;
    public static final int XOR = 1;
    public static final int AND = 2;
    private static final JoinSplitType[] VALUES_ARRAY;
    public static final List<JoinSplitType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new JoinSplitType[]{NONE_LITERAL, XOR_LITERAL, AND_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static JoinSplitType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JoinSplitType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JoinSplitType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JoinSplitType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JoinSplitType get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return XOR_LITERAL;
            }
            case 2: {
                return AND_LITERAL;
            }
        }
        return null;
    }

    private JoinSplitType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

